/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.statements;

import gw.config.CommonServices;
import gw.internal.gosu.parser.BeanAccess;
import gw.internal.gosu.parser.ErrorType;
import gw.internal.gosu.parser.Statement;
import gw.internal.gosu.parser.TypeLoaderAccess;
import gw.internal.gosu.parser.TypeLord;
import gw.internal.gosu.parser.expressions.Literal;
import gw.internal.gosu.parser.statements.NumberIterator;
import gw.internal.gosu.parser.statements.StringIterator;
import gw.lang.parser.GosuParserTypes;
import gw.lang.parser.StandardCoercionManager;
import gw.lang.parser.statements.ILoopStatement;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IPlaceholder;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.JavaTypes;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class LoopStatement
extends Statement
implements ILoopStatement {
    public static boolean isIteratorType(IType typeIn) {
        return typeIn.isArray() || typeIn instanceof ErrorType || JavaTypes.ITERABLE().isAssignableFrom(typeIn) || StandardCoercionManager.isStructurallyAssignable_Laxed((IType)JavaTypes.ITERABLE(), (IType)typeIn) || JavaTypes.ITERATOR().isAssignableFrom(typeIn) || typeIn == GosuParserTypes.STRING_TYPE() || typeIn instanceof IPlaceholder && ((IPlaceholder)typeIn).isPlaceholder();
    }

    public static IType getArrayComponentType(IType typeIn) {
        Object returnType;
        if (typeIn.isArray()) {
            returnType = typeIn.getComponentType();
        } else if (typeIn == GosuParserTypes.STRING_TYPE()) {
            returnType = GosuParserTypes.STRING_TYPE();
        } else if (BeanAccess.isNumericType(typeIn)) {
            returnType = JavaTypes.pINT();
        } else if (typeIn == JavaTypes.INTEGER_INTERVAL()) {
            returnType = JavaTypes.pINT();
        } else if (typeIn == JavaTypes.LONG_INTERVAL()) {
            returnType = JavaTypes.pLONG();
        } else if (typeIn instanceof IPlaceholder && ((IPlaceholder)typeIn).isPlaceholder()) {
            returnType = typeIn.getComponentType();
        } else {
            IType retType;
            IMethodInfo iteratorMethod;
            IType parameterized;
            if (typeIn.isGenericType() && !typeIn.isParameterizedType()) {
                typeIn = TypeLord.getDefaultParameterizedType(typeIn);
            }
            returnType = (parameterized = TypeLord.findParameterizedType(typeIn, (IType)JavaTypes.ITERABLE())) != null && parameterized.isParameterizedType() ? parameterized.getTypeParameters()[0] : ((parameterized = TypeLord.findParameterizedType(typeIn, (IType)JavaTypes.ITERATOR())) != null && parameterized.isParameterizedType() ? parameterized.getTypeParameters()[0] : ((iteratorMethod = typeIn.getTypeInfo().getMethod((CharSequence)"iterator", new IType[0])) != null && JavaTypes.ITERATOR().isAssignableFrom(iteratorMethod.getReturnType()) ? ((retType = iteratorMethod.getReturnType()).isParameterizedType() ? retType.getTypeParameters()[0] : JavaTypes.OBJECT()) : JavaTypes.OBJECT()));
        }
        return returnType;
    }

    public static Iterator makeIterator(Object obj, IType typeHint) {
        if (obj == null) {
            return null;
        }
        if (typeHint.isArray() && (obj.getClass().isArray() || TypeSystem.getFromObject((Object)obj).isArray())) {
            return new ArrayIterator(obj, typeHint);
        }
        if (obj instanceof Iterable) {
            return ((Iterable)obj).iterator();
        }
        if (obj instanceof Iterator) {
            return (Iterator)obj;
        }
        if (obj instanceof String) {
            return new StringIterator((String)obj);
        }
        if (obj instanceof Number) {
            return new NumberIterator((Number)obj);
        }
        return Collections.nCopies(1, obj).iterator();
    }

    public static int getArrayLength(Object obj) {
        if (obj == null) {
            return 0;
        }
        IType type = TypeLoaderAccess.instance().getIntrinsicTypeFromObject(obj);
        if (type.isArray()) {
            return type.getArrayLength(obj);
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).size();
        }
        if (obj instanceof Iterable) {
            int iCount = 0;
            for (Object o : (Iterable)obj) {
                ++iCount;
            }
            return iCount;
        }
        return 0;
    }

    public boolean isConditionLiteralTrue() {
        return this.getExpression() instanceof Literal && this.getExpression().isCompileTimeConstant() && CommonServices.getCoercionManager().makePrimitiveBooleanFrom(this.getExpression().evaluate());
    }

    static class ArrayIterator
    implements Iterator {
        private int _iCsr = 0;
        private Object _array;
        private IType _arrayType;

        ArrayIterator(Object array, IType arrayType) {
            this._arrayType = arrayType;
            this._array = CommonServices.getCoercionManager().convertValue(array, this._arrayType);
        }

        @Override
        public boolean hasNext() {
            return this._iCsr < this._arrayType.getArrayLength(this._array);
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No element at index [" + this._iCsr + "] for the array.");
            }
            return this._arrayType.getArrayComponent(this._array, this._iCsr++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("ArrayIterator does not support remove().");
        }
    }
}

