/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.CommonSymbolsScope;
import gw.internal.gosu.parser.CompiledGosuClassSymbolTable;
import gw.internal.gosu.parser.ContextInferenceManager;
import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.GosuClass;
import gw.internal.gosu.parser.GosuClassParseInfo;
import gw.internal.gosu.parser.GosuClassParser;
import gw.internal.gosu.parser.GosuMethodInfo;
import gw.internal.gosu.parser.GosuParser;
import gw.internal.gosu.parser.GosuProgramParseInfo;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.IGosuProgramInternal;
import gw.internal.gosu.parser.ProgramClassFunctionSymbol;
import gw.internal.gosu.parser.Statement;
import gw.internal.gosu.parser.TypeLord;
import gw.internal.gosu.parser.expressions.Identifier;
import gw.lang.parser.ExternalSymbolMapForMap;
import gw.lang.parser.IExpression;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.IReducedDynamicFunctionSymbol;
import gw.lang.parser.IStatement;
import gw.lang.parser.ISymbol;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.ITokenizerInstructor;
import gw.lang.parser.ITypeUsesMap;
import gw.lang.parser.expressions.IFieldAccessExpression;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.ClassType;
import gw.lang.reflect.gs.GosuClassTypeLoader;
import gw.lang.reflect.gs.IExternalSymbolMap;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IProgramInstance;
import gw.lang.reflect.gs.ISourceFileHandle;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.java.JavaTypes;
import gw.util.GosuExceptionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;

public class GosuProgram
extends GosuClass
implements IGosuProgramInternal {
    private IType _expectedReturnType;
    private boolean _bGenRootExprAccess;
    private ITokenizerInstructor _tokenizerInstructor;
    private volatile IProgramInstance _sharedInstance;
    private boolean _anonymous;
    private boolean _throwaway;
    private boolean _bStatementsOnly;
    private IType _contextType;
    private ContextInferenceManager _ctxInferenceMgr;
    private boolean _bParsingExecutableProgramStmts;
    private boolean _allowUses;

    public GosuProgram(String strNamespace, String strRelativeName, GosuClassTypeLoader classTypeLoader, ISourceFileHandle sourceFile, ITypeUsesMap typeUsesMap, ISymbolTable symTable) {
        super(strNamespace, strRelativeName, classTypeLoader, sourceFile, typeUsesMap);
        this.createNewParseInfo();
        this.getParseInfo().setSymbolTable(symTable instanceof CompiledGosuClassSymbolTable ? ((CompiledGosuClassSymbolTable)symTable).getTargetSymbolTable() : symTable);
        this.addProgramInterfaces();
    }

    protected void addProgramInterfaces() {
        this.addInterface((IType)JavaTypes.IPROGRAM_INSTANCE());
    }

    @Override
    public GosuClassParseInfo createNewParseInfo() {
        if (this.getParseInfo() == null) {
            this._parseInfo = new GosuProgramParseInfo((IGosuClassInternal)this.getOrCreateTypeReference());
        }
        return this.getParseInfo();
    }

    @Override
    public GosuProgramParseInfo getParseInfo() {
        return (GosuProgramParseInfo)super.getParseInfo();
    }

    @Override
    public ISymbolTable getSymbolTable() {
        return this.getParseInfo().getSymbolTable();
    }

    @Override
    public void addProgramEntryPoint(ISymbolTable symTable, GosuClassParser parser) {
        IJavaType programInstance = JavaTypes.IPROGRAM_INSTANCE();
        IType symbolMap = JavaTypes.IEXTERNAL_SYMBOL_MAP();
        this.addProgramInstanceMethod(symTable, parser, programInstance, "evaluate", symbolMap);
        this.addProgramInstanceMethod(symTable, parser, programInstance, "evaluateRootExpr", symbolMap);
    }

    private void addProgramInstanceMethod(ISymbolTable symTable, GosuClassParser parser, IJavaType cls, String strMethod, IType params) {
        IGosuProgramInternal pThis = (IGosuProgramInternal)this.getOrCreateTypeReference();
        IType iface = TypeLord.getDefaultParameterizedType((IType)cls);
        IGosuClassInternal gsInterface = IGosuClassInternal.Util.getGosuClassFrom(iface);
        IMethodInfo mi = gsInterface.getTypeInfo().getMethod((CharSequence)strMethod, new IType[]{params});
        GosuMethodInfo gmi = (GosuMethodInfo)mi;
        if (gmi != null) {
            IReducedDynamicFunctionSymbol dfs = gmi.getDfs();
            mi = (IMethodInfo)dfs.getMethodOrConstructorInfo();
            if (!(iface instanceof IGosuClass)) {
                String strMethodName = mi.getDisplayName();
                mi = iface.getTypeInfo().getMethod((CharSequence)strMethodName, ((IFunctionType)dfs.getType()).getParameterTypes());
                if (mi == null) {
                    throw new IllegalStateException("Did not find ProgramClass method info for: " + mi);
                }
            }
            ProgramClassFunctionSymbol programClassFs = new ProgramClassFunctionSymbol(pThis, symTable, gmi);
            parser.processFunctionSymbol(programClassFs, pThis);
        }
        this.addCapturedProgramSymbols(symTable);
    }

    @Override
    public void addCapturedProgramSymbols(ISymbolTable classCompilationSymTable) {
        ISymbolTable symTable = this.getSymbolTable();
        if (symTable == null) {
            return;
        }
        if (!JavaTypes.OBJECT().equals(this.getSupertype())) {
            return;
        }
        HashMap<String, ISymbol> externalSymbolsMap = new HashMap<String, ISymbol>(8);
        this.getParseInfo().setExternalSymbols(new ExternalSymbolMapForMap(externalSymbolsMap));
        Map symbols = symTable.getSymbols();
        if (symbols == null) {
            return;
        }
        for (ISymbol sym : symbols.values()) {
            if (sym instanceof CommonSymbolsScope.LockedDownSymbol || sym == null) continue;
            externalSymbolsMap.put(sym.getName(), sym);
        }
    }

    @Override
    public boolean isAnonymous() {
        return this._anonymous;
    }

    @Override
    public boolean isThrowaway() {
        return this._throwaway;
    }

    @Override
    public void setThrowaway(boolean throwaway) {
        this._throwaway = throwaway;
    }

    @Override
    public void setAllowUses(boolean b) {
        this._allowUses = true;
    }

    @Override
    public boolean allowsUses() {
        return this._allowUses || this.getName().contains("__Program__");
    }

    @Override
    public void setCtxInferenceMgr(Object ctxInferenceMgr) {
        this._ctxInferenceMgr = (ContextInferenceManager)ctxInferenceMgr;
    }

    @Override
    public ISymbol getExternalSymbol(String strName) {
        ISymbol sym;
        ExternalSymbolMapForMap externalSymbols = this.getParseInfo().getExternalSymbols();
        ISymbol iSymbol = sym = externalSymbols == null ? null : externalSymbols.getSymbol(strName);
        if (sym == null) {
            if (this.getSymbolTable() instanceof Attributes) {
                sym = this.getSymbolTable().getSymbol((CharSequence)strName);
            }
            if (sym == null) {
                sym = super.getExternalSymbol(strName);
            }
        }
        return sym;
    }

    @Override
    public void setExpression(Expression expr) {
        this.getParseInfo().setExpression(expr);
    }

    public IExpression getExpression() {
        return this.getParseInfo().getExpression();
    }

    @Override
    public void setStatement(Statement stmt) {
        this.getParseInfo().setStatement(stmt);
    }

    public IStatement getStatement() {
        return this.getParseInfo().getStatement();
    }

    public boolean isExpression() {
        return this.getParseInfo().getExpression() != null;
    }

    public boolean isLhsExpression() {
        IExpression expression = this.getParseInfo().getExpression();
        return expression instanceof IFieldAccessExpression || expression instanceof Identifier;
    }

    public IParsedElement getEnclosingEvalExpression() {
        return this.getParseInfo().getEvalExpression();
    }

    public void setEnclosingEvalExpression(IParsedElement evalExprOrAnyExpr) {
        this.getParseInfo().setEvalExpression(evalExprOrAnyExpr);
    }

    public Object evaluate(IExternalSymbolMap externalSymbols) {
        return this.runProgram(externalSymbols);
    }

    public Object evaluateRoot(IExternalSymbolMap externalSymbols) {
        try {
            return this.getProgramInstance().evaluateRootExpr(externalSymbols);
        }
        catch (Exception e) {
            throw GosuExceptionUtil.forceThrow((Throwable)e);
        }
    }

    public void assign(Object value) {
    }

    @Override
    public void setGenRootExprAccess(boolean bGenRootExprAccess) {
        this._bGenRootExprAccess = bGenRootExprAccess;
    }

    @Override
    public boolean isGenRootExprAccess() {
        return this._bGenRootExprAccess;
    }

    @Override
    public ITokenizerInstructor getTokenizerInstructor() {
        return this._tokenizerInstructor;
    }

    @Override
    public void setTokenizerInstructor(ITokenizerInstructor ti) {
        this._tokenizerInstructor = ti;
    }

    @Override
    public ISymbolTable getAdditionalDFSDecls() {
        return this.getParseInfo().getAdditionalDFSDecls();
    }

    @Override
    public void setAdditionalDFSDecls(ISymbolTable symbolTable) {
        this.getParseInfo().setAdditionalDFSDecls(symbolTable);
    }

    @Override
    protected GosuParser getOrCreateParser(CompiledGosuClassSymbolTable symbolTable) {
        GosuParser parser = super.getOrCreateParser(symbolTable);
        parser.setTokenizerInstructor(this.getTokenizerInstructor());
        ISymbolTable additionalDFSDecls = this.getParseInfo().getAdditionalDFSDecls();
        if (additionalDFSDecls != null) {
            parser.putDfsDeclsInTable(additionalDFSDecls);
        }
        if (this._ctxInferenceMgr != null) {
            parser.setContextInferenceManager(this._ctxInferenceMgr);
        }
        return parser;
    }

    public IType getExpectedReturnType() {
        return this._expectedReturnType;
    }

    @Override
    public void setExpectedReturnType(IType expectedReturnType) {
        if (expectedReturnType != null && expectedReturnType.isPrimitive() && expectedReturnType != JavaTypes.pVOID()) {
            expectedReturnType = TypeSystem.getBoxType((IType)expectedReturnType);
        }
        this._expectedReturnType = expectedReturnType;
    }

    public IType getReturnType() {
        if (this.getExpectedReturnType() != null) {
            return this.getExpectedReturnType();
        }
        IStatement statement = this.getParseInfo().getStatement();
        if (statement != null) {
            return statement.getReturnType();
        }
        return this.getParseInfo().getExpression().getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProgramInstance getProgramInstance() {
        if (this._sharedInstance != null) {
            return this._sharedInstance;
        }
        if (this.canShareProgramInstances()) {
            if (this._sharedInstance == null) {
                GosuProgram gosuProgram = this;
                synchronized (gosuProgram) {
                    if (this._sharedInstance == null) {
                        this._sharedInstance = this.createNewInstance();
                    }
                }
            }
            return this._sharedInstance;
        }
        return this.createNewInstance();
    }

    @Override
    public void unloadBackingClass() {
        super.unloadBackingClass();
        this._sharedInstance = null;
    }

    @Override
    public void setAnonymous(boolean b) {
        this._anonymous = b;
    }

    @Override
    public void setStatementsOnly(boolean bStatementsOnly) {
        this._bStatementsOnly = bStatementsOnly;
    }

    @Override
    public boolean isStatementsOnly() {
        return this._bStatementsOnly;
    }

    private IProgramInstance createNewInstance() {
        try {
            return (IProgramInstance)this.getBackingClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean canShareProgramInstances() {
        for (Field f : this.getBackingClass().getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers())) continue;
            return false;
        }
        return true;
    }

    private Object runProgram(IExternalSymbolMap externalSymbols) {
        try {
            return this.getProgramInstance().evaluate(externalSymbols);
        }
        catch (Exception e) {
            throw GosuExceptionUtil.forceThrow((Throwable)e);
        }
    }

    @Override
    public void setContextType(IType contextType) {
        this._contextType = contextType;
    }

    public IType getContextType() {
        return this._contextType;
    }

    @Override
    public boolean isParsingExecutableProgramStatements() {
        return this._bParsingExecutableProgramStmts;
    }

    @Override
    public void setParsingExecutableProgramStatements(boolean b) {
        this._bParsingExecutableProgramStmts = b;
    }

    @Override
    public ClassType getClassType() {
        return ClassType.Program;
    }
}

