/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.GenericTypeVariable;
import gw.internal.gosu.parser.MetaTypeTypeInfo;
import gw.internal.gosu.parser.TypeLord;
import gw.lang.parser.StandardCoercionManager;
import gw.lang.reflect.AbstractType;
import gw.lang.reflect.DefaultNonLoadableArrayType;
import gw.lang.reflect.IMetaType;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.ITypeLoader;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.TypeSystemShutdownListener;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.java.JavaTypes;
import gw.lang.reflect.module.IModule;
import gw.util.concurrent.LockingLazyVar;
import java.io.ObjectStreamException;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class MetaType
extends AbstractType
implements IMetaType {
    private static final Lock MEAT_LOCKER = new ReentrantLock();
    private static final LockingLazyVar<IJavaType> ROOT_TYPE = new LockingLazyVar<IJavaType>(MEAT_LOCKER){

        public IJavaType init() {
            IJavaType type = (IJavaType)TypeSystem.getByFullNameIfValid((String)RootType.class.getName().replace('$', '.'), (IModule)TypeSystem.getGlobalModule());
            if (type == null) {
                throw new RuntimeException("Cannot load gw.internal.gosu.parser.MetaType.RootType. The TypeSystem is not setup properly. It's highly likely Gosu is not in your classpath (perhaps via the project SDK).");
            }
            return type;
        }
    };
    static final LockingLazyVar<IJavaType> DEFAULT_TYPE = new LockingLazyVar<IJavaType>(MEAT_LOCKER){

        public IJavaType init() {
            return (IJavaType)TypeSystem.getByFullNameIfValid((String)Object.class.getName(), (IModule)TypeSystem.getGlobalModule());
        }
    };
    public static LockingLazyVar<MetaType> ROOT_TYPE_TYPE = new LockingLazyVar<MetaType>(MEAT_LOCKER){

        public MetaType init() {
            return MetaType.get((IType)ROOT_TYPE.get());
        }
    };
    public static LockingLazyVar<IType> DEFAULT_TYPE_TYPE = new LockingLazyVar<IType>(MEAT_LOCKER){

        public IType init() {
            return MetaType.get((IType)DEFAULT_TYPE.get());
        }
    };
    private IType _type;
    private transient Map<IRelativeTypeInfo.Accessibility, ITypeInfo> _typeInfoByAccessibility;
    private transient Set<IType> _allTypesInHierarchy;
    private transient LockingLazyVar<IType> _arrayType;
    private transient GenericTypeVariable[] _typeVars;
    private transient boolean _bLiteral;
    private transient IType[] _typeParams;
    private transient String _strName;
    private transient String _strRelativeName;

    public static void clearCaches() {
        ROOT_TYPE.clear();
        ROOT_TYPE_TYPE.clear();
        DEFAULT_TYPE.clear();
        DEFAULT_TYPE_TYPE.clear();
    }

    public static MetaType get(IType type) {
        return (MetaType)type.getMetaType();
    }

    public static MetaType getLiteral(IType type) {
        return (MetaType)type.getLiteralMetaType();
    }

    MetaType(IType type, boolean bLiteral) {
        this._type = type;
        this._bLiteral = bLiteral;
        this._typeInfoByAccessibility = new HashMap<IRelativeTypeInfo.Accessibility, ITypeInfo>(2);
        if (type.equals(ROOT_TYPE.get())) {
            this._typeVars = new GenericTypeVariable[]{new GenericTypeVariable("T", (IType)JavaTypes.OBJECT())};
            this._typeParams = IType.EMPTY_ARRAY;
        } else {
            this._typeVars = GenericTypeVariable.EMPTY_TYPEVARS;
            this._typeParams = new IType[]{type};
        }
        this._arrayType = new LockingLazyVar<IType>(){

            protected IType init() {
                return new DefaultNonLoadableArrayType((IType)MetaType.this, null, MetaType.this.getTypeLoader());
            }
        };
    }

    public IType getType() {
        return this._type;
    }

    public boolean isLiteral() {
        return this._bLiteral;
    }

    public ITypeLoader getTypeLoader() {
        return this._type.getTypeLoader();
    }

    public String getName() {
        if (this._strName == null) {
            this._strName = "Type" + (this.isGenericType() ? "" : "<" + this._type.getName() + ">");
        }
        return this._strName;
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getRelativeName() {
        if (this._strRelativeName == null) {
            this._strRelativeName = this.isGenericType() || this.isDefault() ? "Type" : "Type<" + this._type.getRelativeName() + ">";
        }
        return this._strRelativeName;
    }

    private boolean isDefault() {
        return this._type instanceof MetaType ? ((MetaType)this._type).isDefault() : this._type.equals(DEFAULT_TYPE.get());
    }

    public String getNamespace() {
        return this.isGenericType() ? "" : this._type.getNamespace();
    }

    public boolean isArray() {
        return false;
    }

    public boolean isPrimitive() {
        return false;
    }

    public Object makeArrayInstance(int iLength) {
        return JavaTypes.ITYPE().makeArrayInstance(iLength);
    }

    public boolean isAssignableFrom(IType type) {
        if (this.isArray() && type.isArray()) {
            return this.getComponentType().isAssignableFrom(type.getComponentType());
        }
        return !this.isArray() && !type.isArray() && type.getAllTypesInHierarchy().contains(JavaTypes.ITYPE()) && (!(type instanceof IMetaType) && (this.isDefaultOrRootType() || type.isAssignableFrom(this.getType()) || this.isMetadataType()) || type instanceof IMetaType && (this.isDefaultOrRootType() || ((IMetaType)type).getType().equals(DEFAULT_TYPE.get()) || ((IMetaType)type).getType().equals(ROOT_TYPE.get()) || this.getType().isAssignableFrom(((IMetaType)type).getType()) || StandardCoercionManager.isStructurallyAssignable((IType)this.getType(), (IType)((IMetaType)type).getType())));
    }

    private boolean isMetadataType() {
        String namespace = this.getType().getNamespace();
        return "entity".equals(namespace) || "typekey".equals(namespace);
    }

    private boolean isDefaultOrRootType() {
        return this.getType().equals(DEFAULT_TYPE.get()) || this.getType().equals(ROOT_TYPE.get());
    }

    public boolean isMutable() {
        return false;
    }

    public ITypeInfo getTypeInfo() {
        return this.loadTypeInfo();
    }

    private ITypeInfo loadTypeInfo() {
        IRelativeTypeInfo.Accessibility context = this._type.getTypeInfo() instanceof IRelativeTypeInfo ? ((IRelativeTypeInfo)this._type.getTypeInfo()).getAccessibilityForType(null) : null;
        Object typeInfo = this._typeInfoByAccessibility.get(context);
        if (typeInfo == null) {
            typeInfo = new MetaTypeTypeInfo(this);
            this._typeInfoByAccessibility.put(context, (ITypeInfo)typeInfo);
        }
        return typeInfo;
    }

    public void unloadTypeInfo() {
        this._typeInfoByAccessibility.clear();
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isEnum() {
        return false;
    }

    public IType[] getInterfaces() {
        return EMPTY_TYPE_ARRAY;
    }

    public IType getSupertype() {
        return null;
    }

    public IType getEnclosingType() {
        return null;
    }

    public IType getGenericType() {
        return (IType)ROOT_TYPE_TYPE.get();
    }

    public boolean isFinal() {
        return true;
    }

    public boolean isParameterizedType() {
        return !this._type.equals(ROOT_TYPE.get());
    }

    public boolean isGenericType() {
        return this._type.equals(ROOT_TYPE.get());
    }

    public GenericTypeVariable[] getGenericTypeVariables() {
        return this._typeVars;
    }

    public IType[] getTypeParameters() {
        return this._typeParams;
    }

    public IMetaType getParameterizedType(IType ... ofType) {
        if (ofType.length == 0) {
            throw new IllegalStateException("Empty paramter types");
        }
        return MetaType.get(ofType[0]);
    }

    public Set<? extends IType> getAllTypesInHierarchy() {
        if (this._allTypesInHierarchy == null) {
            IType type = TypeSystem.get(this.getType().getClass(), (IModule)TypeSystem.getGlobalModule());
            Set<IType> types = this.getTypeInterfaces(type, new HashSet<IType>());
            for (IType t : this.getType().getAllTypesInHierarchy()) {
                types.add((IType)MetaType.get(t));
            }
            this._allTypesInHierarchy = types;
        }
        return this._allTypesInHierarchy;
    }

    private Set<IType> getTypeInterfaces(IType type, Set<IType> set) {
        if (this.getType().equals(DEFAULT_TYPE.get())) {
            set.add((IType)JavaTypes.ITYPE());
            return set;
        }
        for (IType iface : type.getInterfaces()) {
            if (!(iface = TypeLord.getDefaultParameterizedType(iface)).getNamespace().startsWith("gw.internal")) {
                set.add(iface);
            }
            this.getTypeInterfaces(iface, set);
        }
        return set;
    }

    public IType getArrayType() {
        return (IType)this._arrayType.get();
    }

    public Object getArrayComponent(Object array, int iIndex) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        return Array.get(array, iIndex);
    }

    public void setArrayComponent(Object array, int iIndex, Object value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Array.set(array, iIndex, value);
    }

    public int getArrayLength(Object array) throws IllegalArgumentException {
        return Array.getLength(array);
    }

    public IType getComponentType() {
        return null;
    }

    public Object readResolve() throws ObjectStreamException {
        return MetaType.get(this._type);
    }

    public boolean isValid() {
        return true;
    }

    public int getModifiers() {
        return 1;
    }

    public boolean isAbstract() {
        return false;
    }

    public boolean equals(Object o) {
        return o instanceof MetaType && this._type.equals(((MetaType)((Object)o))._type);
    }

    public int hashCode() {
        return this._type.hashCode();
    }

    public String toString() {
        return this.getName();
    }

    public boolean isDiscarded() {
        return false;
    }

    public void setDiscarded(boolean bDiscarded) {
    }

    public boolean isCompoundType() {
        return false;
    }

    public Set<IType> getCompoundTypeComponents() {
        return null;
    }

    static {
        TypeSystem.addShutdownListener((TypeSystemShutdownListener)new TypeSystemShutdownListener(){

            public void shutdown() {
                MetaType.clearCaches();
            }
        });
    }

    public static class RootType {
    }
}

