/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.expressions;

import gw.internal.gosu.parser.CannotExecuteGosuException;
import gw.internal.gosu.parser.Expression;
import gw.lang.parser.GosuParserTypes;
import gw.lang.parser.expressions.IProgram;
import gw.lang.parser.expressions.ITemplateStringLiteral;
import gw.lang.parser.template.ITemplateGenerator;
import gw.lang.parser.template.TemplateParseException;
import java.util.List;

public class TemplateStringLiteral
extends Expression
implements ITemplateStringLiteral {
    private ITemplateGenerator _template;

    public TemplateStringLiteral(ITemplateGenerator template) {
        this._template = template;
        this.setType(GosuParserTypes.STRING_TYPE());
    }

    @Override
    public Object evaluate() {
        if (!this.isCompileTimeConstant()) {
            return super.evaluate();
        }
        throw new CannotExecuteGosuException();
    }

    public IProgram getProgram() {
        if (this._template.isValid()) {
            return this._template.getProgram();
        }
        String s = "";
        List parseExceptions = this._template.getTemplateSyntaxProblems();
        for (TemplateParseException parseException : parseExceptions) {
            s = s + parseException.getParseException().getMessage() + "\n";
        }
        throw new RuntimeException("String Template failed to parse: \n" + this + "\nOn class: " + this.getGosuClass().getName() + "\n Parse Errors:\n" + s);
    }

    @Override
    public String toString() {
        return "\"" + this._template.toString() + "\"";
    }
}

