/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.expressions;

import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.GosuClassCompilingStack;
import gw.internal.gosu.parser.GosuParser;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.MetaType;
import gw.internal.gosu.parser.TypeLord;
import gw.internal.gosu.parser.TypeVariableType;
import gw.internal.gosu.parser.expressions.Literal;
import gw.lang.parser.IParseIssue;
import gw.lang.parser.exceptions.ParseWarningForDeprecatedMember;
import gw.lang.parser.expressions.ITypeLiteralExpression;
import gw.lang.reflect.IMetaType;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGosuClass;

public class TypeLiteral
extends Literal
implements ITypeLiteralExpression {
    private static final ThreadLocal<Boolean> _isComputingIsDeprecated = new ThreadLocal();
    private Expression _packageExpr;
    private boolean _ignoreTypeDeprecation;

    public TypeLiteral(IType type, boolean ignoreTypeDeprecation) {
        this._ignoreTypeDeprecation = ignoreTypeDeprecation;
        this.setType(type);
    }

    public TypeLiteral(IType type) {
        this.setType(type);
    }

    public TypeLiteral() {
    }

    public Expression getPackageExpression() {
        return this._packageExpr;
    }

    public void setPackageExpression(Expression packageExpr) {
        this._packageExpr = packageExpr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setType(IType type) {
        IType thisType;
        Boolean isComputing;
        if (type instanceof MetaType) {
            if (!((MetaType)((Object)type)).isLiteral()) {
                type = MetaType.getLiteral(((MetaType)((Object)type)).getType());
            }
            super.setType((IType)type);
        } else {
            super.setType((IType)MetaType.getLiteral(type));
        }
        IType gosuClass = GosuClassCompilingStack.getCurrentCompilingType();
        if (!(this._ignoreTypeDeprecation || gosuClass instanceof IGosuClass && !((IGosuClass)gosuClass).isCompilingDefinitions() || (isComputing = _isComputingIsDeprecated.get()) == Boolean.TRUE || this.getType() == null || this.isEnclosureDeprecated(gosuClass) || (thisType = this.getType().getType()) == null)) {
            _isComputingIsDeprecated.set(Boolean.TRUE);
            try {
                ITypeInfo typeInfo = thisType.getTypeInfo();
                if (typeInfo != null && typeInfo.isDeprecated()) {
                    this.addParseWarning((IParseIssue)new ParseWarningForDeprecatedMember(null, thisType.getDisplayName(), thisType.getDisplayName()));
                }
            }
            finally {
                _isComputingIsDeprecated.set(Boolean.FALSE);
            }
        }
    }

    private boolean isEnclosureDeprecated(IType type) {
        if (!(type instanceof IGosuClass)) {
            return false;
        }
        IGosuClassInternal gsClass = (IGosuClassInternal)type;
        GosuParser parser = (GosuParser)gsClass.getParser();
        return parser != null && parser.isIgnoreTypeDeprecation();
    }

    public void setParameterTypes(IType[] types) {
        if (types.length == 0) {
            return;
        }
        IType parameterizedType = this.getType().getType().getParameterizedType(types);
        this.setType(this.ensureLiteral(parameterizedType));
    }

    private IType ensureLiteral(IType type) {
        if (type instanceof IMetaType) {
            return MetaType.getLiteral(this.ensureLiteral(((IMetaType)type).getType()));
        }
        return MetaType.getLiteral(type);
    }

    public Object clone() {
        TypeLiteral clone = new TypeLiteral((IType)this.getType());
        clone.setLocation(this.getLocation());
        return clone;
    }

    @Override
    public boolean isCompileTimeConstant() {
        IType type = this.getType().getType();
        return (!type.isParameterizedType() || TypeLord.getDefaultParameterizedType(type) == type) && !(type instanceof TypeVariableType);
    }

    public IType evaluate() {
        return this.getType().getType();
    }

    @Override
    public String toString() {
        return TypeLord.getPureGenericType(this.getType().getType()).getName();
    }

    public MetaType getType() {
        MetaType type = this.getTypeImpl();
        if (type != null && TypeSystem.isDeleted((IType)type.getType())) {
            type = (MetaType)TypeSystem.getErrorType().getMetaType();
        }
        return type;
    }

    protected MetaType getTypeImpl() {
        return (MetaType)super.getTypeImpl();
    }
}

