/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.statements;

import gw.internal.gosu.parser.DynamicFunctionSymbol;
import gw.internal.gosu.parser.GosuClassParseInfo;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.IGosuProgramInternal;
import gw.internal.gosu.parser.Symbol;
import gw.internal.gosu.parser.ThisConstructorFunctionSymbol;
import gw.internal.gosu.parser.statements.AssignmentOrReference;
import gw.internal.gosu.parser.statements.VarStatement;
import gw.lang.parser.IExpression;
import gw.lang.parser.IInitializerSymbol;
import gw.lang.parser.IParseIssue;
import gw.lang.parser.IParseTree;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.IStatement;
import gw.lang.parser.ISymbol;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.Keyword;
import gw.lang.parser.StandardSymbolTable;
import gw.lang.parser.exceptions.ParseException;
import gw.lang.parser.expressions.IBlockExpression;
import gw.lang.parser.expressions.IIdentifierExpression;
import gw.lang.parser.expressions.IMethodCallExpression;
import gw.lang.parser.expressions.IVarStatement;
import gw.lang.parser.resources.Res;
import gw.lang.parser.resources.ResourceKey;
import gw.lang.parser.statements.IAssignmentStatement;
import gw.lang.parser.statements.IBreakStatement;
import gw.lang.parser.statements.ICaseClause;
import gw.lang.parser.statements.ICatchClause;
import gw.lang.parser.statements.IClassStatement;
import gw.lang.parser.statements.IContinueStatement;
import gw.lang.parser.statements.IDoWhileStatement;
import gw.lang.parser.statements.IFunctionStatement;
import gw.lang.parser.statements.IHideFieldNoOpStatement;
import gw.lang.parser.statements.IIfStatement;
import gw.lang.parser.statements.ILoopStatement;
import gw.lang.parser.statements.IMemberAssignmentStatement;
import gw.lang.parser.statements.IMethodCallStatement;
import gw.lang.parser.statements.IStatementList;
import gw.lang.parser.statements.ISwitchStatement;
import gw.lang.parser.statements.ITerminalStatement;
import gw.lang.parser.statements.ITryCatchFinallyStatement;
import gw.lang.parser.statements.IUsingStatement;
import gw.lang.reflect.IEnumType;
import gw.lang.reflect.IType;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuProgram;
import java.util.ArrayList;
import java.util.List;

public class VarInitializationVerifier {
    private boolean _bFinalOnly;

    private VarInitializationVerifier(boolean bFinalOnly) {
        this._bFinalOnly = bFinalOnly;
    }

    private boolean isFinalOnly() {
        return this._bFinalOnly;
    }

    public static void verifyFinalFields(IGosuClass gsClass) {
        new VarInitializationVerifier(true).verifyFields((IGosuClassInternal)gsClass);
    }

    public static void verifyLocalVars(IGosuClass gsClass, boolean bFinalOnly) {
        new VarInitializationVerifier(bFinalOnly).verifyLocals((IGosuClassInternal)gsClass);
    }

    private void verifyLocals(IGosuClassInternal gsClass) {
        IStatement stmt;
        GosuClassParseInfo parseInfo = gsClass.getParseInfo();
        for (DynamicFunctionSymbol dfs : parseInfo.getConstructorFunctions().values()) {
            stmt = (IStatement)dfs.getValueDirectly();
            this.verifyLocalsRecursively((IParsedElement)stmt);
        }
        for (DynamicFunctionSymbol dfs : parseInfo.getMemberFunctions().values()) {
            stmt = (IStatement)dfs.getValueDirectly();
            this.verifyLocalsRecursively((IParsedElement)stmt);
        }
        for (DynamicFunctionSymbol dfs : parseInfo.getStaticFunctions()) {
            stmt = (IStatement)dfs.getValueDirectly();
            this.verifyLocalsRecursively((IParsedElement)stmt);
        }
    }

    private void verifyLocalsRecursively(IParsedElement pe) {
        IParseTree location;
        if (pe == null || pe instanceof IBlockExpression || pe instanceof IClassStatement) {
            return;
        }
        if (pe instanceof IVarStatement && (!this.isFinalOnly() || ((IVarStatement)pe).isFinal())) {
            this.verifyLocalVar((IVarStatement)pe);
        }
        if ((location = pe.getLocation()) != null && location.getChildren() != null) {
            for (IParseTree child : location.getChildren()) {
                this.verifyLocalsRecursively(child.getParsedElement());
            }
        }
    }

    private void verifyLocalVar(IVarStatement varStmt) {
        boolean bFinal = varStmt.isFinal();
        boolean bAssigned = varStmt.getAsExpression() != null || varStmt.getSymbol() instanceof Symbol && ((Symbol)varStmt.getSymbol()).isImplicitlyInitialized();
        IStatement enclosingStatement = this.findEnclosingStatement(varStmt.getParent());
        List<IStatement> trailingStmts = this.findTrailingStmts(enclosingStatement, varStmt);
        ArrayList<AssignmentOrReference> assignments = new ArrayList<AssignmentOrReference>();
        AssignedState state = this.getAssignedStateForStatements(varStmt.getSymbol(), assignments, trailingStmts.toArray(new IStatement[trailingStmts.size()]), AssignedState.Unassigned);
        this.verifyVar(varStmt, false, bFinal, bAssigned, assignments);
    }

    private List<IStatement> findTrailingStmts(IStatement enclosingStatement, IVarStatement finalVar) {
        IParseTree location = enclosingStatement.getLocation();
        ArrayList<IStatement> trailingStmts = new ArrayList<IStatement>();
        if (location != null) {
            boolean bFound = false;
            for (IParseTree pt : location.getChildren()) {
                IParsedElement child = pt.getParsedElement();
                if (!(child instanceof IStatement)) continue;
                if (!bFound) {
                    if (child != finalVar) continue;
                    bFound = true;
                    continue;
                }
                trailingStmts.add((IStatement)child);
            }
        }
        return trailingStmts;
    }

    private IStatement findEnclosingStatement(IParsedElement pe) {
        if (pe instanceof IStatement) {
            return (IStatement)pe;
        }
        return this.findEnclosingStatement(pe.getParent());
    }

    private void verifyFields(IGosuClassInternal gsClass) {
        for (VarStatement varStmt : gsClass.getParseInfo().getMemberFields().values()) {
            if (!varStmt.isFinal()) continue;
            this.verifyInstanceField(gsClass, varStmt);
        }
        for (VarStatement varStmt : gsClass.getParseInfo().getStaticFields().values()) {
            if (!varStmt.isFinal()) continue;
            this.verifyStaticField(gsClass, varStmt);
        }
    }

    private void verifyInstanceField(IGosuClassInternal gsClass, VarStatement varStmt) {
        boolean bAssigned = varStmt.getAsExpression() != null;
        AssignedState overall = null;
        if (gsClass instanceof IGosuProgramInternal) {
            for (DynamicFunctionSymbol dfs : gsClass.getParseInfo().getMemberFunctions().values()) {
                if (!dfs.getDisplayName().equals("evaluate")) continue;
                overall = this.verifyInstanceFieldInConstructor(varStmt, bAssigned, overall, dfs);
            }
        } else {
            for (DynamicFunctionSymbol dfs : gsClass.getParseInfo().getConstructorFunctions().values()) {
                overall = this.verifyInstanceFieldInConstructor(varStmt, bAssigned, overall, dfs);
            }
            this.verifyInstanceFieldInOtherInstanceFields(gsClass, varStmt);
        }
        if (!bAssigned && overall != AssignedState.Fully) {
            ParseException parseException = new ParseException(Integer.valueOf(varStmt.getLineNum()), Integer.valueOf(1), Integer.valueOf(varStmt.getLocation().getColumn()), Integer.valueOf(varStmt.getLocation().getOffset()), Integer.valueOf(varStmt.getLocation().getExtent()), (ISymbolTable)new StandardSymbolTable(), Res.MSG_VAR_MIGHT_NOT_HAVE_BEEN_INIT, new Object[]{varStmt.getSymbol().getName()});
            varStmt.addParseException((IParseIssue)parseException);
        }
    }

    private void verifyInstanceFieldInOtherInstanceFields(IGosuClassInternal gsClass, VarStatement varStmt) {
        if (gsClass instanceof IGosuProgram) {
            return;
        }
        ArrayList<AssignmentOrReference> assignments = new ArrayList<AssignmentOrReference>();
        AssignedState state = AssignedState.Unassigned;
        for (IVarStatement iVarStatement : gsClass.getParseInfo().getMemberFields().values()) {
            if (iVarStatement == varStmt) {
                if (varStmt.getAsExpression() == null) continue;
                assignments.add(new AssignmentOrReference((IStatement)iVarStatement, assignments, state));
                state = AssignedState.Fully;
                continue;
            }
            IExpression expr = iVarStatement.getAsExpression();
            if (expr == null) continue;
            this.getAssignedState(varStmt.getSymbol(), (IParsedElement)expr, assignments, state);
        }
        this.markErrorsOnBadAssignmentsAndReferences(varStmt, true, true, assignments);
    }

    private AssignedState verifyInstanceFieldInConstructor(VarStatement varStmt, boolean bAssigned, AssignedState overall, DynamicFunctionSymbol dfs) {
        IStatement stmt = (IStatement)dfs.getValueDirectly();
        ArrayList<AssignmentOrReference> assignments = new ArrayList<AssignmentOrReference>();
        AssignedState initState = this.getAssignedState(varStmt.getSymbol(), dfs.getInitializer(), assignments, AssignedState.Unassigned);
        AssignedState state = this.getAssignedState(varStmt.getSymbol(), (IParsedElement)stmt, assignments, initState);
        AssignedState assignedState = state = state.ordinal() > initState.ordinal() ? state : initState;
        overall = overall == null ? state : (overall.ordinal() > state.ordinal() ? state : overall);
        this.verifyVar(varStmt, true, true, bAssigned, assignments);
        return overall;
    }

    private void verifyVar(IVarStatement varStmt, boolean bField, boolean bFinal, boolean bAssigned, ArrayList<AssignmentOrReference> assignments) {
        if (bAssigned) {
            if (bFinal) {
                this.markErrorsOnAssignmentsToFinal(varStmt, assignments);
            }
        } else {
            this.markErrorsOnBadAssignmentsAndReferences(varStmt, bField, bFinal, assignments);
        }
    }

    private void markErrorsOnAssignmentsToFinal(IVarStatement varStmt, ArrayList<AssignmentOrReference> assignments) {
        for (AssignmentOrReference assignment : assignments) {
            if (!(assignment.getStmt() instanceof IStatement)) continue;
            IStatement s = (IStatement)assignment.getStmt();
            ParseException parseException = new ParseException(Integer.valueOf(s.getLineNum()), Integer.valueOf(1), Integer.valueOf(s.getLocation().getColumn()), Integer.valueOf(s.getLocation().getOffset()), Integer.valueOf(s.getLocation().getExtent()), (ISymbolTable)new StandardSymbolTable(), Res.MSG_CANNOT_ASSIGN_VALUE_TO_FINAL_VAR, new Object[]{varStmt.getSymbol().getName()});
            s.addParseException((IParseIssue)parseException);
        }
    }

    private void markErrorsOnBadAssignmentsAndReferences(IVarStatement varStmt, boolean bField, boolean bFinal, ArrayList<AssignmentOrReference> assignments) {
        for (AssignmentOrReference assignment : assignments) {
            ResourceKey resKey;
            if (!assignment.isBad()) continue;
            if (assignment.getStmt() instanceof IStatement) {
                if (!bFinal) continue;
                resKey = assignment.isInLoop() ? Res.MSG_VAR_MIGHT_ALREADY_HAVE_BEEN_INIT_LOOP : Res.MSG_VAR_MIGHT_ALREADY_HAVE_BEEN_INIT;
            } else {
                if (!bFinal && (bField || this.isFinalOnly())) continue;
                resKey = Res.MSG_VAR_MIGHT_NOT_HAVE_BEEN_INIT;
            }
            IParsedElement s = assignment.getStmt();
            ParseException parseException = new ParseException(Integer.valueOf(s.getLineNum()), Integer.valueOf(1), Integer.valueOf(s.getLocation().getColumn()), Integer.valueOf(s.getLocation().getOffset()), Integer.valueOf(s.getLocation().getExtent()), (ISymbolTable)new StandardSymbolTable(), resKey, new Object[]{varStmt.getSymbol().getName()});
            s.addParseException((IParseIssue)parseException);
        }
    }

    private void verifyStaticField(IGosuClassInternal gsClass, VarStatement varStmt) {
        boolean bAssigned = varStmt.getHasInitializer();
        if (!bAssigned) {
            ParseException parseException = new ParseException(Integer.valueOf(varStmt.getLineNum()), Integer.valueOf(1), Integer.valueOf(varStmt.getLocation().getColumn()), Integer.valueOf(varStmt.getLocation().getOffset()), Integer.valueOf(varStmt.getLocation().getExtent()), (ISymbolTable)new StandardSymbolTable(), Res.MSG_VAR_MIGHT_NOT_HAVE_BEEN_INIT, new Object[]{varStmt.getSymbol().getName()});
            varStmt.addParseException((IParseIssue)parseException);
        }
    }

    private AssignedState getAssignedState(ISymbol sym, IParsedElement s, ArrayList<AssignmentOrReference> assignments, AssignedState localState) {
        if (s == null) {
            return AssignedState.Unassigned;
        }
        AssignedState retState = null;
        if (s instanceof IFunctionStatement) {
            IStatement stmt = (IStatement)((IFunctionStatement)s).getDynamicFunctionSymbol().getValueDirectly();
            retState = this.getAssignedState(sym, (IParsedElement)stmt, assignments, localState);
        } else if (s instanceof IAssignmentStatement) {
            IAssignmentStatement stmt = (IAssignmentStatement)s;
            if (stmt.getIdentifier().getSymbol().getName().equals(sym.getName())) {
                assignments.add(new AssignmentOrReference((IStatement)stmt, assignments, localState));
                retState = AssignedState.Fully;
            } else {
                retState = AssignedState.Unassigned;
            }
            this.getAssignedState(sym, (IParsedElement)stmt.getExpression(), assignments, localState);
        } else if (s instanceof IHideFieldNoOpStatement) {
            IHideFieldNoOpStatement stmt = (IHideFieldNoOpStatement)s;
            IVarStatement varStmt = stmt.getVarStmt();
            if (varStmt.getAsExpression() != null && varStmt.getSymbol().getName().equals(sym.getName())) {
                assignments.add(new AssignmentOrReference((IStatement)stmt, assignments, localState));
                retState = AssignedState.Fully;
            } else {
                retState = AssignedState.Unassigned;
            }
            this.getAssignedState(sym, (IParsedElement)varStmt.getAsExpression(), assignments, localState);
        } else if (s instanceof IMemberAssignmentStatement) {
            IMemberAssignmentStatement stmt = (IMemberAssignmentStatement)s;
            IExpression rootExpr = stmt.getRootExpression();
            if (rootExpr instanceof IIdentifierExpression && Keyword.KW_this.getName().equals(((IIdentifierExpression)rootExpr).getSymbol().getName()) && stmt.getMemberName() != null && stmt.getMemberName().equals(sym.getName())) {
                assignments.add(new AssignmentOrReference((IStatement)stmt, assignments, localState));
                retState = AssignedState.Fully;
            } else {
                retState = AssignedState.Unassigned;
                this.getAssignedState(sym, (IParsedElement)stmt.getRootExpression(), assignments, localState);
            }
            this.getAssignedState(sym, (IParsedElement)stmt.getExpression(), assignments, localState);
        } else if (s instanceof IStatementList) {
            IStatement[] statements = ((IStatementList)s).getStatements();
            retState = this.getAssignedStateForStatements(sym, assignments, statements, localState);
        } else if (s instanceof ILoopStatement) {
            int iSize = assignments.size();
            AssignedState state = this.getAssignedState(sym, (IParsedElement)((ILoopStatement)s).getStatement(), assignments, localState);
            if (iSize < assignments.size() && sym.isFinal()) {
                for (int i = iSize; i < assignments.size(); ++i) {
                    AssignmentOrReference csr = assignments.get(i);
                    csr.determineBad(assignments, true);
                }
            }
            retState = state == AssignedState.Fully && !((ILoopStatement)s).isConditionLiteralTrue() && !(s instanceof IDoWhileStatement) ? AssignedState.Partially : state;
            this.getAssignedState(sym, (IParsedElement)((ILoopStatement)s).getExpression(), assignments, localState);
        } else if (s instanceof IMethodCallStatement) {
            IExpression[] args;
            IStatement stmt;
            AssignedState state = AssignedState.Unassigned;
            IMethodCallExpression methodCall = ((IMethodCallStatement)s).getMethodCall();
            if (methodCall.getFunctionSymbol() instanceof ThisConstructorFunctionSymbol && (state = this.getAssignedState(sym, (IParsedElement)(stmt = (IStatement)((ThisConstructorFunctionSymbol)methodCall.getFunctionSymbol()).getDelegate().getValueDirectly()), new ArrayList<AssignmentOrReference>(), localState)) != AssignedState.Unassigned) {
                assignments.add(new AssignmentOrReference((IStatement)s, assignments, localState));
            }
            retState = state;
            IMethodCallExpression methodCallExpr = ((IMethodCallStatement)s).getMethodCall();
            if (methodCallExpr != null && (args = methodCallExpr.getArgs()) != null) {
                for (IExpression expr : args) {
                    this.getAssignedState(sym, (IParsedElement)expr, assignments, localState);
                }
            }
        } else if (s instanceof IIfStatement) {
            IIfStatement stmt = (IIfStatement)s;
            AssignedState mainStmtState = this.getAssignedState(sym, (IParsedElement)stmt.getStatement(), assignments, localState);
            IStatement elseStmt = stmt.getElseStatement();
            if (elseStmt != null) {
                AssignedState elseStmtState = this.getAssignedState(sym, (IParsedElement)elseStmt, assignments, localState);
                switch (mainStmtState) {
                    case Fully: {
                        retState = elseStmtState == AssignedState.Fully ? AssignedState.Fully : AssignedState.Partially;
                        break;
                    }
                    case Partially: {
                        retState = AssignedState.Partially;
                        break;
                    }
                    case Unassigned: {
                        retState = elseStmtState == AssignedState.Unassigned ? AssignedState.Unassigned : AssignedState.Partially;
                    }
                }
            } else {
                retState = mainStmtState == AssignedState.Unassigned ? AssignedState.Unassigned : AssignedState.Partially;
            }
            this.getAssignedState(sym, (IParsedElement)stmt.getExpression(), assignments, localState);
        } else if (s instanceof ISwitchStatement) {
            AssignedState state = null;
            IExpression switchExpression = ((ISwitchStatement)s).getSwitchExpression();
            IType enumType = switchExpression != null && switchExpression.getType().isEnum() ? switchExpression.getType() : null;
            List enumValues = enumType != null ? ((IEnumType)enumType).getEnumConstants() : null;
            for (ICaseClause caseClause : ((ISwitchStatement)s).getCases()) {
                if (enumValues != null && caseClause.getExpression().isCompileTimeConstant()) {
                    try {
                        Object value = caseClause.getExpression().evaluate();
                        if (value != null) {
                            enumValues.remove(value.toString());
                        }
                    }
                    catch (Exception value) {
                        // empty catch block
                    }
                }
                List statements = caseClause.getStatements();
                AssignedState csr = this.getAssignedStateForStatements(sym, assignments, statements.toArray(new IStatement[statements.size()]), localState);
                boolean bTerminal = VarInitializationVerifier.doStatementsTerminate(statements);
                if (!bTerminal) continue;
                state = state == null ? csr : (state.ordinal() > csr.ordinal() ? csr : state);
            }
            List defaultStatements = ((ISwitchStatement)s).getDefaultStatements();
            if (defaultStatements != null) {
                AssignedState csr = this.getAssignedStateForStatements(sym, assignments, defaultStatements.toArray(new IStatement[defaultStatements.size()]), localState);
                state = state == null ? csr : (state.ordinal() > csr.ordinal() ? csr : state);
            } else if (enumValues == null || !enumValues.isEmpty()) {
                state = state == null || state == AssignedState.Unassigned ? AssignedState.Unassigned : AssignedState.Partially;
            }
            retState = state == null ? AssignedState.Unassigned : state;
            this.getAssignedState(sym, (IParsedElement)switchExpression, assignments, localState);
        } else if (s instanceof ITryCatchFinallyStatement) {
            IStatement finallyStmt;
            ITryCatchFinallyStatement tryCatchFinallyStmt = (ITryCatchFinallyStatement)s;
            AssignedState state = this.getAssignedState(sym, (IParsedElement)tryCatchFinallyStmt.getTryStatement(), assignments, localState);
            List catchStatements = tryCatchFinallyStmt.getCatchStatements();
            if (catchStatements != null) {
                for (ICatchClause catchClause : catchStatements) {
                    AssignedState caseState = this.getAssignedState(sym, (IParsedElement)catchClause.getCatchStmt(), assignments, localState);
                    if (caseState == AssignedState.Unassigned || state != AssignedState.Unassigned) continue;
                    state = AssignedState.Partially;
                }
            }
            if ((finallyStmt = tryCatchFinallyStmt.getFinallyStatement()) != null) {
                AssignedState finallyState = this.getAssignedState(sym, (IParsedElement)finallyStmt, assignments, localState);
                state = state.ordinal() > finallyState.ordinal() ? state : finallyState;
            }
            retState = state;
        } else if (s instanceof IUsingStatement) {
            retState = this.getAssignedState(sym, (IParsedElement)((IUsingStatement)s).getStatement(), assignments, localState);
            this.getAssignedState(sym, (IParsedElement)((IUsingStatement)s).getExpression(), assignments, localState);
        } else if (s instanceof IIdentifierExpression) {
            ISymbol symbol = ((IIdentifierExpression)s).getSymbol();
            if (!(symbol instanceof IInitializerSymbol) && symbol.getName().equals(sym.getName())) {
                assignments.add(new AssignmentOrReference((IIdentifierExpression)s, assignments, localState));
            }
            retState = AssignedState.Unassigned;
        } else if (!(s instanceof IBlockExpression) && !(s instanceof IClassStatement)) {
            IParseTree location = s.getLocation();
            if (location != null) {
                for (IParseTree child : location.getChildren()) {
                    this.getAssignedState(sym, child.getParsedElement(), assignments, localState);
                }
            }
            retState = AssignedState.Unassigned;
        }
        return retState;
    }

    public static boolean doStatementsTerminate(List<? extends IStatement> statements) {
        for (IStatement iStatement : statements) {
            boolean[] bAbsolute;
            ITerminalStatement terminalStmt = iStatement.getLeastSignificantTerminalStatement(bAbsolute = new boolean[]{false});
            if (terminalStmt == null || !bAbsolute[0]) continue;
            return true;
        }
        return false;
    }

    private IParsedElement getTerminalParent(IParsedElement pe) {
        IParsedElement parent = pe.getParent();
        if (parent instanceof IStatementList) {
            do {
                pe = parent;
            } while ((parent = parent.getParent()) instanceof IStatementList);
            parent = pe;
        }
        if (parent instanceof ICaseClause) {
            parent = parent.getParent();
        }
        return parent;
    }

    static boolean isStatementContainedIn(IParsedElement stmt, IParsedElement container) {
        if (container == null) {
            return false;
        }
        while (container != stmt) {
            if (stmt == null) {
                return false;
            }
            stmt = stmt.getParent();
        }
        return true;
    }

    private AssignedState getAssignedStateForStatements(ISymbol sym, ArrayList<AssignmentOrReference> assignments, IStatement[] statements, AssignedState localState) {
        AssignedState state = AssignedState.Unassigned;
        if (statements != null) {
            for (IStatement stmt : statements) {
                AssignedState csr = this.getAssignedState(sym, (IParsedElement)stmt, assignments, localState.ordinal() > state.ordinal() ? localState : state);
                this.assignTerminalStatement(assignments, stmt);
                state = csr.ordinal() > state.ordinal() ? csr : state;
            }
        }
        return state;
    }

    private void assignTerminalStatement(ArrayList<AssignmentOrReference> assignments, IStatement stmt) {
        boolean[] bAbsolute = new boolean[]{false};
        ITerminalStatement terminalStmt = stmt.getLeastSignificantTerminalStatement(bAbsolute);
        if (terminalStmt != null && bAbsolute[0]) {
            for (AssignmentOrReference assignment : assignments) {
                if (assignment.isReference() || !VarInitializationVerifier.isStatementContainedIn(assignment.getStmt(), this.getTerminalParent((IParsedElement)stmt)) || assignment.getTerminal() != null && VarInitializationVerifier.isStatementContainedIn((IParsedElement)terminalStmt, this.getTerminalContext(assignment.getTerminal()))) continue;
                assignment.setTerminal(terminalStmt);
            }
        }
    }

    private IParsedElement getTerminalContext(ITerminalStatement terminal) {
        if (terminal instanceof IBreakStatement) {
            return this.findBreakStatementContext(terminal);
        }
        if (terminal instanceof IContinueStatement) {
            return this.findContinueStatementContext(terminal);
        }
        return this.findEnclosingFunctionStatement(terminal);
    }

    private IParsedElement findEnclosingFunctionStatement(ITerminalStatement terminal) {
        return this.findFirstEnclosing((IParsedElement)terminal, new Class[]{IFunctionStatement.class});
    }

    private IParsedElement findContinueStatementContext(ITerminalStatement terminal) {
        return this.findFirstEnclosing((IParsedElement)terminal, new Class[]{ILoopStatement.class});
    }

    private IParsedElement findBreakStatementContext(ITerminalStatement terminal) {
        return this.findFirstEnclosing((IParsedElement)terminal, new Class[]{ILoopStatement.class, ISwitchStatement.class});
    }

    private IParsedElement findFirstEnclosing(IParsedElement csr, Class[] classes) {
        if (csr == null) {
            return null;
        }
        for (Class cls : classes) {
            if (!cls.isAssignableFrom(csr.getClass())) continue;
            return csr;
        }
        return this.findFirstEnclosing(csr.getParent(), classes);
    }

    public static enum AssignedState {
        Unassigned,
        Partially,
        Fully;

    }
}

