/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.expression;

import gw.internal.gosu.ir.nodes.IRMethod;
import gw.internal.gosu.ir.nodes.IRMethodFactory;
import gw.internal.gosu.ir.nodes.IRProperty;
import gw.internal.gosu.ir.nodes.IRPropertyFactory;
import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.expression.AbstractExpressionTransformer;
import gw.internal.gosu.ir.transform.util.AccessibilityUtil;
import gw.internal.gosu.parser.CapturedSymbol;
import gw.internal.gosu.parser.DynamicPropertySymbol;
import gw.internal.gosu.parser.DynamicSymbol;
import gw.internal.gosu.parser.ICompilableTypeInternal;
import gw.internal.gosu.parser.OuterFunctionSymbol;
import gw.internal.gosu.parser.ReducedDynamicPropertySymbol;
import gw.internal.gosu.parser.ReducedSymbol;
import gw.lang.ir.IRExpression;
import gw.lang.parser.IBlockClass;
import gw.lang.parser.IReducedSymbol;
import gw.lang.parser.ISymbol;
import gw.lang.parser.Keyword;
import gw.lang.parser.expressions.IIdentifierExpression;
import gw.lang.reflect.IType;
import gw.lang.reflect.gs.IExternalSymbolMap;
import gw.lang.reflect.gs.IGosuProgram;
import gw.lang.reflect.java.JavaTypes;
import java.util.Arrays;
import java.util.Collections;

public class IdentifierTransformer
extends AbstractExpressionTransformer<IIdentifierExpression> {
    public static IRExpression compile(TopLevelTransformationContext cc, IIdentifierExpression expr) {
        IdentifierTransformer compiler = new IdentifierTransformer(cc, expr);
        return compiler.compile();
    }

    private IdentifierTransformer(TopLevelTransformationContext cc, IIdentifierExpression expr) {
        super(cc, expr);
    }

    @Override
    protected IRExpression compile_impl() {
        ISymbol symbol = ((IIdentifierExpression)this._expr()).getSymbol();
        ICompilableTypeInternal gsClass = this.getGosuClass();
        if ((Keyword.KW_this.equals(symbol.getName()) || Keyword.KW_super.equals(symbol.getName())) && (!(gsClass instanceof IGosuProgram) || gsClass.isAnonymous())) {
            if (this._cc().isBlockInvoke() && this._cc().currentlyCompilingBlock()) {
                while (gsClass instanceof IBlockClass) {
                    gsClass = gsClass.getEnclosingType();
                }
                return this.pushOuter((IType)gsClass);
            }
            return this.pushThis();
        }
        if (symbol instanceof DynamicPropertySymbol && ((DynamicPropertySymbol)symbol).getGetterDfs() instanceof OuterFunctionSymbol) {
            return this.pushOuterForOuterSymbol();
        }
        return this.pushSymbolValue(symbol);
    }

    public IRExpression pushSymbolValue(ISymbol symbol) {
        Class symClass;
        ISymbol reducedSym;
        IType type = symbol.getType();
        if (symbol instanceof ReducedSymbol.SyntheticSymbol) {
            reducedSym = ((ReducedSymbol.SyntheticSymbol)symbol).getReducedSymbol();
            symClass = reducedSym.getSymbolClass();
        } else {
            reducedSym = symbol;
            symClass = symbol.getClass();
        }
        if (this._cc().isExternalSymbol(reducedSym.getName())) {
            return this.unboxValueToType(reducedSym.getType(), this.callMethod(IExternalSymbolMap.class, "getValue", new Class[]{String.class, Integer.TYPE}, this.pushExternalSymbolsMap(), Arrays.asList(this.pushConstant(reducedSym.getName()), this.pushConstant(this.getArrayDims((IReducedSymbol)reducedSym)))));
        }
        if (DynamicSymbol.class.isAssignableFrom(symClass)) {
            IRProperty irProp = IRPropertyFactory.createIRProperty((IReducedSymbol)reducedSym);
            if (!irProp.isStatic()) {
                if (this.isMemberOnEnclosingType((IReducedSymbol)reducedSym) != null) {
                    return this.getField_new(irProp, this.pushOuter((IType)reducedSym.getGosuClass()), IdentifierTransformer.getDescriptor(reducedSym.getType()));
                }
                return this.getField_new(irProp, this.pushThis(), IdentifierTransformer.getDescriptor(reducedSym.getType()));
            }
            return this.getField_new(irProp, null, IdentifierTransformer.getDescriptor(reducedSym.getType()));
        }
        if (CapturedSymbol.class.isAssignableFrom(symClass)) {
            IRProperty irProp = IRPropertyFactory.createIRProperty(this.getGosuClass(), (IReducedSymbol)reducedSym);
            return this.getField_new(irProp, this.pushThis(), IdentifierTransformer.getDescriptor(reducedSym.getType()));
        }
        if (reducedSym.getIndex() >= 0) {
            if (reducedSym.isValueBoxed()) {
                return this.buildArrayLoad((IRExpression)this.identifier(this._cc().getSymbol(reducedSym.getName())), 0, IdentifierTransformer.getDescriptor(type));
            }
            return this.identifier(this._cc().getSymbol(reducedSym.getName()));
        }
        if (DynamicPropertySymbol.class.isAssignableFrom(symClass)) {
            ICompilableTypeInternal targetType;
            IRProperty irProp = reducedSym instanceof DynamicPropertySymbol ? IRPropertyFactory.createIRProperty((DynamicPropertySymbol)reducedSym) : IRPropertyFactory.createIRProperty((ReducedDynamicPropertySymbol)reducedSym);
            IRExpression root = irProp.isStatic() ? null : ((targetType = this.isMemberOnEnclosingType((IReducedSymbol)reducedSym)) != null ? this.pushOuter((IType)targetType) : this.pushThis());
            IRExpression getterCall = this.callMethod(irProp.getGetterMethod(), root, Collections.emptyList());
            return this.castResultingTypeIfNecessary(IdentifierTransformer.getDescriptor(reducedSym.getType()), irProp.getType(), getterCall);
        }
        throw new UnsupportedOperationException("Don't know how to compile symbol: " + reducedSym.getClass().getSimpleName() + ": " + reducedSym.getName() + ": " + reducedSym.getType());
    }

    private int getArrayDims(IReducedSymbol reducedSym) {
        IType type = reducedSym.getType();
        if (type == JavaTypes.OBJECT()) {
            return -1;
        }
        int iDims = 0;
        while (type.isArray()) {
            type = type.getComponentType();
            ++iDims;
        }
        return iDims;
    }

    protected IRExpression pushOuterForOuterSymbol() {
        IRExpression root = this.pushOuter();
        ICompilableTypeInternal currentClass = this.getGosuClass();
        while (currentClass instanceof IBlockClass) {
            currentClass = currentClass.getEnclosingType();
            IRMethod irMethod = IRMethodFactory.createIRMethod((IType)currentClass, "access$0", currentClass.getEnclosingType(), new IType[]{currentClass}, AccessibilityUtil.forOuterAccess(), true);
            root = this.callMethod(irMethod, null, Collections.singletonList(root));
        }
        IType outer = currentClass.getEnclosingType();
        while (outer instanceof IBlockClass) {
            IType enclosing = IdentifierTransformer.getRuntimeEnclosingType(outer);
            IRMethod irMethod = IRMethodFactory.createIRMethod(outer, "access$0", enclosing, new IType[]{outer}, AccessibilityUtil.forOuterAccess(), true);
            root = this.callMethod(irMethod, null, Collections.singletonList(root));
            outer = enclosing;
        }
        return root;
    }
}

