/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.config.CommonServices;
import gw.internal.gosu.parser.statements.LoopStatement;
import gw.lang.parser.IExpansionPropertyInfo;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IPresentationInfo;
import gw.lang.reflect.IPropertyAccessor;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IScriptabilityModifier;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.JavaTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ArrayExpansionPropertyInfo
implements IExpansionPropertyInfo {
    private IPropertyInfo _delegate;
    private IPropertyAccessor _arrayExpansionAccessor;

    public ArrayExpansionPropertyInfo(IPropertyInfo delegate) {
        this._delegate = delegate;
    }

    public boolean isReadable() {
        return this._delegate.isReadable();
    }

    public boolean isWritable(IType whosAskin) {
        return false;
    }

    public boolean isWritable() {
        return this.isWritable(null);
    }

    public IPropertyAccessor getAccessor() {
        if (this._arrayExpansionAccessor == null) {
            this._arrayExpansionAccessor = new ArrayExpansionAccessor();
        }
        return this._arrayExpansionAccessor;
    }

    public IPresentationInfo getPresentationInfo() {
        return IPresentationInfo.Default.GET;
    }

    public boolean isScriptable() {
        return this._delegate.isScriptable();
    }

    public boolean isDeprecated() {
        return this._delegate.isDeprecated();
    }

    public String getDeprecatedReason() {
        return this._delegate.getDeprecatedReason();
    }

    public boolean isDefaultImpl() {
        return this._delegate.isDefaultImpl();
    }

    public boolean isVisible(IScriptabilityModifier constraint) {
        return this._delegate.isVisible(constraint);
    }

    public boolean isHidden() {
        return this._delegate.isHidden();
    }

    public boolean isStatic() {
        return this._delegate.isStatic();
    }

    public boolean isPrivate() {
        return this._delegate.isPrivate();
    }

    public boolean isInternal() {
        return this._delegate.isInternal();
    }

    public boolean isProtected() {
        return this._delegate.isProtected();
    }

    public boolean isPublic() {
        return this._delegate.isPublic();
    }

    public boolean isAbstract() {
        return this._delegate.isAbstract();
    }

    public boolean isFinal() {
        return this._delegate.isFinal();
    }

    public List<IAnnotationInfo> getAnnotations() {
        return Collections.emptyList();
    }

    public List<IAnnotationInfo> getDeclaredAnnotations() {
        return Collections.emptyList();
    }

    public List<IAnnotationInfo> getAnnotationsOfType(IType type) {
        return Collections.emptyList();
    }

    public IAnnotationInfo getAnnotation(IType type) {
        return null;
    }

    public boolean hasAnnotation(IType type) {
        return false;
    }

    public boolean hasDeclaredAnnotation(IType type) {
        return false;
    }

    public IFeatureInfo getContainer() {
        return this._delegate.getContainer();
    }

    public IType getOwnersType() {
        return this._delegate.getOwnersType();
    }

    public String getName() {
        return this._delegate.getName();
    }

    public String getDisplayName() {
        return this._delegate.getDisplayName();
    }

    public String getDescription() {
        return this._delegate.getDescription();
    }

    public IType getFeatureType() {
        if (this._delegate.getFeatureType().isArray()) {
            return this._delegate.getFeatureType();
        }
        return this._delegate.getFeatureType().getArrayType();
    }

    public IPropertyInfo getDelegate() {
        return this._delegate;
    }

    class ArrayExpansionAccessor
    implements IPropertyAccessor {
        ArrayExpansionAccessor() {
        }

        public Object getValue(Object ctx) {
            IPropertyAccessor accessor = ArrayExpansionPropertyInfo.this._delegate.getAccessor();
            if (ctx == null) {
                return null;
            }
            IType type = ArrayExpansionPropertyInfo.this._delegate.getFeatureType();
            IType objArrayType = TypeSystem.getFromObject((Object)ctx);
            boolean bArray = type.isArray();
            ArrayList<Object> results = new ArrayList<Object>();
            Iterator iter = LoopStatement.makeIterator(ctx, objArrayType);
            while (iter.hasNext()) {
                Object value;
                Object elem = iter.next();
                Object object = value = elem == null ? null : accessor.getValue(elem);
                if (value != null && bArray) {
                    results.addAll((Collection)CommonServices.getCoercionManager().convertValue(value, (IType)JavaTypes.ARRAY_LIST()));
                    continue;
                }
                results.add(value);
            }
            return CommonServices.getCoercionManager().convertValue(results, ArrayExpansionPropertyInfo.this.getFeatureType());
        }

        public void setValue(Object ctx, Object value) {
            throw new UnsupportedOperationException("Array expansion properties are not writable.");
        }
    }
}

