/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.config.CommonServices;
import gw.internal.gosu.parser.GosuClassTypeInfo;
import gw.internal.gosu.parser.MetaType;
import gw.internal.gosu.parser.ParserBase;
import gw.internal.gosu.parser.PropertyNotFoundException;
import gw.internal.gosu.parser.TypeLoaderAccess;
import gw.internal.gosu.parser.expressions.ConditionalExpression;
import gw.lang.parser.GosuParserTypes;
import gw.lang.parser.IParserState;
import gw.lang.parser.StandardCoercionManager;
import gw.lang.parser.exceptions.ParseException;
import gw.lang.parser.exceptions.ParseIssue;
import gw.lang.parser.resources.Res;
import gw.lang.reflect.IAttributedFeatureInfo;
import gw.lang.reflect.IConstructorType;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IScriptabilityModifier;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.MethodList;
import gw.lang.reflect.gs.IGosuProgram;
import gw.lang.reflect.java.JavaTypes;
import gw.util.GosuExceptionUtil;
import gw.util.IFeatureFilter;
import java.util.List;

public class BeanAccess {
    private BeanAccess() {
    }

    public static boolean isDescriptorHidden(IAttributedFeatureInfo descriptor) {
        return descriptor.isHidden() || !descriptor.isScriptable();
    }

    public static boolean isBeanType(IType typeSource) {
        return typeSource != GosuParserTypes.STRING_TYPE() && typeSource != GosuParserTypes.BOOLEAN_TYPE() && typeSource != GosuParserTypes.NULL_TYPE() && typeSource != GosuParserTypes.NUMBER_TYPE() && !typeSource.isPrimitive() && !typeSource.isArray() && !(typeSource instanceof IFunctionType) && !(typeSource instanceof IConstructorType) && !(typeSource instanceof MetaType);
    }

    public static boolean isNumericType(IType intrType) {
        if (intrType == null) {
            return false;
        }
        return intrType.isPrimitive() && intrType != JavaTypes.pBOOLEAN() && intrType != JavaTypes.pVOID() || JavaTypes.BYTE() == intrType || JavaTypes.SHORT() == intrType || JavaTypes.CHARACTER() == intrType || JavaTypes.INTEGER() == intrType || JavaTypes.LONG() == intrType || JavaTypes.FLOAT() == intrType || JavaTypes.DOUBLE() == intrType || JavaTypes.BIG_INTEGER() == intrType || JavaTypes.BIG_DECIMAL() == intrType || BeanAccess.isDimension(intrType);
    }

    private static boolean isDimension(IType intrType) {
        return JavaTypes.IDIMENSION().isAssignableFrom(intrType);
    }

    public static boolean isBoxedTypeFor(IType primitiveType, IType boxedType) {
        if (primitiveType != null && primitiveType.isPrimitive()) {
            if (primitiveType == JavaTypes.pBOOLEAN() && boxedType == JavaTypes.BOOLEAN()) {
                return true;
            }
            if (primitiveType == JavaTypes.pBYTE() && boxedType == JavaTypes.BYTE()) {
                return true;
            }
            if (primitiveType == JavaTypes.pCHAR() && boxedType == JavaTypes.CHARACTER()) {
                return true;
            }
            if (primitiveType == JavaTypes.pDOUBLE() && boxedType == JavaTypes.DOUBLE()) {
                return true;
            }
            if (primitiveType == JavaTypes.pFLOAT() && boxedType == JavaTypes.FLOAT()) {
                return true;
            }
            if (primitiveType == JavaTypes.pINT() && boxedType == JavaTypes.INTEGER()) {
                return true;
            }
            if (primitiveType == JavaTypes.pLONG() && boxedType == JavaTypes.LONG()) {
                return true;
            }
            if (primitiveType == JavaTypes.pSHORT() && boxedType == JavaTypes.SHORT()) {
                return true;
            }
        }
        return false;
    }

    public static boolean areValuesEqual(IType lhsType, Object lhsValue, IType rhsType, Object rhsValue) {
        boolean bValue;
        block18: {
            if (lhsValue == null && rhsValue == null) {
                return true;
            }
            if (rhsValue == null || lhsValue == null) {
                return false;
            }
            if (BeanAccess.isNumericType(lhsType)) {
                bValue = ConditionalExpression.compareNumbers(lhsValue, rhsValue, lhsType, rhsType) == 0 ? Boolean.TRUE : Boolean.FALSE;
            } else if (lhsType == GosuParserTypes.STRING_TYPE()) {
                bValue = CommonServices.getCoercionManager().makeStringFrom(lhsValue).equals(CommonServices.getCoercionManager().makeStringFrom(rhsValue));
            } else if (lhsType == GosuParserTypes.BOOLEAN_TYPE() || lhsType == JavaTypes.pBOOLEAN()) {
                bValue = CommonServices.getCoercionManager().makeBooleanFrom(lhsValue).booleanValue() == CommonServices.getCoercionManager().makeBooleanFrom(rhsValue).booleanValue();
            } else if (lhsType == GosuParserTypes.DATETIME_TYPE()) {
                bValue = CommonServices.getCoercionManager().makeDateFrom(lhsValue).equals(CommonServices.getCoercionManager().makeDateFrom(rhsValue));
            } else if (BeanAccess.isBeanType(lhsType)) {
                bValue = BeanAccess.isBeanType(rhsType) ? BeanAccess.areBeansEqual(lhsValue, rhsValue) : BeanAccess.areObjectsLogicallyEqual(lhsType, rhsType, lhsValue, rhsValue);
            } else if (lhsType.isArray() && rhsType.isArray()) {
                try {
                    bValue = true;
                    CommonServices.getCoercionManager().verifyTypesComparable(lhsType, rhsType, true);
                    int lhsLength = lhsType.getArrayLength(lhsValue);
                    int rhsLength = rhsType.getArrayLength(rhsValue);
                    if (lhsLength == rhsLength) {
                        for (int i = 0; i < lhsLength && (bValue &= BeanAccess.areValuesEqual(lhsType.getComponentType(), lhsType.getArrayComponent(lhsValue, i), rhsType.getComponentType(), rhsType.getArrayComponent(rhsValue, i))); ++i) {
                        }
                        break block18;
                    }
                    bValue = false;
                }
                catch (ParseIssue e) {
                    bValue = false;
                }
            } else {
                bValue = BeanAccess.areObjectsLogicallyEqual(lhsType, rhsType, lhsValue, rhsValue);
            }
        }
        return bValue;
    }

    private static boolean areObjectsLogicallyEqual(IType lhsType, IType rhsType, Object lhsValue, Object rhsValue) {
        boolean bConvertLhsType;
        IType type;
        if (lhsValue instanceof IType && rhsValue instanceof IType) {
            return lhsValue.equals(rhsValue);
        }
        try {
            type = CommonServices.getCoercionManager().verifyTypesComparable(lhsType, rhsType, true);
        }
        catch (ParseIssue e) {
            throw GosuExceptionUtil.forceThrow((Throwable)e);
        }
        boolean bl = bConvertLhsType = type != lhsType;
        if (bConvertLhsType ? (lhsValue = CommonServices.getCoercionManager().convertValue(lhsValue, rhsType)) == StandardCoercionManager.NO_DICE : (rhsValue = CommonServices.getCoercionManager().convertValue(rhsValue, lhsType)) == StandardCoercionManager.NO_DICE) {
            return false;
        }
        boolean bValue = lhsValue.equals(rhsValue);
        return bValue;
    }

    public static boolean areBeansEqual(Object bean1, Object bean2) {
        IType class2;
        if (bean1 == bean2) {
            return true;
        }
        if (bean1 == null || bean2 == null) {
            return false;
        }
        IType class1 = TypeLoaderAccess.instance().getIntrinsicTypeFromObject(bean1);
        if (class1.isAssignableFrom(class2 = TypeLoaderAccess.instance().getIntrinsicTypeFromObject(bean2)) || class2.isAssignableFrom(class1)) {
            return bean1.equals(bean2);
        }
        if (CommonServices.getEntityAccess().isDomainInstance(bean1) || CommonServices.getEntityAccess().isDomainInstance(bean2)) {
            return CommonServices.getEntityAccess().areBeansEqual(bean1, bean2);
        }
        return bean1.equals(bean2);
    }

    public static List<? extends IPropertyInfo> getProperties(ITypeInfo beanInfo, IType classBean) {
        if (beanInfo instanceof IRelativeTypeInfo) {
            return ((IRelativeTypeInfo)beanInfo).getProperties(classBean);
        }
        return beanInfo.getProperties();
    }

    public static MethodList getMethods(ITypeInfo beanInfo, IType whosaskin) {
        if (beanInfo instanceof IRelativeTypeInfo && whosaskin != null) {
            return ((IRelativeTypeInfo)beanInfo).getMethods(whosaskin);
        }
        return beanInfo.getMethods();
    }

    public static IPropertyInfo getPropertyInfoDirectly(IType classBean, String strProperty) throws ParseException {
        return BeanAccess.getPropertyInfo(classBean, classBean, strProperty, null, null, null);
    }

    public static IPropertyInfo getPropertyInfo(IType classBean, String strProperty, IFeatureFilter filter, ParserBase parser, IScriptabilityModifier scriptabilityConstraint) throws ParseException {
        Object whosaskin = classBean;
        if (parser != null) {
            whosaskin = parser.getGosuClass();
            Object object = whosaskin = whosaskin != null || GosuClassTypeInfo.isIncludeAll() ? whosaskin : JavaTypes.OBJECT();
            if (GosuClassTypeInfo.isIncludeAll() && whosaskin instanceof IGosuProgram && !whosaskin.getName().startsWith("program_")) {
                whosaskin = null;
            }
        }
        return BeanAccess.getPropertyInfo(classBean, whosaskin, strProperty, filter, parser, scriptabilityConstraint);
    }

    public static IPropertyInfo getPropertyInfo(IType classBean, IType whosAskin, String strProperty, IFeatureFilter filter, ParserBase parser, IScriptabilityModifier scriptabilityConstraint) throws ParseException {
        IPropertyInfo property;
        if (classBean == null) {
            throw new ParseException((IParserState)(parser == null ? null : parser.makeFullParserState()), Res.MSG_BEAN_CLASS_IS_NULL, new Object[0]);
        }
        ITypeInfo beanInfo = classBean.getTypeInfo();
        if (beanInfo == null) {
            throw new ParseException((IParserState)(parser == null ? null : parser.makeFullParserState()), Res.MSG_NO_EXPLICIT_TYPE_INFO_FOUND, new Object[]{classBean.getName()});
        }
        int iArrayBracket = strProperty.indexOf(91);
        if (iArrayBracket > 0) {
            strProperty = strProperty.substring(0, iArrayBracket);
        }
        if ((property = BeanAccess.getProperty(beanInfo, whosAskin, strProperty)) != null && !BeanAccess.isDescriptorHidden((IAttributedFeatureInfo)property) && (filter == null || filter.acceptFeature(classBean, (IFeatureInfo)property))) {
            if (!property.isVisible(scriptabilityConstraint)) {
                throw new ParseException((IParserState)(parser == null ? null : parser.makeFullParserState()), Res.MSG_PROPERTY_NOT_VISIBLE, new Object[]{property.getName()});
            }
            return property;
        }
        throw new PropertyNotFoundException(strProperty, classBean, parser == null ? null : parser.makeFullParserState());
    }

    public static IPropertyInfo getPropertyInfoDirectly_NoException(IType classBean, String strProperty) {
        return BeanAccess.getPropertyInfo_NoException(classBean, classBean, strProperty, null, null, null);
    }

    public static IPropertyInfo getPropertyInfo_NoException(IType classBean, String strProperty, IFeatureFilter filter, ParserBase parser, IScriptabilityModifier scriptabilityConstraint) {
        Object whosaskin = classBean;
        if (parser != null) {
            whosaskin = parser.getGosuClass();
            Object object = whosaskin = whosaskin != null || GosuClassTypeInfo.isIncludeAll() ? whosaskin : JavaTypes.OBJECT();
            if (GosuClassTypeInfo.isIncludeAll() && whosaskin instanceof IGosuProgram && !whosaskin.getName().startsWith("program_")) {
                whosaskin = null;
            }
        }
        return BeanAccess.getPropertyInfo_NoException(classBean, whosaskin, strProperty, filter, parser, scriptabilityConstraint);
    }

    private static IPropertyInfo getPropertyInfo_NoException(IType classBean, IType whosAskin, String strProperty, IFeatureFilter filter, ParserBase parser, IScriptabilityModifier scriptabilityConstraint) {
        IPropertyInfo property;
        if (classBean == null) {
            return null;
        }
        ITypeInfo beanInfo = classBean.getTypeInfo();
        if (beanInfo == null) {
            return null;
        }
        int iArrayBracket = strProperty.indexOf(91);
        if (iArrayBracket > 0) {
            strProperty = strProperty.substring(0, iArrayBracket);
        }
        if ((property = BeanAccess.getProperty(beanInfo, whosAskin, strProperty)) != null && !BeanAccess.isDescriptorHidden((IAttributedFeatureInfo)property) && (filter == null || filter.acceptFeature(classBean, (IFeatureInfo)property))) {
            if (!property.isVisible(scriptabilityConstraint)) {
                return null;
            }
            return property;
        }
        return null;
    }

    public static IPropertyInfo getProperty(ITypeInfo beanInfo, IType classBean, String strMember) {
        IPropertyInfo property = beanInfo instanceof IRelativeTypeInfo ? ((IRelativeTypeInfo)beanInfo).getProperty(classBean, (CharSequence)strMember) : beanInfo.getProperty((CharSequence)strMember);
        return property;
    }
}

