/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.config.CommonServices;
import gw.internal.gosu.parser.ClassJavaClassInfo;
import gw.internal.gosu.parser.FieldJavaClassField;
import gw.internal.gosu.parser.JavaBaseFeatureInfo;
import gw.internal.gosu.parser.JavaMethodInfo;
import gw.internal.gosu.parser.JavaTypeExtensions;
import gw.internal.gosu.parser.MethodJavaClassMethod;
import gw.internal.gosu.parser.TypeLord;
import gw.lang.Deprecated;
import gw.lang.GosuShop;
import gw.lang.PublishedName;
import gw.lang.javadoc.IDocRef;
import gw.lang.javadoc.IMethodNode;
import gw.lang.parser.EvaluationException;
import gw.lang.parser.TypeVarToTypeMap;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IPresentationInfo;
import gw.lang.reflect.IPropertyAccessor;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IScriptabilityModifier;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.ClassInfoUtil;
import gw.lang.reflect.java.IJavaAnnotatedElement;
import gw.lang.reflect.java.IJavaClassField;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaClassMethod;
import gw.lang.reflect.java.IJavaClassType;
import gw.lang.reflect.java.IJavaMethodInfo;
import gw.lang.reflect.java.IJavaPropertyDescriptor;
import gw.lang.reflect.java.IJavaPropertyInfo;
import gw.util.GosuExceptionUtil;
import gw.util.GosuStringUtil;
import gw.util.concurrent.LockingLazyVar;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.List;

public class JavaPropertyInfo
extends JavaBaseFeatureInfo
implements IJavaPropertyInfo {
    private IJavaPropertyDescriptor _pd;
    private IType _propertyTypeWithTypeVars;
    private IPropertyAccessor _accessor;
    private Boolean _bStatic;
    private boolean _bReadable;
    private IJavaClassMethod _getMethod;
    private IJavaClassMethod _setMethod;
    private IJavaClassField _publicField;
    private IPresentationInfo _presInfo;
    private String _name;
    private LockingLazyVar<IJavaAnnotatedElement> _annotatedElement = new LockingLazyVar<IJavaAnnotatedElement>(){

        protected IJavaAnnotatedElement init() {
            return JavaPropertyInfo.this._pd.getReadMethod() != null ? JavaPropertyInfo.this._pd.getReadMethod() : JavaPropertyInfo.this._pd.getWriteMethod();
        }
    };

    JavaPropertyInfo(IFeatureInfo container, IJavaPropertyDescriptor pd) {
        super(container);
        this._pd = pd;
        this.initFlags();
    }

    private JavaPropertyInfo(IFeatureInfo container, IJavaPropertyDescriptor pd, IType propertyType) {
        super(container);
        this._pd = pd;
        this._propertyTypeWithTypeVars = propertyType;
        this.initFlags();
    }

    private JavaPropertyInfo(IFeatureInfo container, IJavaPropertyDescriptor pd, IType propertyType, IPresentationInfo presInfo) {
        this(container, pd, propertyType);
        this._presInfo = presInfo;
    }

    public static IJavaPropertyInfo newInstance(IFeatureInfo container, IJavaPropertyDescriptor pd) {
        return JavaTypeExtensions.maybeExtendProperty(new JavaPropertyInfo(container, pd));
    }

    public static IJavaPropertyInfo newInstance(IFeatureInfo container, IJavaPropertyDescriptor pd, IType propertyType) {
        return JavaTypeExtensions.maybeExtendProperty(new JavaPropertyInfo(container, pd, propertyType));
    }

    public static IJavaPropertyInfo newInstance(IFeatureInfo container, IJavaPropertyDescriptor pd, IType propertyType, IPresentationInfo presInfo) {
        return JavaTypeExtensions.maybeExtendProperty(new JavaPropertyInfo(container, pd, propertyType, presInfo));
    }

    private void initFlags() {
        IAnnotationInfo property;
        this._name = this._pd.getName();
        this._getMethod = this._pd.getReadMethod();
        if (this._getMethod != null) {
            if (this._getMethod instanceof MethodJavaClassMethod) {
                ((MethodJavaClassMethod)this._getMethod).setAccessible(true);
            }
            if ((property = this._getMethod.getAnnotation(PublishedName.class)) != null) {
                this._name = (String)property.getFieldValue("value");
                if (this._name.startsWith("get") || this._name.startsWith("set")) {
                    this._name = this._name.substring(3);
                } else if (this._name.startsWith("is")) {
                    this._name = this._name.substring(2);
                }
            }
        }
        this._setMethod = this._pd.getWriteMethod();
        if (this._setMethod != null) {
            if (this._setMethod instanceof MethodJavaClassMethod) {
                ((MethodJavaClassMethod)this._setMethod).setAccessible(true);
            }
            if ((property = this._setMethod.getAnnotation(PublishedName.class)) != null) {
                this._name = (String)property.getFieldValue("value");
                if (this._name.startsWith("get") || this._name.startsWith("set")) {
                    this._name = this._name.substring(3);
                } else if (this._name.startsWith("is")) {
                    this._name = this._name.substring(2);
                }
            }
        }
        if (this._getMethod == null && this._setMethod != null) {
            this.findFieldOn(this._setMethod.getEnclosingClass(), false);
        }
        if (this._setMethod == null && this._getMethod != null) {
            this.findFieldOn(this._getMethod.getEnclosingClass(), true);
        }
        this._bReadable = this.isReadable();
    }

    private void findFieldOn(IJavaClassInfo clazz, boolean setter) {
        for (IJavaClassField field : clazz.getFields()) {
            IType rhs;
            IType lhs;
            if (!field.getName().equals(this._name) || Modifier.isStatic(field.getModifiers()) != this.isStatic()) continue;
            if (setter) {
                lhs = this.getFeatureType();
                rhs = TypeSystem.get((IJavaClassInfo)field.getType());
            } else {
                rhs = this.getFeatureType();
                lhs = TypeSystem.get((IJavaClassInfo)field.getType());
            }
            if (!CommonServices.getCoercionManager().canCoerce(lhs, rhs)) continue;
            this._publicField = field;
            break;
        }
    }

    public IType getFeatureType() {
        if (this._propertyTypeWithTypeVars != null) {
            return this._propertyTypeWithTypeVars;
        }
        IType propType = this._getMethod != null ? this.getTypeFromMethod(this._getMethod) : (this._setMethod != null ? this.getTypeFromMethod(this._setMethod) : this._pd.getPropertyType());
        IJavaClassInfo declaringClass = this.getDeclaringClass();
        if (declaringClass != null) {
            propType = ClassInfoUtil.getPublishedType((IType)propType, (IJavaClassInfo)declaringClass);
        }
        this._propertyTypeWithTypeVars = propType = TypeLord.replaceRawGenericTypesWithDefaultParameterizedTypes(propType);
        return this._propertyTypeWithTypeVars;
    }

    private IType getTypeFromMethod(IJavaClassMethod m) {
        IType declaringClass = m.getEnclosingClass().getJavaType();
        TypeVarToTypeMap actualParamByVarName = TypeLord.mapTypeByVarName(this.getOwnersType(), declaringClass);
        actualParamByVarName = JavaMethodInfo.addEnclosingTypeParams(declaringClass, actualParamByVarName);
        IType retType = ClassInfoUtil.getActualReturnType((IJavaClassType)m.getGenericReturnType(), (TypeVarToTypeMap)actualParamByVarName, (boolean)true);
        if (TypeSystem.isDeleted((IType)retType)) {
            return null;
        }
        retType = ClassInfoUtil.getPublishedType((IType)retType, (IJavaClassInfo)m.getEnclosingClass());
        return retType;
    }

    private IJavaClassInfo getDeclaringClass() {
        if (this._getMethod != null) {
            return this._getMethod.getEnclosingClass();
        }
        if (this._setMethod != null) {
            return this._setMethod.getEnclosingClass();
        }
        return null;
    }

    public boolean isReadable() {
        IJavaClassMethod get = this._pd.getReadMethod();
        return get != null && !this._pd.isHidden() || this._publicField != null;
    }

    public boolean isWritable(IType whosAskin) {
        IJavaClassMethod set = this._pd.getWriteMethod();
        if (set != null && !this._pd.isHidden() || this._publicField != null && !Modifier.isFinal(this._publicField.getModifiers())) {
            if (this.getContainer() instanceof IRelativeTypeInfo) {
                IRelativeTypeInfo.Accessibility accessibilityForType = ((IRelativeTypeInfo)this.getContainer()).getAccessibilityForType(whosAskin);
                int mods = set != null ? set.getModifiers() : this._publicField.getModifiers();
                boolean isAccessible = false;
                boolean isInternal = !Modifier.isPrivate(mods) && !Modifier.isPublic(mods) && !Modifier.isProtected(mods);
                switch (accessibilityForType) {
                    case PUBLIC: {
                        if (!Modifier.isPublic(mods)) break;
                        isAccessible = true;
                        break;
                    }
                    case PROTECTED: {
                        if (!Modifier.isPublic(mods) && !Modifier.isProtected(mods)) break;
                        isAccessible = true;
                        break;
                    }
                    case INTERNAL: {
                        if (!Modifier.isPublic(mods) && !isInternal && !Modifier.isProtected(mods)) break;
                        isAccessible = true;
                        break;
                    }
                    case PRIVATE: {
                        if (!Modifier.isPublic(mods) && !isInternal && !Modifier.isProtected(mods) && !Modifier.isPrivate(mods)) break;
                        isAccessible = true;
                    }
                }
                return isAccessible;
            }
            return true;
        }
        return false;
    }

    public boolean isWritable() {
        return this.isWritable(null);
    }

    @Override
    public List<IAnnotationInfo> getDeclaredAnnotations() {
        List<IAnnotationInfo> annotations = super.getDeclaredAnnotations();
        if (this.getMethodDocs() != null && this.getMethodDocs().get() != null && ((IMethodNode)this.getMethodDocs().get()).isDeprecated()) {
            annotations.add(GosuShop.getAnnotationInfoFactory().createJavaAnnotation((Annotation)this.makeDeprecated(((IMethodNode)this.getMethodDocs().get()).getDeprecated()), (IFeatureInfo)this));
        }
        return annotations;
    }

    public IDocRef<IMethodNode> getMethodDocs() {
        IMethodInfo methodInfo = this.getReadMethodInfo();
        if (methodInfo instanceof IJavaMethodInfo) {
            return ((IJavaMethodInfo)methodInfo).getMethodDocs();
        }
        methodInfo = this.getWriteMethodInfo();
        if (methodInfo instanceof IJavaMethodInfo) {
            return ((IJavaMethodInfo)methodInfo).getMethodDocs();
        }
        return null;
    }

    public String getReturnDescription() {
        IDocRef<IMethodNode> methodDocs = this.getMethodDocs();
        return methodDocs == null || methodDocs.get() == null ? "" : ((IMethodNode)methodDocs.get()).getReturnDescription();
    }

    public boolean isStatic() {
        if (this._bStatic == null) {
            this._bStatic = Boolean.FALSE;
            IJavaClassMethod getter = this._pd.getReadMethod();
            if (getter != null && Modifier.isStatic(getter.getModifiers())) {
                this._bStatic = Boolean.TRUE;
            }
        }
        return this._bStatic;
    }

    public boolean isPrivate() {
        IJavaClassMethod getter = this._pd.getReadMethod();
        return getter == null ? super.isPrivate() : Modifier.isPrivate(getter.getModifiers());
    }

    public boolean isInternal() {
        return !this.isPrivate() && !this.isPublic() && !this.isProtected();
    }

    public boolean isProtected() {
        IJavaClassMethod getter = this._pd.getReadMethod();
        if (getter != null) {
            return Modifier.isProtected(getter.getModifiers());
        }
        IJavaClassMethod setter = this._pd.getWriteMethod();
        if (setter != null) {
            return Modifier.isProtected(setter.getModifiers());
        }
        return super.isProtected();
    }

    public boolean isPublic() {
        IJavaClassMethod getter = this._pd.getReadMethod();
        if (getter != null) {
            return Modifier.isPublic(getter.getModifiers());
        }
        IJavaClassMethod setter = this._pd.getWriteMethod();
        if (setter != null) {
            return Modifier.isPublic(setter.getModifiers());
        }
        return super.isPublic();
    }

    public boolean isAbstract() {
        IJavaClassMethod getter = this._pd.getReadMethod();
        return getter == null ? super.isAbstract() : Modifier.isAbstract(getter.getModifiers());
    }

    public boolean isFinal() {
        IJavaClassMethod getter = this._pd.getReadMethod();
        return getter == null ? super.isFinal() : Modifier.isFinal(getter.getModifiers());
    }

    @Override
    protected IJavaAnnotatedElement getAnnotatedElement() {
        return (IJavaAnnotatedElement)this._annotatedElement.get();
    }

    @Override
    protected boolean isVisibleViaFeatureDescriptor(IScriptabilityModifier constraint) {
        return this._pd.isVisibleViaFeatureDescriptor(constraint);
    }

    @Override
    protected boolean isHiddenViaFeatureDescriptor() {
        return this._pd.isHiddenViaFeatureDescriptor();
    }

    @Override
    protected boolean isDefaultEnumFeature() {
        return false;
    }

    public boolean isDeprecated() {
        if (super.isDeprecated()) {
            return true;
        }
        if (this._pd.getReadMethod() != null) {
            return this._pd.isDeprecated();
        }
        return false;
    }

    public String getDeprecatedReason() {
        String deprecated = super.getDeprecatedReason();
        if (this.isDeprecated() && deprecated == null) {
            IAnnotationInfo annotation = this._pd.getReadMethod() == null ? null : this._pd.getReadMethod().getAnnotation(Deprecated.class);
            return annotation == null ? "" : (String)annotation.getFieldValue("value");
        }
        return deprecated;
    }

    public IPropertyAccessor getAccessor() {
        if (this._accessor == null) {
            this._accessor = new PropertyAccessorAdaptor();
        }
        return this._accessor;
    }

    public IPresentationInfo getPresentationInfo() {
        return this._presInfo == null ? IPresentationInfo.Default.GET : this._presInfo;
    }

    public String getName() {
        return this._name;
    }

    public String getDisplayName() {
        return this._pd.getDisplayName();
    }

    public String getShortDescription() {
        return this._pd.getShortDescription();
    }

    public String getDescription() {
        String description = null;
        IMethodInfo method = this.getReadMethodInfo();
        if (method != null && GosuStringUtil.isEmpty((String)(description = method.getDescription()))) {
            description = method.getReturnDescription();
        }
        if (GosuStringUtil.isEmpty(description) && (method = this.getWriteMethodInfo()) != null) {
            description = method.getDescription();
        }
        return description;
    }

    public IMethodInfo getReadMethodInfo() {
        IJavaClassMethod method = this.getPropertyDescriptor().getReadMethod();
        if (method != null) {
            return this.getOwnersType().getTypeInfo().getMethod((CharSequence)method.getName(), this.getTypesFromClasses(method.getParameterTypes()));
        }
        return null;
    }

    public IJavaClassField getPublicField() {
        return this._publicField;
    }

    public IMethodInfo getWriteMethodInfo() {
        IJavaClassMethod method = this.getPropertyDescriptor().getWriteMethod();
        if (method != null) {
            return this.getOwnersType().getTypeInfo().getMethod((CharSequence)method.getName(), this.getTypesFromClasses(method.getParameterTypes()));
        }
        return null;
    }

    private IType[] getTypesFromClasses(IJavaClassInfo[] types) {
        IType[] retValue = new IType[types.length];
        for (int i = 0; i < types.length; ++i) {
            IJavaClassInfo type = types[i];
            retValue[i] = type.getJavaType();
        }
        return retValue;
    }

    public String toString() {
        return this.getName();
    }

    public IJavaPropertyDescriptor getPropertyDescriptor() {
        return this._pd;
    }

    public class PropertyAccessorAdaptor
    implements IPropertyAccessor {
        public Object getValue(Object ctx) {
            if (!JavaPropertyInfo.this._bReadable) {
                throw new EvaluationException("Property, " + JavaPropertyInfo.this.getName() + ", is not readable!");
            }
            Object[] args = null;
            try {
                Object rVal;
                if (JavaPropertyInfo.this._getMethod != null) {
                    rVal = JavaPropertyInfo.this._getMethod.invoke(ctx, args);
                } else {
                    rVal = ((FieldJavaClassField)JavaPropertyInfo.this._publicField).get(ctx);
                    rVal = CommonServices.getCoercionManager().convertValue(rVal, JavaPropertyInfo.this.getFeatureType());
                }
                return rVal;
            }
            catch (InvocationTargetException ite) {
                throw GosuExceptionUtil.forceThrow((Throwable)ite.getCause());
            }
            catch (Throwable t) {
                throw GosuExceptionUtil.forceThrow((Throwable)t);
            }
        }

        public void setValue(Object ctx, Object value) {
            if (!JavaPropertyInfo.this.isWritable(JavaPropertyInfo.this.getOwnersType())) {
                throw new EvaluationException("Property, " + JavaPropertyInfo.this.getName() + ", is not writable!");
            }
            try {
                Object[] args = new Object[]{value};
                if (JavaPropertyInfo.this._setMethod != null) {
                    JavaPropertyInfo.this._setMethod.invoke(ctx, args);
                } else {
                    value = CommonServices.getCoercionManager().convertValue(value, TypeSystem.get((IJavaClassInfo)JavaPropertyInfo.this._publicField.getType()));
                    ((FieldJavaClassField)JavaPropertyInfo.this._publicField).set(ctx, value);
                }
            }
            catch (InvocationTargetException ite) {
                throw GosuExceptionUtil.forceThrow((Throwable)ite.getCause());
            }
            catch (Throwable t) {
                throw GosuExceptionUtil.forceThrow((Throwable)t);
            }
        }

        private Class getOwningClass() {
            if (JavaPropertyInfo.this.isWritable(JavaPropertyInfo.this.getOwnersType())) {
                return ((ClassJavaClassInfo)JavaPropertyInfo.this._pd.getWriteMethod().getEnclosingClass()).getJavaClass();
            }
            return ((ClassJavaClassInfo)JavaPropertyInfo.this._pd.getReadMethod().getEnclosingClass()).getJavaClass();
        }

        public IJavaClassMethod getGetterMethod() {
            return JavaPropertyInfo.this._getMethod;
        }

        public IJavaClassMethod getSetterMethod() {
            return JavaPropertyInfo.this._setMethod;
        }
    }
}

