/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.compiler;

import gw.internal.gosu.compiler.CompilationStatistics;
import gw.internal.gosu.compiler.DiscreteClassLoader;
import gw.internal.gosu.compiler.GosuClassLoader;
import gw.internal.gosu.ir.TransformingCompiler;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.ICompilableType;
import gw.lang.reflect.gs.IGosuClassLoader;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.module.TypeSystemLockHelper;
import gw.util.concurrent.ConcurrentHashSet;
import gw.util.concurrent.ConcurrentWeakValueHashMap;
import java.util.Map;
import java.util.Set;

public class SingleServingGosuClassLoader
extends ClassLoader
implements IGosuClassLoader {
    static final Map<String, Class> CACHE = new ConcurrentWeakValueHashMap();
    private GosuClassLoader _parent;
    private Set<String> _classes;

    public static Class getCached(ICompilableType gsClass) {
        return CACHE.get(gsClass.getName());
    }

    public static void clearCache() {
        CACHE.clear();
    }

    public static void clearCache(String gosuClassName) {
        ClassLoader loader;
        Class cls = CACHE.remove(gosuClassName);
        if (cls != null && (loader = cls.getClassLoader()) instanceof SingleServingGosuClassLoader) {
            ((SingleServingGosuClassLoader)loader).unload(gosuClassName);
        }
    }

    SingleServingGosuClassLoader() {
    }

    SingleServingGosuClassLoader(GosuClassLoader parent) {
        super(parent.getActualLoader());
        this._parent = parent;
        this._classes = new ConcurrentHashSet();
    }

    @Override
    public Class<?> findClass(String strName) throws ClassNotFoundException {
        Class cls = CACHE.get(strName.replace('$', '.'));
        if (cls != null) {
            return cls;
        }
        return this._parent.findClass(strName);
    }

    protected void unload(String gosuClassName) {
        this._classes.forEach(CACHE::remove);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        TypeSystemLockHelper.getTypeSystemLockWithMonitor((Object)this);
        try {
            String ns;
            int iDot = name.lastIndexOf(46);
            if (iDot > 0 && this._parent.hasDiscreteNamespace(ns = name.substring(0, iDot))) {
                DiscreteClassLoader loader = this._parent.getDiscreteNamespaceLoader(ns);
                IType type = TypeSystem.getByFullNameIfValidNoJava((String)name);
                if (type instanceof ICompilableType) {
                    Class clazz = loader._defineClass((ICompilableType)type);
                    return clazz;
                }
            }
            Class<?> clazz = super.loadClass(name, resolve);
            return clazz;
        }
        finally {
            TypeSystem.unlock();
        }
    }

    public void dumpAllClasses() {
    }

    public boolean waitForLoaderToUnload(String packageName, long millisToWait) {
        return this._parent.waitForLoaderToUnload(packageName, millisToWait);
    }

    public void evictLoader(String packageName) {
        this._parent.evictLoader(packageName);
    }

    Class _defineClass(ICompilableType gsClass) {
        String javaName;
        Class<?> cls = SingleServingGosuClassLoader.getCached(gsClass);
        if (cls != null) {
            return cls;
        }
        byte[] classBytes = this.compileClass(gsClass, this._parent.shouldDebugClass(gsClass));
        CompilationStatistics.instance().collectStats(gsClass, classBytes, true);
        String gosuClassName = gsClass.getName();
        if (classBytes == null) {
            throw new IllegalStateException("Could not generate class for " + gosuClassName);
        }
        String strPackage = gsClass.getNamespace();
        if (this.getPackage(strPackage) == null) {
            this.definePackage(strPackage, null, null, null, null, null, null, null);
        }
        if ((cls = this.findLoadedClass(javaName = GosuClassLoader.getJavaName((IType)gsClass))) == null) {
            cls = this.defineClass(javaName, classBytes, 0, classBytes.length);
        }
        if (this.shouldCache(gsClass)) {
            CACHE.put(gosuClassName, cls);
            this._classes.add(gosuClassName);
        }
        return cls;
    }

    private boolean shouldCache(ICompilableType gsClass) {
        return gsClass != null && !gsClass.getName().startsWith("_nopackage_.GosuScratchpad");
    }

    private byte[] compileClass(ICompilableType type, boolean debug) {
        return TransformingCompiler.compileClass(type, debug);
    }

    public IJavaType getFunctionClassForArity(int length) {
        return null;
    }

    public ClassLoader getActualLoader() {
        return this;
    }

    public Class defineClass(String name, byte[] bytes) {
        return super.defineClass(name, bytes, 0, bytes.length);
    }

    public byte[] getBytes(ICompilableType gsClass) {
        return this.compileClass(gsClass, false);
    }

    public void assignParent(ClassLoader classLoader) {
        throw new UnsupportedOperationException("Should not happen");
    }

    public boolean isDisposed() {
        return false;
    }
}

