/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.statements;

import gw.internal.gosu.parser.CannotExecuteGosuException;
import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.Statement;
import gw.internal.gosu.parser.statements.CaseClause;
import gw.internal.gosu.parser.statements.ThrowStatement;
import gw.lang.parser.statements.IBreakStatement;
import gw.lang.parser.statements.ISwitchStatement;
import gw.lang.parser.statements.ITerminalStatement;
import gw.lang.reflect.IEnumType;
import gw.lang.reflect.IType;
import java.util.List;

public final class SwitchStatement
extends Statement
implements ISwitchStatement {
    protected Expression _switchExpression;
    protected CaseClause[] _cases;
    protected List<Statement> _defaultStatements;

    public Expression getSwitchExpression() {
        return this._switchExpression;
    }

    public void setSwitchExpression(Expression switchExpression) {
        this._switchExpression = switchExpression;
    }

    public CaseClause[] getCases() {
        return this._cases;
    }

    public void setCases(CaseClause[] cases) {
        this._cases = cases;
    }

    public List<Statement> getDefaultStatements() {
        return this._defaultStatements;
    }

    public void setDefaultStatements(List<Statement> defaultStatements) {
        this._defaultStatements = defaultStatements;
    }

    @Override
    public Object execute() {
        if (!this.isCompileTimeConstant()) {
            return super.execute();
        }
        throw new CannotExecuteGosuException();
    }

    @Override
    protected ITerminalStatement getLeastSignificantTerminalStatement_internal(boolean[] bAbsolute) {
        ITerminalStatement termRet = null;
        bAbsolute[0] = true;
        boolean bBreak = false;
        ITerminalStatement lastCaseTerm = null;
        if (this._cases != null) {
            for (int i = 0; i < this._cases.length; ++i) {
                List<Statement> caseStatements = this._cases[i].getStatements();
                if (caseStatements == null || caseStatements.size() <= 0) continue;
                boolean bCaseAbs = true;
                for (int iStmt = 0; iStmt < caseStatements.size(); ++iStmt) {
                    boolean[] bCsr = new boolean[]{false};
                    ITerminalStatement terminalStmt = caseStatements.get(iStmt).getLeastSignificantTerminalStatement(bCsr);
                    if (terminalStmt == null) continue;
                    bCaseAbs = bCsr[0];
                    if (!(terminalStmt instanceof IBreakStatement)) {
                        termRet = SwitchStatement.getLeastSignificant(termRet, terminalStmt);
                        if (i != this._cases.length - 1) continue;
                        lastCaseTerm = termRet;
                        continue;
                    }
                    bCaseAbs = false;
                    bAbsolute[0] = false;
                    bBreak = true;
                }
                bAbsolute[0] = bAbsolute[0] && bCaseAbs;
            }
        }
        boolean bDefaultContributed = false;
        if (this._defaultStatements != null) {
            if (this._defaultStatements.size() > 0) {
                if (!bBreak) {
                    bAbsolute[0] = true;
                }
                boolean bDefaultAbs = false;
                for (int i = 0; i < this._defaultStatements.size(); ++i) {
                    boolean[] bCsr = new boolean[]{false};
                    ITerminalStatement terminalStmt = this._defaultStatements.get(i).getLeastSignificantTerminalStatement(bCsr);
                    if (terminalStmt == null || terminalStmt instanceof IBreakStatement) continue;
                    bDefaultAbs = bCsr[0];
                    termRet = SwitchStatement.getLeastSignificant(termRet, terminalStmt);
                    bDefaultContributed = true;
                }
                bAbsolute[0] = bAbsolute[0] && bDefaultAbs;
            }
        } else if (!bBreak && lastCaseTerm != null && this.isCoveredEnumSwitch()) {
            termRet = SwitchStatement.getLeastSignificant(new ThrowStatement(), lastCaseTerm);
            bDefaultContributed = true;
            bAbsolute[0] = true;
        }
        bAbsolute[0] = bAbsolute[0] && termRet != null && bDefaultContributed;
        return termRet;
    }

    public boolean isCoveredEnumSwitch() {
        CaseClause[] cases;
        Expression switchExpression = this.getSwitchExpression();
        IType switchType = switchExpression.getType();
        if (!switchType.isEnum()) {
            return false;
        }
        List enumValues = ((IEnumType)switchType).getEnumConstants();
        for (CaseClause caseClause : cases = this.getCases()) {
            if (enumValues == null || !caseClause.getExpression().isCompileTimeConstant()) continue;
            try {
                Object value = caseClause.getExpression().evaluate();
                if (value == null) continue;
                enumValues.remove(value.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return cases.length > 0 && enumValues.isEmpty();
    }

    @Override
    public String toString() {
        String strRet = "switch( " + this.getSwitchExpression().toString() + " )\n {\n";
        if (this._cases != null) {
            for (int i = 0; i < this._cases.length; ++i) {
                strRet = strRet + "case " + this._cases[i].getExpression().toString() + ":\n";
                List<Statement> caseStatements = this._cases[i].getStatements();
                if (caseStatements == null) continue;
                for (int iStmt = 0; iStmt < caseStatements.size(); ++iStmt) {
                    strRet = strRet + ((Object)caseStatements.get(iStmt)).toString();
                }
            }
            if (this._defaultStatements != null) {
                strRet = strRet + "default:\n";
                for (int iStmt = 0; iStmt < this._defaultStatements.size(); ++iStmt) {
                    strRet = strRet + this._defaultStatements.get(iStmt).toString();
                }
            }
        }
        strRet = strRet + "\n}";
        return strRet;
    }
}

