/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.compiler;

import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.module.IModule;
import gw.util.GosuExceptionUtil;

public class FunctionClassUtil
extends ClassLoader {
    public static final String FUNCTION_PACKAGE = "gw.lang.function";
    public static final String FUNCTION_CLASS_PREFIX = "gw.lang.function.Function";
    public static final String FUNCTION_INTERFACE_PREFIX = "gw.lang.function.IFunction";
    private static final Class[][] ARGS = new Class[17][];

    private FunctionClassUtil() {
    }

    public static IJavaType getFunctionClassForArity(int functionArity) {
        return FunctionClassUtil.getFunctionType(functionArity, FUNCTION_CLASS_PREFIX);
    }

    public static IJavaType getFunctionInterfaceForArity(int functionArity) {
        return FunctionClassUtil.getFunctionType(functionArity, FUNCTION_INTERFACE_PREFIX);
    }

    private static IJavaType getFunctionType(int functionArity, String s) {
        if (functionArity >= 0 && functionArity <= 16) {
            String functionTypeName = s + functionArity;
            return (IJavaType)TypeSystem.getByFullNameIfValid((String)functionTypeName, (IModule)TypeSystem.getGlobalModule());
        }
        return null;
    }

    public static String getFunctionInterfaceSlashNameForArity(int arity) {
        return "gw/lang/function/IFunction" + arity;
    }

    private Class getFunctionClassForArityImpl(int functionArity) {
        String functionTypeName = FUNCTION_CLASS_PREFIX + functionArity;
        if (functionArity >= 0 && functionArity <= 16) {
            try {
                return Class.forName(functionTypeName, false, this.getClass().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw GosuExceptionUtil.forceThrow((Throwable)e);
            }
        }
        return null;
    }

    public static Class[] getArgArrayForArity(int i) {
        return ARGS[i];
    }

    static {
        for (int i = 0; i <= 16; ++i) {
            Class[] classes1 = new Class[i];
            for (int j = 0; j < i; ++j) {
                classes1[j] = Object.class;
            }
            FunctionClassUtil.ARGS[i] = classes1;
        }
    }
}

