/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.CommonSymbolsScope;
import gw.internal.gosu.parser.CompiledGosuClassSymbolTable;
import gw.internal.gosu.parser.fragments.GosuFragment;
import gw.lang.parser.GosuParserFactory;
import gw.lang.parser.IExpression;
import gw.lang.parser.IFileContext;
import gw.lang.parser.IFunctionSymbol;
import gw.lang.parser.IGosuFragmentParser;
import gw.lang.parser.IGosuParser;
import gw.lang.parser.IScriptPartId;
import gw.lang.parser.ISymbol;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.ParserOptions;
import gw.lang.parser.ScriptPartId;
import gw.lang.parser.exceptions.ParseResultsException;
import gw.lang.reflect.FragmentCache;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGosuFragment;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class GosuFragmentParser
implements IGosuFragmentParser {
    private static final GosuFragmentParser _instance = new GosuFragmentParser();
    private static AtomicInteger _fragmentCount = new AtomicInteger();

    public static GosuFragmentParser getInstance() {
        return _instance;
    }

    private GosuFragmentParser() {
    }

    public IGosuFragment parseExpressionOnly(String script, ISymbolTable table, ParserOptions options) throws ParseResultsException {
        return this.parseImpl(script, table, options, this.determineName(options.getFileContext()), this.determineExternalSymbols(table, options), true);
    }

    public IGosuFragment parseProgramOnly(String script, ISymbolTable table, ParserOptions options) throws ParseResultsException {
        return this.parseImpl(script, table, options, this.determineName(options.getFileContext()), this.determineExternalSymbols(table, options), false);
    }

    public IGosuFragment parseExpressionOrProgram(String script, ISymbolTable table, ParserOptions options) throws ParseResultsException {
        String name = this.determineName(options.getFileContext());
        HashMap<String, ISymbol> externalSymbolNames = this.determineExternalSymbols(table, options);
        try {
            return this.parseImpl(script, table, options, name, externalSymbolNames, true);
        }
        catch (ParseResultsException pe) {
            try {
                return this.parseImpl(script, table, options, name, externalSymbolNames, false);
            }
            catch (ParseResultsException peProg) {
                throw pe;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IGosuFragment parseImpl(String script, ISymbolTable table, ParserOptions options, String name, HashMap<String, ISymbol> externalSymbols, boolean parseExpression) throws ParseResultsException {
        IGosuParser parser = GosuParserFactory.createParser((String)script);
        parser.putDfsDeclsInTable(table);
        options.setParserOptions(parser);
        GosuFragment fragment = new GosuFragment(name, externalSymbols, options.getTypeUsesMap());
        FragmentCache.instance().addFragment((IGosuFragment)fragment);
        TypeSystem.pushSymTableCtx((ISymbolTable)table);
        try {
            Object result;
            parser.setSymbolTable(TypeSystem.getCompiledGosuClassSymbolTable());
            CompiledGosuClassSymbolTable.instance().pushCompileTimeSymbolTable(fragment, table);
            try {
                result = parseExpression ? parser.parseExp((IScriptPartId)new ScriptPartId((IType)fragment, null), options.getExpectedType(), options.getFileContext(), false) : parser.parseProgram((IScriptPartId)new ScriptPartId((IType)fragment, null), true, true, options.getExpectedType(), options.getFileContext(), false);
            }
            finally {
                CompiledGosuClassSymbolTable.instance().popCompileTimeSymbolTable(fragment);
            }
            fragment.setExpression((IExpression)result);
            GosuFragment gosuFragment = fragment;
            return gosuFragment;
        }
        catch (ParseResultsException e) {
            if (e.hasOnlyParseWarnings()) {
                IExpression result = (IExpression)e.getParsedElement();
                fragment.setExpression(result);
                GosuFragment gosuFragment = fragment;
                return gosuFragment;
            }
            throw e;
        }
        finally {
            TypeSystem.popSymTableCtx();
        }
    }

    private String determineName(IFileContext fileContext) {
        String name;
        String string = name = fileContext == null ? null : fileContext.getClassName();
        if (name == null) {
            name = "__Fragment__" + _fragmentCount.getAndIncrement();
        }
        if (fileContext != null && fileContext.getContextString() != null) {
            name = name + "_" + fileContext.getContextString();
        }
        return name;
    }

    private HashMap<String, ISymbol> determineExternalSymbols(ISymbolTable symbolTable, ParserOptions options) {
        Map declSymbolMap;
        ISymbolTable decls;
        Map symbols = symbolTable.getSymbols();
        if (symbols == null && options.getAdditionalDFSDecls() == null && options.getDeclSymbols() == null) {
            return new HashMap<String, ISymbol>(0);
        }
        HashMap<String, ISymbol> symbolNames = new HashMap<String, ISymbol>(8);
        if (symbols != null) {
            for (ISymbol sym : symbols.values()) {
                if (sym instanceof CommonSymbolsScope.LockedDownSymbol || sym == null) continue;
                symbolNames.put(sym.getName(), sym);
            }
        }
        if ((decls = options.getAdditionalDFSDecls()) != null) {
            for (ISymbol sym : decls.getSymbols().values()) {
                if (sym instanceof CommonSymbolsScope.LockedDownSymbol || sym == null) continue;
                symbolNames.put(sym.getName(), sym);
            }
        }
        if ((declSymbolMap = options.getDeclSymbols()) != null) {
            for (List symbolSet : declSymbolMap.values()) {
                for (IFunctionSymbol sym : symbolSet) {
                    if (sym instanceof CommonSymbolsScope.LockedDownSymbol || sym == null) continue;
                    symbolNames.put(sym.getName(), (ISymbol)sym);
                }
            }
        }
        return symbolNames;
    }
}

