/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.MethodJavaClassMethod;
import gw.internal.gosu.parser.java.classinfo.JavaSourceUtil;
import gw.lang.reflect.BeanInfoUtil;
import gw.lang.reflect.IScriptabilityModifier;
import gw.lang.reflect.IType;
import gw.lang.reflect.ReflectUtil;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaClassMethod;
import gw.lang.reflect.java.IJavaPropertyDescriptor;
import gw.lang.reflect.module.IModule;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;

public class PropertyDescriptorJavaPropertyDescriptor
implements IJavaPropertyDescriptor {
    private PropertyDescriptor _pd;
    private IModule _module;

    public PropertyDescriptorJavaPropertyDescriptor(PropertyDescriptor propertyDescriptor, IModule module) {
        this._pd = propertyDescriptor;
        this._module = module;
    }

    public String getName() {
        return this._pd.getName();
    }

    public IJavaClassMethod getReadMethod() {
        Method method = this.getReadMethodSafe();
        return method == null ? null : new MethodJavaClassMethod(method, this._module);
    }

    private Method getReadMethodSafe() {
        try {
            return this._pd.getReadMethod();
        }
        catch (NullPointerException originalException) {
            if (PropertyDescriptorJavaPropertyDescriptor.shouldFixJREMethodRefIssue()) {
                try {
                    this.reestablishMethodRef("read");
                    return this._pd.getReadMethod();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            throw originalException;
        }
    }

    public IJavaClassMethod getWriteMethod() {
        Method method = this.getWriteMethodSafe();
        return method == null ? null : new MethodJavaClassMethod(method, this._module);
    }

    private Method getWriteMethodSafe() {
        try {
            return this._pd.getWriteMethod();
        }
        catch (NullPointerException originalException) {
            if (PropertyDescriptorJavaPropertyDescriptor.shouldFixJREMethodRefIssue()) {
                try {
                    this.reestablishMethodRef("write");
                    return this._pd.getWriteMethod();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            throw originalException;
        }
    }

    private void reestablishMethodRef(String slot) {
        Class clazz = (Class)ReflectUtil.invokeMethod((Object)this._pd, (String)"getClass0", (Object[])new Object[0]);
        String signature = slot.equals("write") ? this.getSetterMethod(clazz, this._pd) : this.getGetterMethod(clazz);
        Method resolvedMethod = PropertyDescriptorJavaPropertyDescriptor.findMethod0(clazz, signature);
        Object methodRef = ReflectUtil.getProperty((Object)this._pd, (String)(slot + "MethodRef"));
        ReflectUtil.invokeMethod((Object)methodRef, (String)"set", (Object[])new Object[]{resolvedMethod});
    }

    private String getGetterMethod(Class rootClass) {
        return rootClass.getName() + ".get" + this._pd.getName() + "()";
    }

    private String getSetterMethod(Class rootClass, PropertyDescriptor propertyDescriptor) {
        return rootClass.getName() + ".set" + this._pd.getName() + "(" + propertyDescriptor.getPropertyType().getName() + ")";
    }

    static Method findMethod0(Class<?> type, String signature) {
        if (type != null) {
            for (Method method : type.getDeclaredMethods()) {
                if (!method.toGenericString().endsWith(" " + signature)) continue;
                return method;
            }
            return PropertyDescriptorJavaPropertyDescriptor.findMethod0(type.getSuperclass(), signature);
        }
        return null;
    }

    public IType getPropertyType() {
        return TypeSystem.get(this._pd.getPropertyType());
    }

    public IJavaClassInfo getPropertyClassInfo() {
        return JavaSourceUtil.getClassInfo(this._pd.getPropertyType(), this._module);
    }

    public boolean isHidden() {
        return this._pd.isHidden();
    }

    public boolean isVisibleViaFeatureDescriptor(IScriptabilityModifier constraint) {
        return BeanInfoUtil.isVisible((FeatureDescriptor)this._pd, (IScriptabilityModifier)constraint);
    }

    public boolean isHiddenViaFeatureDescriptor() {
        return this._pd.isHidden();
    }

    public boolean isDeprecated() {
        return this._pd.getReadMethod().isAnnotationPresent(gw.lang.Deprecated.class) || BeanInfoUtil.isDeprecated((FeatureDescriptor)this._pd) || this._pd.getReadMethod() != null && this._pd.getReadMethod().isAnnotationPresent(Deprecated.class);
    }

    public String getDisplayName() {
        return this._pd.getDisplayName();
    }

    public String getShortDescription() {
        return this._pd.getShortDescription();
    }

    static boolean shouldFixJREMethodRefIssue() {
        String vendor = System.getProperty("java.vendor");
        if (vendor != null) {
            return vendor.toLowerCase().contains("sun") || vendor.toLowerCase().contains("oracle");
        }
        return false;
    }
}

