/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.AnnotationInfoInvocationHandler;
import gw.internal.gosu.parser.ClassJavaClassInfo;
import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.IGosuAnnotation;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.TypeLord;
import gw.internal.gosu.parser.TypeUsesMap;
import gw.internal.gosu.parser.TypedSymbol;
import gw.internal.gosu.parser.java.classinfo.CompileTimeExpressionParser;
import gw.internal.gosu.parser.java.classinfo.JavaSourceDefaultValue;
import gw.lang.parser.GosuParserFactory;
import gw.lang.parser.ICompilationState;
import gw.lang.parser.IExpression;
import gw.lang.parser.IGosuParser;
import gw.lang.parser.IParseResult;
import gw.lang.parser.IParseTree;
import gw.lang.parser.IScriptPartId;
import gw.lang.parser.ISymbol;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.ITypeUsesMap;
import gw.lang.parser.ParserOptions;
import gw.lang.parser.StandardSymbolTable;
import gw.lang.parser.SymbolType;
import gw.lang.parser.TypelessScriptPartId;
import gw.lang.parser.exceptions.ParseResultsException;
import gw.lang.parser.expressions.IIdentifierExpression;
import gw.lang.parser.expressions.INewExpression;
import gw.lang.reflect.BaseFeatureInfo;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IHasJavaClass;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuConstructorInfo;
import gw.lang.reflect.gs.IGosuMethodInfo;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaClassMethod;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.java.JavaTypes;
import gw.util.GosuClassUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;

public class GosuAnnotationInfo
implements IAnnotationInfo {
    private static final Object NOT_FOUND = new Object(){

        public String toString() {
            return "NOT FOUND";
        }
    };
    private volatile Object _instance;
    private IFeatureInfo _container;
    private IGosuClassInternal _owner;
    private String _newExpressionAsString;
    private INewExpression _expr;
    private IGosuAnnotation _rawAnnotation;
    private IType _type;

    public GosuAnnotationInfo(IGosuAnnotation rawAnnotation, IFeatureInfo container, IGosuClassInternal owner) {
        this._rawAnnotation = rawAnnotation;
        this._container = container;
        this._instance = null;
        this._owner = owner;
        this._newExpressionAsString = rawAnnotation.getNewExpressionAsString();
        this._type = rawAnnotation.getType();
        IExpression e = rawAnnotation.getExpression();
        this._expr = e instanceof INewExpression ? (INewExpression)e : null;
    }

    public String getName() {
        return this._type.getName();
    }

    public IFeatureInfo getContainer() {
        return this._container;
    }

    public IGosuClassInternal getOwnersType() {
        return this._owner;
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getDescription() {
        return this.getName();
    }

    public Object getInstance() {
        block7: {
            if (this._instance == null) {
                TypeSystem.lock();
                this.ensureOwnerIsFullyParsedAndValid();
                try {
                    if (this._instance != null) break block7;
                    if (this._owner != null && this._owner.isProxy()) {
                        this._instance = this.getFromJavaType();
                        break block7;
                    }
                    if (JavaTypes.ANNOTATION().isAssignableFrom(this.getType())) {
                        this._instance = this.makeAnnotationInfoProxy();
                        break block7;
                    }
                    if (JavaTypes.IANNOTATION().isAssignableFrom(this.getType())) {
                        this.getOwnersType().isValid();
                        this._instance = this.eval(this._newExpressionAsString, this.getType());
                        break block7;
                    }
                    throw new IllegalStateException("Could not create annotation instance for type: " + this.getType().getName());
                }
                finally {
                    TypeSystem.unlock();
                }
            }
        }
        return this._instance;
    }

    private void ensureOwnerIsFullyParsedAndValid() {
        if (this._owner != null) {
            ICompilationState state = this._owner.getCompilationState();
            if (state.isCompilingHeader() || state.isCompilingDeclarations()) {
                throw new IllegalStateException("You cannot request Annotation values during the declaration parsing phase.");
            }
            this._owner.compileDeclarationsIfNeeded();
        }
    }

    private Annotation makeAnnotationInfoProxy() {
        IType annotationType = this.getType();
        Class annotationClass = ((IHasJavaClass)annotationType).getBackingClass();
        return (Annotation)Proxy.newProxyInstance(annotationClass.getClassLoader(), new Class[]{annotationClass}, (InvocationHandler)new AnnotationInfoInvocationHandler(this));
    }

    private Object getFromJavaType() {
        IJavaType javaType = this._owner.getJavaType();
        IRelativeTypeInfo typeInfo = (IRelativeTypeInfo)javaType.getTypeInfo();
        if (this._container instanceof IPropertyInfo) {
            return typeInfo.getProperty((IType)javaType, (CharSequence)this._container.getDisplayName()).getAnnotation(this.getType()).getInstance();
        }
        return typeInfo.getMethod((IType)javaType, (CharSequence)this._container.getDisplayName(), BaseFeatureInfo.getParamTypes((IParameterInfo[])((IMethodInfo)this._container).getParameters())).getAnnotation(this.getType()).getInstance();
    }

    public Object getFieldValue(String field) {
        Object value = this.getValueFromCallSite(field);
        if (value == NOT_FOUND) {
            value = this.getValueFromDeclaredDefaultValueAtDeclSite(this._type, field);
            if (value == NOT_FOUND) {
                throw new RuntimeException("Annotation field, " + field + ", not found in " + this._type.getName());
            }
            value = CompileTimeExpressionParser.convertValueToInfoFriendlyValue(value, this._container);
        }
        return value;
    }

    private Object getValueFromDeclaredDefaultValueAtDeclSite(IType type, String field) {
        if (type instanceof IJavaType) {
            IJavaClassInfo classInfo = ((IJavaType)type).getBackingClassInfo();
            try {
                IJavaClassMethod m = classInfo.getDeclaredMethod(field, new IJavaClassInfo[0]);
                Object value = m.getDefaultValue();
                if (value instanceof JavaSourceDefaultValue) {
                    value = ((JavaSourceDefaultValue)value).evaluate();
                }
                return value;
            }
            catch (NoSuchMethodException e) {
                return NOT_FOUND;
            }
        }
        if (type instanceof IGosuClass) {
            IExpression annotationDefault;
            IGosuClass gsClass = (IGosuClass)type;
            IGosuMethodInfo method = (IGosuMethodInfo)gsClass.getTypeInfo().getMethod((IType)gsClass, (CharSequence)field, new IType[0]);
            if (method != null && (annotationDefault = method.getDfs().getDefaultValueExpression()) != null) {
                return CompileTimeExpressionParser.convertValueToInfoFriendlyValue(annotationDefault.evaluate(), (IFeatureInfo)gsClass.getTypeInfo());
            }
            List ctors = gsClass.getTypeInfo().getConstructors((IType)gsClass);
            for (IConstructorInfo ctor : ctors) {
                if (!(ctor instanceof IGosuConstructorInfo)) continue;
                String[] paramNames = ((IGosuConstructorInfo)ctor).getParameterNames();
                for (int i = 0; i < paramNames.length; ++i) {
                    String paramName = paramNames[i];
                    if (paramName == null || !paramName.equals(field)) continue;
                    return ((IGosuConstructorInfo)ctor).getDefaultValueExpressions()[i].evaluate();
                }
            }
        }
        return NOT_FOUND;
    }

    private Object getValueFromCallSite(String field) {
        IExpression[] args;
        ArrayList ids = new ArrayList();
        this.getExpr().getContainedParsedElementsByType(IIdentifierExpression.class, ids);
        boolean bTypedSymFound = false;
        if (!ids.isEmpty()) {
            for (IIdentifierExpression id : ids) {
                ISymbol sym = id.getSymbol();
                boolean bl = bTypedSymFound = bTypedSymFound || sym instanceof TypedSymbol;
                if (!(sym instanceof TypedSymbol) || ((TypedSymbol)sym).getSymbolType() != SymbolType.NAMED_PARAMETER || !sym.getName().equals(field)) continue;
                IParseTree nextSibling = id.getLocation().getNextSibling();
                if (nextSibling != null) {
                    Expression expr = (Expression)nextSibling.getParsedElement();
                    return this.evaluate(expr);
                }
                return NOT_FOUND;
            }
        }
        if (!bTypedSymFound && (args = this.getExpr().getArgs()) != null && args.length > 0) {
            IJavaClassInfo classInfo;
            IParameterInfo[] parameters = this.getExpr().getConstructor().getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                IParameterInfo param = parameters[i];
                if (!field.equalsIgnoreCase(param.getDisplayName())) continue;
                return this.evaluate(args[i]);
            }
            if (this.getType() instanceof IJavaType && (classInfo = ((IJavaType)this.getType()).getBackingClassInfo()) instanceof ClassJavaClassInfo) {
                Field[] fields = classInfo.getBackingClass().getDeclaredFields();
                for (int i = 0; i < fields.length; ++i) {
                    Field f = fields[i];
                    if (!field.equalsIgnoreCase(f.getName())) continue;
                    return this.evaluate(args[i]);
                }
            }
        }
        if ("value".equalsIgnoreCase(field) && (args = this.getExpr().getArgs()) != null && args.length == 1) {
            return this.evaluate(args[0]);
        }
        return NOT_FOUND;
    }

    private Object evaluate(IExpression expr) {
        return CompileTimeExpressionParser.convertValueToInfoFriendlyValue(expr.evaluate(), this._container);
    }

    private INewExpression getExpr() {
        if (this._expr == null) {
            this._expr = this.parseNewExpression();
        }
        return this._expr;
    }

    private INewExpression parseNewExpression() {
        IGosuClassInternal ownersType = (IGosuClassInternal)this._container.getOwnersType();
        IType outerMostEnclosingType = TypeLord.getOuterMostEnclosingClass((IType)ownersType);
        ITypeUsesMap usesMap = outerMostEnclosingType instanceof IGosuClass ? ((IGosuClass)outerMostEnclosingType).getTypeUsesMap() : ownersType.getTypeUsesMap();
        if (usesMap != null) {
            usesMap = usesMap.copy();
            usesMap.addToDefaultTypeUses("gw.lang.");
        } else {
            usesMap = new TypeUsesMap();
        }
        GosuAnnotationInfo.addEnclosingPackages(usesMap, (IType)ownersType);
        ParserOptions options = new ParserOptions().withTypeUsesMap(usesMap);
        IGosuParser parser = GosuParserFactory.createParser((String)this._newExpressionAsString);
        options.setParserOptions(parser);
        StandardSymbolTable symTable = new StandardSymbolTable(true);
        TypeSystem.pushSymTableCtx((ISymbolTable)symTable);
        try {
            parser.setSymbolTable(TypeSystem.getCompiledGosuClassSymbolTable());
            INewExpression iNewExpression = (INewExpression)parser.parseExp((IScriptPartId)new TypelessScriptPartId(this.toString()), options.getExpectedType(), options.getFileContext(), false);
            return iNewExpression;
        }
        catch (ParseResultsException e) {
            if (e.hasOnlyParseWarnings()) {
                INewExpression iNewExpression = (INewExpression)e.getParsedElement();
                return iNewExpression;
            }
            throw new RuntimeException(e);
        }
        finally {
            TypeSystem.popSymTableCtx();
        }
    }

    private Object eval(String strExprSource, IType type) {
        IGosuClassInternal ownersType = (IGosuClassInternal)this._container.getOwnersType();
        IType outerMostEnclosingType = TypeLord.getOuterMostEnclosingClass((IType)ownersType);
        ITypeUsesMap usesMap = outerMostEnclosingType instanceof IGosuClass ? ((IGosuClass)outerMostEnclosingType).getTypeUsesMap() : ownersType.getTypeUsesMap();
        if (usesMap != null) {
            usesMap = usesMap.copy();
            usesMap.addToDefaultTypeUses("gw.lang.");
        } else {
            usesMap = new TypeUsesMap();
        }
        GosuAnnotationInfo.addEnclosingPackages(usesMap, (IType)ownersType);
        IType enclType = TypeLord.getPureGenericType(outerMostEnclosingType instanceof IGosuClass ? outerMostEnclosingType : ownersType);
        ParserOptions options = new ParserOptions().withTypeUsesMap(usesMap).withEnclosingType(enclType.getName()).withExpectedType(type).asThrowawayProgram().asAnonymous();
        StandardSymbolTable symTable = new StandardSymbolTable(true);
        TypeSystem.pushSymTableCtx((ISymbolTable)symTable);
        try {
            IParseResult res = GosuParserFactory.createProgramParser().parseExpressionOnly(strExprSource, (ISymbolTable)symTable, options);
            Object object = res.evaluate();
            return object;
        }
        catch (ParseResultsException e) {
            throw new RuntimeException(e);
        }
        finally {
            TypeSystem.popSymTableCtx();
        }
    }

    private static void addEnclosingPackages(ITypeUsesMap map, IType type) {
        type = TypeLord.getPureGenericType(type);
        type = TypeLord.getOuterMostEnclosingClass(type);
        map.addToDefaultTypeUses(GosuClassUtil.getPackage((String)type.getName()) + ".");
    }

    public IType getType() {
        if (TypeSystem.isDeleted((IType)this._type)) {
            return TypeSystem.getErrorType((String)this._type.getName());
        }
        return TypeLord.getPureGenericType(this._type);
    }

    public String toString() {
        return this.getName();
    }

    public String getNewExpressionAsString() {
        return this._newExpressionAsString;
    }

    public IGosuAnnotation getRawAnnotation() {
        return this._rawAnnotation;
    }

    public IType getRepeatableContainer() {
        IJavaType repeatable = JavaTypes.REPEATABLE();
        if (this.getType().getTypeInfo().hasAnnotation((IType)repeatable)) {
            IAnnotationInfo anno = this.getType().getTypeInfo().getAnnotation((IType)repeatable);
            Object type = anno.getFieldValue("value");
            if (type instanceof String) {
                type = TypeSystem.getByFullNameIfValid((String)((String)type));
            }
            return (IType)type;
        }
        return null;
    }
}

