/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.statements;

import gw.internal.gosu.parser.DynamicFunctionSymbol;
import gw.internal.gosu.parser.IGosuAnnotation;
import gw.internal.gosu.parser.Statement;
import gw.internal.gosu.parser.TypeLord;
import gw.internal.gosu.parser.expressions.BlockExpression;
import gw.lang.parser.IParseTree;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.expressions.IParameterDeclaration;
import gw.lang.parser.expressions.IParameterListClause;
import gw.lang.parser.statements.IFunctionStatement;
import gw.lang.parser.statements.ITerminalStatement;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.MethodList;
import gw.util.GosuObjectUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class FunctionStatement
extends Statement
implements IFunctionStatement {
    private DynamicFunctionSymbol _dfs;
    private int _iNameOffset = -1;

    public void setDynamicFunctionSymbol(DynamicFunctionSymbol dfs) {
        this._dfs = dfs;
    }

    public DynamicFunctionSymbol getDynamicFunctionSymbol() {
        return this._dfs;
    }

    @Override
    public Object execute() {
        return Statement.VOID_RETURN_VALUE;
    }

    @Override
    protected ITerminalStatement getLeastSignificantTerminalStatement_internal(boolean[] bAbsolute) {
        bAbsolute[0] = false;
        return null;
    }

    @Override
    public boolean isNoOp() {
        return true;
    }

    @Override
    public String toString() {
        return this._dfs == null ? "no dfs" : this._dfs.toString();
    }

    @Override
    public String getFunctionName() {
        DynamicFunctionSymbol dfs = this.getDynamicFunctionSymbol();
        return dfs == null ? null : dfs.getDisplayName();
    }

    public int getNameOffset(String identifierName) {
        return this._iNameOffset;
    }

    public void setNameOffset(int iOffset, String identifierName) {
        this._iNameOffset = iOffset;
    }

    public boolean declares(String identifierName) {
        if (this._dfs == null) {
            return false;
        }
        if (GosuObjectUtil.equals((Object)this._dfs.getName(), (Object)identifierName)) {
            return true;
        }
        if (this._dfs.getName().charAt(0) == '@') {
            int indexOfParen;
            boolean b = this._dfs.getName().toString().contains("(");
            assert (b);
            for (indexOfParen = this._dfs.getName().length() - 1; indexOfParen > 0 && this._dfs.getName().charAt(indexOfParen) != '('; --indexOfParen) {
            }
            return this._dfs.getName().subSequence(1, indexOfParen).equals(identifierName);
        }
        return false;
    }

    public String[] getDeclarations() {
        if (this._dfs == null) {
            return new String[0];
        }
        return new String[]{this._dfs.getDisplayName().replace("@", "")};
    }

    public IFeatureInfo findOwningFeatureInfoOfDeclaredSymbols(String identifierName) {
        if (this.declares(identifierName)) {
            return this._dfs.getDeclaringTypeInfo();
        }
        return null;
    }

    public static IMethodInfo getGenericMethodInfo(IMethodInfo mi) {
        IMethodInfo genericMethodInfo = null;
        IType type = mi.getOwnersType();
        for (IType superType = type.getSupertype(); superType != null && genericMethodInfo == null; superType = superType.getSupertype()) {
            if (!superType.isParameterizedType()) continue;
            type = TypeLord.getPureGenericType(superType);
            MethodList methodInfos = type.getTypeInfo().getMethods();
            for (IMethodInfo methodInfo : methodInfos) {
                if (!methodInfo.getDisplayName().equals(mi.getDisplayName()) || methodInfo.getParameters().length != mi.getParameters().length) continue;
                genericMethodInfo = methodInfo;
            }
        }
        if (genericMethodInfo == null) {
            genericMethodInfo = mi;
        }
        return genericMethodInfo;
    }

    public List<IParameterDeclaration> getParameters() {
        ArrayList<IParameterDeclaration> params = new ArrayList<IParameterDeclaration>();
        List<IParseTree> children = this.getLocation().getChildren();
        for (IParseTree parseTree : children) {
            IParsedElement pe = parseTree.getParsedElement();
            if (!(pe instanceof IParameterListClause)) continue;
            for (IParseTree parseTree2 : parseTree.getChildren()) {
                pe = parseTree2.getParsedElement();
                if (!(pe instanceof IParameterDeclaration)) continue;
                params.add((IParameterDeclaration)pe);
            }
        }
        return params;
    }

    @Override
    public List<IGosuAnnotation> getAnnotations() {
        return this.getDynamicFunctionSymbol() == null ? Collections.emptyList() : this.getDynamicFunctionSymbol().getAnnotations();
    }

    @Override
    protected List getExcludedReturnTypeElements() {
        return Arrays.asList(BlockExpression.class);
    }
}

