/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform;

import gw.internal.gosu.ir.nodes.GosuClassIRType;
import gw.internal.gosu.ir.transform.GosuClassTransformer;
import gw.internal.gosu.ir.transform.TransformationContextBase;
import gw.internal.gosu.ir.transform.util.RequiresReflectionDeterminer;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRStatement;
import gw.lang.ir.IRType;
import gw.lang.parser.IBlockClass;
import gw.lang.parser.Keyword;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.gs.ISourceFileHandle;
import java.util.ArrayList;
import java.util.List;

public class GosuClassTransformationContext
extends TransformationContextBase {
    private GosuClassTransformer _classTransformer;
    private IGosuClassInternal _gsClass;
    private List<String> _sourceLines;
    private static final boolean INCLUDE_SOURCE_COMMENTS = false;

    public GosuClassTransformationContext(GosuClassTransformer classTransformer, IGosuClassInternal gsClass) {
        super(gsClass);
        this._classTransformer = classTransformer;
        this._gsClass = gsClass;
        this.maybeIndexSourceCode();
    }

    @Override
    public void maybeAssignOuterRef(List<IRStatement> statements) {
        this._classTransformer.maybeAssignOuterRef(statements);
    }

    @Override
    public void maybePushSupersEnclosingThisRef(List<IRExpression> arguments) {
        this._classTransformer.maybePushSupersEnclosingThisRef(arguments);
    }

    @Override
    public void pushEnumNameAndOrdinal(IType type, List<IRExpression> args) {
        this._classTransformer.pushEnumNameAndOrdinal(type, args);
    }

    @Override
    public void initCapturedSymbolFields(List<IRStatement> statements) {
        this._classTransformer.initCapturedSymbolFields(statements);
    }

    @Override
    public void initTypeVarFields(List<IRStatement> statements) {
        this._classTransformer.initTypeVarFields(statements);
    }

    @Override
    public void initializeInstanceFields(List<IRStatement> statements) {
        this._classTransformer.initializeInstanceFields(statements);
    }

    @Override
    public void addAssertionsStaticField() {
        this._classTransformer.setHasAsserts();
    }

    @Override
    public String getOuterThisParamName() {
        return this.getOuterThisFieldName() + "$$arg";
    }

    @Override
    public String getSourceFileRef() {
        IGosuClassInternal outermostClass = this._gsClass;
        while (outermostClass.getEnclosingType() != null && outermostClass.getEnclosingType() instanceof IGosuClassInternal) {
            outermostClass = (IGosuClassInternal)outermostClass.getEnclosingType();
        }
        ISourceFileHandle sfh = outermostClass.getSourceFileHandle();
        return sfh == null ? null : sfh.getFileName();
    }

    @Override
    public String getSourceLine(int lineNumber) {
        if (this._sourceLines != null) {
            return this._sourceLines.get(lineNumber - 1);
        }
        return null;
    }

    @Override
    public String getOuterThisFieldName() {
        return Keyword.KW_this + "$" + (this._gsClass.getDepth() - 1);
    }

    @Override
    public IRType getIRTypeForCurrentClass() {
        return GosuClassIRType.get((IType)this._gsClass);
    }

    @Override
    public boolean isExternalSymbol(String name) {
        return this._gsClass.getExternalSymbol(name) != null;
    }

    @Override
    public boolean isFragmentEvaluation() {
        return false;
    }

    private void maybeIndexSourceCode() {
    }

    private List<String> split(String source) {
        ArrayList<String> results = new ArrayList<String>();
        int start = 0;
        int lineIndex = source.indexOf(10);
        while (lineIndex != -1) {
            results.add(source.substring(start, lineIndex));
            start = lineIndex + 1;
            lineIndex = source.indexOf(10, start);
        }
        results.add(source.substring(start));
        return results;
    }

    @Override
    public boolean shouldUseReflection(IType declaringClass, IRType root, IRelativeTypeInfo.Accessibility accessibility) {
        return RequiresReflectionDeterminer.shouldUseReflection(declaringClass, this._gsClass, root, accessibility);
    }

    @Override
    public boolean isIllegalProtectedCall(IType declaringClass, IRType root, IRelativeTypeInfo.Accessibility accessibility) {
        return RequiresReflectionDeterminer.isCallingClassEnclosedInDifferentPackageFromDeclaringSuperclass(this._gsClass, declaringClass, root, accessibility);
    }

    @Override
    public boolean currentlyCompilingBlock() {
        return this.getGosuClass() instanceof IBlockClass;
    }
}

