/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.expression;

import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.expression.AbstractExpressionTransformer;
import gw.internal.gosu.parser.expressions.NumericLiteral;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRTypeConstants;
import gw.lang.reflect.IType;
import gw.lang.reflect.java.JavaTypes;
import java.util.Arrays;
import java.util.Collections;

public class NumericLiteralTransformer
extends AbstractExpressionTransformer<NumericLiteral> {
    public static IRExpression compile(TopLevelTransformationContext cc, NumericLiteral expr) {
        NumericLiteralTransformer gen = new NumericLiteralTransformer(cc, expr);
        return gen.compile();
    }

    private NumericLiteralTransformer(TopLevelTransformationContext cc, NumericLiteral expr) {
        super(cc, expr);
    }

    @Override
    protected IRExpression compile_impl() {
        IType type = ((NumericLiteral)this._expr()).getType();
        if (type == JavaTypes.BIG_DECIMAL() || type == JavaTypes.BIG_INTEGER()) {
            return this.buildNewExpression(NumericLiteralTransformer.getDescriptor(type), Arrays.asList(IRTypeConstants.STRING()), Collections.singletonList(this.stringLiteral(((NumericLiteral)this._expr()).getValue().toString())));
        }
        Number value = this.getValueOfProperType(type);
        IRExpression expression = this.pushConstant(value);
        if (!type.isPrimitive()) {
            expression = this.boxValueToType(type, expression);
        }
        return expression;
    }

    private Number getValueOfProperType(IType type) {
        Number value = ((NumericLiteral)this._expr()).getValue();
        if (type == JavaTypes.pDOUBLE() || type == JavaTypes.DOUBLE()) {
            value = new Double(value.doubleValue());
        }
        if (type == JavaTypes.pLONG() || type == JavaTypes.LONG()) {
            value = new Long(value.longValue());
        }
        return value;
    }
}

