/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.statements;

import gw.internal.gosu.parser.CannotExecuteGosuException;
import gw.internal.gosu.parser.Statement;
import gw.internal.gosu.parser.statements.CatchClause;
import gw.lang.parser.statements.ITerminalStatement;
import gw.lang.parser.statements.ITryCatchFinallyStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class TryCatchFinallyStatement
extends Statement
implements ITryCatchFinallyStatement {
    private Statement _tryStatement;
    private List<CatchClause> _catchStatements;
    private Statement _finallyStatement;
    private Map<String, Integer> _offsetByName = new HashMap<String, Integer>();

    public Statement getTryStatement() {
        return this._tryStatement;
    }

    public void setTryStatement(Statement tryStatement) {
        this._tryStatement = tryStatement;
    }

    public List<CatchClause> getCatchStatements() {
        return this._catchStatements;
    }

    public void addCatchClause(CatchClause catchClause) {
        if (this._catchStatements == null) {
            this._catchStatements = new ArrayList<CatchClause>();
        }
        this._catchStatements.add(catchClause);
    }

    public Statement getFinallyStatement() {
        return this._finallyStatement;
    }

    public void setFinallyStatement(Statement finallyStatement) {
        this._finallyStatement = finallyStatement;
    }

    @Override
    public Object execute() {
        if (!this.isCompileTimeConstant()) {
            return super.execute();
        }
        throw new CannotExecuteGosuException();
    }

    @Override
    protected ITerminalStatement getLeastSignificantTerminalStatement_internal(boolean[] bAbsolute) {
        boolean[] bTry = new boolean[]{false};
        ITerminalStatement termRet = this._tryStatement == null ? null : this._tryStatement.getLeastSignificantTerminalStatement(bTry);
        bAbsolute[0] = bTry[0];
        if (this._catchStatements != null) {
            for (CatchClause catchClause : this._catchStatements) {
                boolean[] bCatch = new boolean[]{false};
                ITerminalStatement catchTerm = catchClause.getLeastSignificantTerminalStatement(bCatch);
                termRet = TryCatchFinallyStatement.getLeastSignificant(termRet, catchTerm);
                bAbsolute[0] = bAbsolute[0] && bCatch[0];
            }
        }
        bAbsolute[0] = termRet != null && bAbsolute[0];
        return termRet;
    }

    @Override
    public String toString() {
        return "try\n" + this._tryStatement.toString() + (this._catchStatements == null ? "" : this.printCatches()) + (this._finallyStatement == null ? "" : "finally\n" + this._finallyStatement.toString());
    }

    private String printCatches() {
        StringBuilder sb = new StringBuilder();
        for (CatchClause c : this.getCatchStatements()) {
            sb.append(c.toString());
        }
        return sb.toString();
    }
}

