/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.compiler.bytecode;

import gw.internal.ext.org.objectweb.asm.AnnotationVisitor;
import gw.internal.ext.org.objectweb.asm.Attribute;
import gw.internal.ext.org.objectweb.asm.ClassReader;
import gw.internal.ext.org.objectweb.asm.ClassVisitor;
import gw.internal.ext.org.objectweb.asm.FieldVisitor;
import gw.internal.ext.org.objectweb.asm.Label;
import gw.internal.ext.org.objectweb.asm.MethodVisitor;
import gw.internal.ext.org.objectweb.asm.Type;
import gw.internal.ext.org.objectweb.asm.util.CheckClassAdapter;
import gw.internal.ext.org.objectweb.asm.util.TraceClassVisitor;
import gw.internal.gosu.compiler.DebugFlag;
import gw.internal.gosu.ir.compiler.bytecode.AbstractBytecodeCompiler;
import gw.internal.gosu.ir.compiler.bytecode.GosuClassWriter;
import gw.internal.gosu.ir.compiler.bytecode.IRAnnotationCompiler;
import gw.internal.gosu.ir.compiler.bytecode.IRBytecodeCompiler;
import gw.internal.gosu.ir.compiler.bytecode.IRBytecodeContext;
import gw.internal.gosu.ir.nodes.IRTypeFactory;
import gw.internal.gosu.ir.nodes.JavaClassIRType;
import gw.internal.gosu.ir.transform.util.IRTypeResolver;
import gw.lang.Gosu;
import gw.lang.ir.IRAnnotation;
import gw.lang.ir.IRClass;
import gw.lang.ir.IRElement;
import gw.lang.ir.IRSymbol;
import gw.lang.ir.IRType;
import gw.lang.ir.Internal;
import gw.lang.ir.statement.IRFieldDecl;
import gw.lang.ir.statement.IRMethodStatement;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.Modifier;
import gw.lang.reflect.gs.BytecodeOptions;
import gw.util.Array;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.List;

public class IRClassCompiler
extends AbstractBytecodeCompiler {
    private static boolean COMPILE_WITH_DEBUG_INFO = true;
    public static final int JAVA_VER = 52;
    private ClassVisitor _cv;
    private IRClass _irClass;
    private static byte[] _gosuVersion = Gosu.getVersion().toString().getBytes(Charset.forName("US-ASCII"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compileClass(IRClass irClass, boolean debug) {
        boolean alreadyDebugging = DebugFlag.isDebugFlagsOn();
        if (!alreadyDebugging && debug) {
            DebugFlag.setDebugFlagsOn();
        }
        try {
            byte[] byArray = new IRClassCompiler(irClass).compile();
            return byArray;
        }
        finally {
            if (!alreadyDebugging) {
                DebugFlag.setDebugFlagsOff();
            }
        }
    }

    public IRClassCompiler(IRClass irClass) {
        this._irClass = irClass;
    }

    private byte[] compile() {
        GosuClassWriter writer = new GosuClassWriter();
        StringWriter trace = this.configClassVisitor(writer);
        try {
            this.compileClassHeader();
            this.addSourceFileRef();
            this.compileInnerClasses();
            this.compileFields();
            this.compileMethods();
            this.addAnnotations();
            this.addGosuVersion();
            this._cv.visitEnd();
        }
        finally {
            if (BytecodeOptions.shouldDebug((String)this._irClass.getName())) {
                System.out.println("========================================================================");
                System.out.println(this._irClass.getName());
                System.out.println("========================================================================");
                System.out.println(trace);
            }
        }
        byte[] bytes = writer.toByteArray();
        return bytes;
    }

    private void addGosuVersion() {
        try {
            Class<Attribute> aClass = Attribute.class;
            Constructor<?>[] constr = aClass.getDeclaredConstructors();
            constr[0].setAccessible(true);
            Object instance = constr[0].newInstance("GosuVersion");
            Field[] fields = aClass.getDeclaredFields();
            fields[1].setAccessible(true);
            fields[1].set(instance, _gosuVersion);
            this._cv.visitAttribute((Attribute)instance);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addAnnotations() {
        for (IRAnnotation annotation : this._irClass.getAnnotations()) {
            AnnotationVisitor annotationVisitor = this._cv.visitAnnotation(annotation.getDescriptor().getDescriptor(), annotation.isInclude());
            new IRAnnotationCompiler(annotationVisitor, annotation).compile();
        }
    }

    private StringWriter configClassVisitor(ClassVisitor writer) {
        this._cv = writer;
        StringWriter trace = null;
        if (IRClassCompiler.isDebugFlagSet(DebugFlag.TRACE) || BytecodeOptions.shouldDebug((String)this._irClass.getName())) {
            trace = new StringWriter();
            this._cv = new TraceClassVisitor(this._cv, new PrintWriter(trace));
            if (IRClassCompiler.isDebugFlagSet(DebugFlag.ASM_CHECKER)) {
                this._cv = new CheckClassAdapter(this._cv);
            }
        }
        return trace;
    }

    public static void verify(byte[] bytes) {
        if (IRClassCompiler.isDebugFlagSet(DebugFlag.VERIFY)) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            CheckClassAdapter.verify((ClassReader)new ClassReader(bytes), (boolean)false, (PrintWriter)pw);
            String out = sw.toString();
            if (out.length() > 0) {
                System.out.println(out);
            }
        }
    }

    public static boolean isDebugFlagSet(DebugFlag flag) {
        return DebugFlag.getDebugFlags().contains((Object)flag);
    }

    private void compileClassHeader() {
        int modifiers = this._irClass.getModifiers();
        this._cv.visit(52, modifiers, this._irClass.getThisType().getSlashName(), this.getClassSignature(), this._irClass.getSuperType().getSlashName(), this.getInterfaceNames());
    }

    private String getClassSignature() {
        return this._irClass.getGenericSignature();
    }

    private String[] getInterfaceNames() {
        List interfaces = this._irClass.getInterfaces();
        if (interfaces == null || interfaces.isEmpty()) {
            return null;
        }
        String[] ifaceNames = new String[interfaces.size()];
        for (int i = 0; i < ifaceNames.length; ++i) {
            IRType iface = (IRType)interfaces.get(i);
            ifaceNames[i] = iface.getSlashName();
        }
        return ifaceNames;
    }

    private void addSourceFileRef() {
        this._cv.visitSource(this._irClass.getSourceFile(), null);
    }

    private void compileInnerClasses() {
        for (IRClass.InnerClassInfo innerClass : this._irClass.getInnerClasses()) {
            this.visitInnerClass(innerClass);
        }
    }

    private void visitInnerClass(IRClass.InnerClassInfo innerClass) {
        this._cv.visitInnerClass(innerClass.getInnerClass().getSlashName(), innerClass.getEnclosingType().getSlashName(), innerClass.getInnerClass().getRelativeName(), innerClass.getModifiers());
    }

    private void compileFields() {
        for (IRFieldDecl field : this._irClass.getFields()) {
            FieldVisitor fv = this._cv.visitField(field.getModifiers(), field.getName(), field.getType().getDescriptor(), field.getGenericSignature(), field.getValue());
            for (IRAnnotation annotation : field.getAnnotations()) {
                AnnotationVisitor annotationVisitor = fv.visitAnnotation(annotation.getDescriptor().getDescriptor(), annotation.isInclude());
                new IRAnnotationCompiler(annotationVisitor, annotation).compile();
            }
            if (field.isExplicitInternal()) {
                AnnotationVisitor annotationVisitor = fv.visitAnnotation(Type.getDescriptor(Internal.class), true);
                new IRAnnotationCompiler(annotationVisitor, new IRAnnotation(IRTypeResolver.getDescriptor(Internal.class), true)).compile();
            }
            fv.visitEnd();
        }
    }

    private void compileMethods() {
        for (IRMethodStatement method : this._irClass.getMethods()) {
            this.compileMethod(method);
        }
    }

    private void compileMethod(IRMethodStatement method) {
        Object annotationVisitor;
        MethodVisitor mv = this._cv.visitMethod(method.getModifiers(), method.getName(), IRClassCompiler.getMethodDescriptor(method), method.getGenericSignature(), null);
        Object[] annotationDefault = method.getAnnotationDefault();
        if (annotationDefault != null) {
            annotationVisitor = mv.visitAnnotationDefault();
            this.visitAnnotationDefaultValue(annotationDefault[0], method.getReturnType(), (AnnotationVisitor)annotationVisitor);
            mv.visitEnd();
        }
        for (IRAnnotation annotation : method.getAnnotations()) {
            AnnotationVisitor annotationVisitor2 = mv.visitAnnotation(annotation.getDescriptor().getDescriptor(), annotation.isInclude());
            new IRAnnotationCompiler(annotationVisitor2, annotation).compile();
        }
        if (method.isExplicitInternal()) {
            annotationVisitor = mv.visitAnnotation(Type.getDescriptor(Internal.class), true);
            new IRAnnotationCompiler((AnnotationVisitor)annotationVisitor, new IRAnnotation(IRTypeResolver.getDescriptor(Internal.class), true)).compile();
        }
        List parameters = method.getParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            IRSymbol param = (IRSymbol)parameters.get(i);
            List paramAnnotations = param.getAnnotations();
            if (paramAnnotations == null) continue;
            for (IRAnnotation annotation : paramAnnotations) {
                AnnotationVisitor annotationVisitor3 = mv.visitParameterAnnotation(i, annotation.getDescriptor().getDescriptor(), annotation.isInclude());
                new IRAnnotationCompiler(annotationVisitor3, annotation).compile();
            }
        }
        if (method.getMethodBody() != null) {
            mv.visitCode();
            IRBytecodeContext context = new IRBytecodeContext(mv);
            if (!Modifier.isStatic((int)method.getModifiers())) {
                context.indexThis(this._irClass.getThisType());
            }
            context.indexSymbols(method.getParameters());
            IRBytecodeCompiler.compileIRElement((IRElement)method.getMethodBody(), context);
            this.terminateFunction(context);
        }
        mv.visitEnd();
    }

    private void visitAnnotationDefaultValue(Object value, IRType type, AnnotationVisitor annotationVisitor) {
        this.visitAnnotationDefaultValue(value, type, annotationVisitor, null);
    }

    private void visitAnnotationDefaultValue(Object value, IRType type, AnnotationVisitor annotationVisitor, String name) {
        if (value == null) {
            boolean b;
            boolean bl = b = !type.isPrimitive();
            assert (b);
            annotationVisitor.visit(name, value);
        } else if (JavaClassIRType.get(Enum.class).isAssignableFrom(type)) {
            annotationVisitor.visitEnum(name, type.getDescriptor(), (String)value);
        } else {
            Class<?> cls = value.getClass();
            if (cls == Boolean.class || cls == Byte.class || cls == Character.class || cls == Short.class || cls == Integer.class || cls == Long.class || cls == Float.class || cls == Double.class || cls == String.class) {
                boolean b;
                boolean bl = b = type.isPrimitive() || type == JavaClassIRType.get(String.class);
                assert (b);
                annotationVisitor.visit(name, value);
            } else if (cls.isArray()) {
                boolean b = type.isArray();
                assert (b);
                AnnotationVisitor nestedVisitor = annotationVisitor.visitArray(name);
                int length = Array.getLength((Object)value);
                for (int i = 0; i < length; ++i) {
                    this.visitAnnotationDefaultValue(Array.get((Object)value, (int)i), type.getComponentType(), nestedVisitor);
                    nestedVisitor.visitEnd();
                }
            } else if (JavaClassIRType.get(Class.class).isAssignableFrom(type)) {
                annotationVisitor.visit(name, (Object)Type.getType((String)IRTypeFactory.get((IType)value).getDescriptor()));
            } else if (JavaClassIRType.get(Annotation.class).isAssignableFrom(type)) {
                IAnnotationInfo ai = (IAnnotationInfo)value;
                AnnotationVisitor nestedVisitor = annotationVisitor.visitAnnotation(name, IRTypeFactory.get(ai.getType()).getDescriptor());
                for (IMethodInfo mi : ((IRelativeTypeInfo)ai.getType().getTypeInfo()).getDeclaredMethods()) {
                    if (mi.isStatic()) continue;
                    Object argValue = ai.getFieldValue(mi.getDisplayName());
                    this.visitAnnotationDefaultValue(argValue, IRTypeFactory.get(mi.getReturnType()), nestedVisitor, mi.getName());
                }
                nestedVisitor.visitEnd();
            } else {
                throw new IllegalStateException();
            }
        }
    }

    private void terminateFunction(IRBytecodeContext context) {
        context.popScope();
        MethodVisitor mv = context.getMv();
        Label endLabel = new Label();
        context.visitLabel(endLabel);
        if (COMPILE_WITH_DEBUG_INFO) {
            context.visitLocalVars();
        }
        mv.visitMaxs(0, 0);
    }

    public static String getMethodDescriptor(IRMethodStatement m) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (IRSymbol param : m.getParameters()) {
            sb.append(param.getType().getDescriptor());
        }
        sb.append(")");
        sb.append(m.getReturnType().getDescriptor());
        return sb.toString();
    }

    public String toString() {
        return "Compiling: " + this._irClass.getName();
    }
}

