/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.compiler.bytecode.expression;

import gw.internal.ext.org.objectweb.asm.Label;
import gw.internal.ext.org.objectweb.asm.MethodVisitor;
import gw.internal.gosu.ir.compiler.bytecode.AbstractBytecodeCompiler;
import gw.internal.gosu.ir.compiler.bytecode.IRBytecodeCompiler;
import gw.internal.gosu.ir.compiler.bytecode.IRBytecodeContext;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRType;
import gw.lang.ir.expression.IREqualityExpression;
import gw.lang.ir.expression.IRNullLiteral;

public class IREqualityExpressionCompiler
extends AbstractBytecodeCompiler {
    public static void compile(IREqualityExpression expression, IRBytecodeContext context) {
        if (expression.getLhs() instanceof IRNullLiteral || expression.getRhs() instanceof IRNullLiteral) {
            IREqualityExpressionCompiler.compareToNull(expression.isEquals(), expression.getLhs() instanceof IRNullLiteral ? expression.getRhs() : expression.getLhs(), context);
        } else if (expression.getLhs().getType().isPrimitive()) {
            if (!expression.getLhs().getType().equals(expression.getRhs().getType())) {
                throw new IllegalArgumentException("Equality expression comparing two different primitive types :" + expression.getLhs().getType().getName() + " and " + expression.getRhs().getType().getName());
            }
            IRType lhsType = expression.getLhs().getType();
            if (lhsType.isBoolean() || lhsType.isByte() || lhsType.isChar() || lhsType.isShort() || lhsType.isInt()) {
                IREqualityExpressionCompiler.compareInts(expression.isEquals(), expression.getLhs(), expression.getRhs(), context);
            } else if (lhsType.isLong()) {
                IREqualityExpressionCompiler.compareLongs(expression.isEquals(), expression.getLhs(), expression.getRhs(), context);
            } else if (lhsType.isDouble()) {
                IREqualityExpressionCompiler.compareDoubles(expression.isEquals(), expression.getLhs(), expression.getRhs(), context);
            } else if (lhsType.isFloat()) {
                IREqualityExpressionCompiler.compareFloats(expression.isEquals(), expression.getLhs(), expression.getRhs(), context);
            } else {
                System.out.println("Unexpected primitive type " + lhsType.getName());
            }
        } else {
            IREqualityExpressionCompiler.compareObjects(expression.isEquals(), expression.getLhs(), expression.getRhs(), context);
        }
    }

    private static void compareToNull(boolean equals, IRExpression expr, IRBytecodeContext context) {
        MethodVisitor mv = context.getMv();
        IRBytecodeCompiler.compileIRExpression(expr, context);
        IREqualityExpressionCompiler.compare(mv, equals ? 198 : 199);
    }

    private static void compareInts(boolean equals, IRExpression lhs, IRExpression rhs, IRBytecodeContext context) {
        MethodVisitor mv = context.getMv();
        IRBytecodeCompiler.compileIRExpression(lhs, context);
        IRBytecodeCompiler.compileIRExpression(rhs, context);
        IREqualityExpressionCompiler.compare(mv, equals ? 159 : 160);
    }

    private static void compareLongs(boolean equals, IRExpression lhs, IRExpression rhs, IRBytecodeContext context) {
        IREqualityExpressionCompiler.compareNonIntPrimitives(equals, lhs, rhs, context, 148);
    }

    private static void compareDoubles(boolean equals, IRExpression lhs, IRExpression rhs, IRBytecodeContext context) {
        IREqualityExpressionCompiler.compareNonIntPrimitives(equals, lhs, rhs, context, 151);
    }

    private static void compareFloats(boolean equals, IRExpression lhs, IRExpression rhs, IRBytecodeContext context) {
        IREqualityExpressionCompiler.compareNonIntPrimitives(equals, lhs, rhs, context, 149);
    }

    private static void compareNonIntPrimitives(boolean equals, IRExpression lhs, IRExpression rhs, IRBytecodeContext context, int compareOp) {
        MethodVisitor mv = context.getMv();
        IRBytecodeCompiler.compileIRExpression(lhs, context);
        IRBytecodeCompiler.compileIRExpression(rhs, context);
        mv.visitInsn(compareOp);
        IREqualityExpressionCompiler.compare(mv, equals ? 153 : 154);
    }

    private static void compareObjects(boolean equals, IRExpression lhs, IRExpression rhs, IRBytecodeContext context) {
        MethodVisitor mv = context.getMv();
        IRBytecodeCompiler.compileIRExpression(lhs, context);
        IRBytecodeCompiler.compileIRExpression(rhs, context);
        IREqualityExpressionCompiler.compare(mv, equals ? 165 : 166);
    }

    private static void compare(MethodVisitor mv, int opcode) {
        Label labelTrue = new Label();
        mv.visitJumpInsn(opcode, labelTrue);
        mv.visitInsn(3);
        Label labelFalse = new Label();
        mv.visitJumpInsn(167, labelFalse);
        mv.visitLabel(labelTrue);
        mv.visitInsn(4);
        mv.visitLabel(labelFalse);
    }
}

