/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.ParsedElement;
import gw.internal.gosu.parser.TypeLord;
import gw.internal.gosu.parser.expressions.BlockExpression;
import gw.internal.gosu.parser.statements.ReturnStatement;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.IStatement;
import gw.lang.parser.statements.IFunctionStatement;
import gw.lang.parser.statements.INoOpStatement;
import gw.lang.parser.statements.IStatementList;
import gw.lang.parser.statements.ITerminalStatement;
import gw.lang.reflect.IType;
import gw.lang.reflect.gs.IExternalSymbolMap;
import gw.lang.reflect.gs.IProgramInstance;
import gw.util.GosuExceptionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public abstract class Statement
extends ParsedElement
implements IStatement {
    private static final LeastSigTerminal EMPTY_LST = new LeastSigTerminal(null, false);
    public static final Object VOID_RETURN_VALUE = new Object(){};
    private LeastSigTerminal _cachedLeastSigTerm;

    public Object execute() {
        Class cls = this.getGosuProgram().getBackingClass();
        try {
            return ((IProgramInstance)cls.newInstance()).evaluate(null);
        }
        catch (Exception e) {
            throw GosuExceptionUtil.forceThrow((Throwable)e);
        }
    }

    public Object execute(IExternalSymbolMap externalSymbols) {
        Class cls = this.getGosuProgram().getBackingClass();
        try {
            return ((IProgramInstance)cls.newInstance()).evaluate(externalSymbols);
        }
        catch (Exception e) {
            throw GosuExceptionUtil.forceThrow((Throwable)e);
        }
    }

    public abstract String toString();

    public boolean isNoOp() {
        return false;
    }

    public IType getReturnType() {
        ArrayList<IParsedElement> returnStatements = new ArrayList<IParsedElement>();
        ArrayList<IType> returnTypes = new ArrayList<IType>();
        this.getContainedParsedElementsByTypesWithIgnoreSet(returnStatements, new HashSet<Class<? extends IParsedElement>>(this.getExcludedReturnTypeElements()), ReturnStatement.class);
        for (int i = 0; i < returnStatements.size(); ++i) {
            ReturnStatement returnStmt = (ReturnStatement)returnStatements.get(i);
            returnTypes.add(returnStmt.getValue().getType());
        }
        return TypeLord.findLeastUpperBound(returnTypes);
    }

    protected List getExcludedReturnTypeElements() {
        return Arrays.asList(IFunctionStatement.class, BlockExpression.class);
    }

    public boolean hasContent() {
        if (this instanceof IStatementList) {
            IStatement[] statements = ((IStatementList)this).getStatements();
            if (statements != null) {
                for (int i = 0; i < statements.length; ++i) {
                    IStatement statement = statements[i];
                    if (statement instanceof INoOpStatement) continue;
                    return true;
                }
            }
            return false;
        }
        return !(this instanceof INoOpStatement);
    }

    @Override
    public void setParent(IParsedElement rootElement) {
        super.setParent(rootElement);
        this._cachedLeastSigTerm = null;
    }

    public final ITerminalStatement getLeastSignificantTerminalStatement(boolean[] bAbsolute) {
        if (this._cachedLeastSigTerm == null) {
            ITerminalStatement stmt = this.getLeastSignificantTerminalStatement_internal(bAbsolute);
            this._cachedLeastSigTerm = stmt == null ? EMPTY_LST : new LeastSigTerminal(stmt, bAbsolute[0]);
        }
        bAbsolute[0] = this._cachedLeastSigTerm._bAbsolute;
        return this._cachedLeastSigTerm._stmt;
    }

    protected abstract ITerminalStatement getLeastSignificantTerminalStatement_internal(boolean[] var1);

    public static ITerminalStatement getLeastSignificant(ITerminalStatement ... termStmts) {
        ITerminalStatement ret = null;
        for (ITerminalStatement stmt : termStmts) {
            if (stmt == null) continue;
            ret = ret == null ? stmt : (ret.getTerminalType().ordinal() < stmt.getTerminalType().ordinal() ? ret : stmt);
        }
        return ret;
    }

    private static class LeastSigTerminal {
        private ITerminalStatement _stmt;
        private boolean _bAbsolute;

        public LeastSigTerminal(ITerminalStatement stmt, boolean bAbsolute) {
            this._stmt = stmt;
            this._bAbsolute = bAbsolute;
        }
    }
}

