/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.expressions;

import gw.internal.gosu.parser.ErrorType;
import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.TypeLord;
import gw.internal.gosu.parser.expressions.BlockType;
import gw.internal.gosu.parser.expressions.TypeLiteral;
import gw.internal.gosu.parser.types.ConstructorType;
import gw.lang.parser.IExpression;
import gw.lang.parser.Keyword;
import gw.lang.parser.expressions.IFeatureLiteralExpression;
import gw.lang.reflect.FunctionType;
import gw.lang.reflect.IBlockType;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IGenericMethodInfo;
import gw.lang.reflect.IHasParameterInfos;
import gw.lang.reflect.IInvocableType;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.MethodList;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.features.BoundMethodReference;
import gw.lang.reflect.features.BoundPropertyChainReference;
import gw.lang.reflect.features.BoundPropertyReference;
import gw.lang.reflect.features.ConstructorReference;
import gw.lang.reflect.features.MethodReference;
import gw.lang.reflect.features.PropertyChainReference;
import gw.lang.reflect.features.PropertyReference;
import gw.lang.reflect.gs.IGenericTypeVariable;
import gw.util.GosuObjectUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class FeatureLiteral
extends Expression
implements IFeatureLiteralExpression {
    private static final int MAX_BLOCK_ARGS = 16;
    private IExpression _root;
    IFeatureInfo _feature;
    private IType[] _parameterTypes;
    private List<IExpression> _boundArgs;
    private IBlockType _blockType;

    public FeatureLiteral(Expression rootExpr) {
        this._root = rootExpr;
    }

    public boolean resolveProperty(String propName) {
        IType typeToResolveAgainst = this.getRootTypeToResolveFeaturesAgainst();
        IPropertyInfo property = typeToResolveAgainst.getTypeInfo() instanceof IRelativeTypeInfo ? ((IRelativeTypeInfo)typeToResolveAgainst.getTypeInfo()).getProperty(typeToResolveAgainst, (CharSequence)propName) : typeToResolveAgainst.getTypeInfo().getProperty((CharSequence)propName);
        boolean foundProp = property != null;
        this._feature = foundProp ? property : ErrorType.getInstance().getTypeInfo().getProperty((CharSequence)propName);
        this.resolveExpressionType();
        return foundProp;
    }

    public boolean resolveMethod(String methodName, List<IType> typesList) {
        IType[] argTypes = typesList.toArray(new IType[typesList.size()]);
        IType typeToResolveAgainst = this.getRootTypeToResolveFeaturesAgainst();
        ITypeInfo typeInfo = typeToResolveAgainst.getTypeInfo();
        IMethodInfo methodInfo = typeInfo instanceof IRelativeTypeInfo ? ITypeInfo.FIND.callableMethod((MethodList)((IRelativeTypeInfo)typeInfo).getMethods(typeToResolveAgainst), (CharSequence)methodName, (IType[])argTypes) : ITypeInfo.FIND.callableMethod((MethodList)typeInfo.getMethods(), (CharSequence)methodName, (IType[])argTypes);
        if ((methodInfo = this.ensureExactMatch(methodInfo, argTypes)) == null && argTypes.length == 0) {
            methodInfo = this.getSingleMethodWithName(methodName, typeToResolveAgainst, typeInfo);
        }
        boolean foundMethod = methodInfo != null;
        methodInfo = foundMethod ? methodInfo : ErrorType.getInstance().getTypeInfo().getMethod((CharSequence)methodName, argTypes);
        this.setFeature((IHasParameterInfos)methodInfo, null);
        return foundMethod;
    }

    public boolean resolveConstructor(List<IType> typesList) {
        IType[] argTypes = typesList.toArray(new IType[typesList.size()]);
        IType typeToResolveAgainst = this.getRootTypeToResolveFeaturesAgainst();
        ITypeInfo typeInfo = typeToResolveAgainst.getTypeInfo();
        IConstructorInfo constructorInfo = typeInfo instanceof IRelativeTypeInfo ? ((IRelativeTypeInfo)typeInfo).getConstructor(typeToResolveAgainst, argTypes) : typeInfo.getConstructor(argTypes);
        if ((constructorInfo = this.ensureExactMatch(constructorInfo, argTypes)) == null && argTypes.length == 0) {
            constructorInfo = this.getSingleConsructor(typeToResolveAgainst, typeInfo);
        }
        boolean foundConstructor = constructorInfo != null;
        constructorInfo = foundConstructor ? constructorInfo : ErrorType.getInstance().getTypeInfo().getConstructor(argTypes);
        this.setFeature((IHasParameterInfos)constructorInfo, null);
        return foundConstructor;
    }

    public void setFeature(IHasParameterInfos feature, List<IExpression> arguments) {
        this._feature = feature;
        this._boundArgs = arguments;
        this.resolveExpressionType();
    }

    @Override
    public String toString() {
        return this._root.toString() + this.featureRepresentation();
    }

    public boolean isConstructorLiteral() {
        return this._feature instanceof IConstructorInfo;
    }

    public boolean isMethodLiteral() {
        return this._feature instanceof IMethodInfo;
    }

    public boolean isPropertyLiteral() {
        return this._feature instanceof IPropertyInfo;
    }

    public IExpression getRoot() {
        return this._root;
    }

    public IExpression getFinalRoot() {
        IExpression root = this.getRoot();
        if (root instanceof IFeatureLiteralExpression) {
            return ((IFeatureLiteralExpression)root).getFinalRoot();
        }
        return root;
    }

    public IType getFinalRootType() {
        if (this._root instanceof TypeLiteral) {
            return ((TypeLiteral)this._root).getType().getType();
        }
        if (this._root instanceof FeatureLiteral) {
            return ((FeatureLiteral)this._root).getFinalRootType();
        }
        return this._root.getType();
    }

    public IType getRootType() {
        if (this._root instanceof TypeLiteral) {
            return ((TypeLiteral)this._root).getType().getType();
        }
        if (this._root instanceof FeatureLiteral) {
            return ((FeatureLiteral)this._root).getFeatureReturnType();
        }
        return this._root.getType();
    }

    public String getPropertyName() {
        return this._feature.getName();
    }

    public String getMethodName() {
        return this._feature.getDisplayName();
    }

    public List<IExpression> getBoundArgs() {
        return this._boundArgs;
    }

    public boolean isBound() {
        if (this._root instanceof FeatureLiteral) {
            return ((FeatureLiteral)this._root).isBound();
        }
        return !(this._root instanceof TypeLiteral);
    }

    public IType[] getParameterTypes() {
        return this._parameterTypes;
    }

    public boolean isStaticish() {
        if (this._feature instanceof IMethodInfo) {
            return ((IMethodInfo)this._feature).isStatic();
        }
        if (this._feature instanceof IPropertyInfo) {
            return ((IPropertyInfo)this._feature).isStatic();
        }
        return this._feature instanceof IConstructorInfo;
    }

    public IFeatureInfo getFeature() {
        return this._feature;
    }

    public List<? extends IInvocableType> getFunctionTypes(String name) {
        if (name.equals(Keyword.KW_construct.toString())) {
            return this.getConstructorTypes();
        }
        return this.getMethodTypes(name);
    }

    private IMethodInfo getSingleMethodWithName(String methodName, IType typeToResolveAgainst, ITypeInfo typeInfo) {
        MethodList methods = typeInfo instanceof IRelativeTypeInfo ? ((IRelativeTypeInfo)typeInfo).getMethods(typeToResolveAgainst) : typeInfo.getMethods();
        IMethodInfo match = null;
        for (IMethodInfo possibleMatch : methods) {
            if (!possibleMatch.getDisplayName().equals(methodName)) continue;
            if (match != null) {
                return null;
            }
            match = possibleMatch;
        }
        return match;
    }

    private IConstructorInfo getSingleConsructor(IType typeToResolveAgainst, ITypeInfo typeInfo) {
        List constructors = typeInfo instanceof IRelativeTypeInfo ? ((IRelativeTypeInfo)typeInfo).getConstructors(typeToResolveAgainst) : typeInfo.getConstructors();
        return constructors.size() == 1 ? (IConstructorInfo)constructors.get(0) : null;
    }

    private <T extends IHasParameterInfos> T ensureExactMatch(T methodInfo, IType[] argTypes) {
        if (methodInfo == null) {
            return null;
        }
        IParameterInfo[] parameters = methodInfo.getParameters();
        if (argTypes.length != parameters.length) {
            return null;
        }
        IType[] boundParamTypes = this.boundGenericFunctionTypeVariables(methodInfo, this.getParameterTypes(methodInfo));
        for (int i = 0; i < boundParamTypes.length; ++i) {
            IType parameterType = boundParamTypes[i];
            if (GosuObjectUtil.equals((Object)parameterType, (Object)argTypes[i])) continue;
            return null;
        }
        return methodInfo;
    }

    private IType[] boundGenericFunctionTypeVariables(IHasParameterInfos methodInfo, IType[] parametersTypes) {
        List<IType> typesToBound = this.getFunctionTypeVarsToBound(methodInfo);
        ArrayList<IType> boundParamTypes = new ArrayList<IType>();
        for (IType parameter : parametersTypes) {
            boundParamTypes.add(TypeLord.boundTypes(parameter, typesToBound));
        }
        return boundParamTypes.toArray(new IType[boundParamTypes.size()]);
    }

    private List<IType> getFunctionTypeVarsToBound(IHasParameterInfos methodInfo) {
        ArrayList<IType> typesToBound = new ArrayList<IType>();
        if (methodInfo instanceof IGenericMethodInfo) {
            IGenericTypeVariable[] typeVars;
            for (IGenericTypeVariable typeVar : typeVars = ((IGenericMethodInfo)methodInfo).getTypeVariables()) {
                typesToBound.add((IType)typeVar.getTypeVariableDefinition().getType());
            }
        }
        return typesToBound;
    }

    private IBlockType makeBlockType(IType returnType, IType[] params, List<String> argNames) {
        if (params.length > 16) {
            return new BlockType(returnType, Arrays.copyOfRange(params, 0, 15), argNames, Collections.emptyList());
        }
        return new BlockType(returnType, params, argNames, Collections.emptyList());
    }

    private List<? extends IInvocableType> getMethodTypes(String name) {
        ArrayList<FunctionType> functionTypes = new ArrayList<FunctionType>();
        IType rootType = this.getRootTypeToResolveFeaturesAgainst();
        ITypeInfo typeInfo = rootType.getTypeInfo();
        MethodList methods = typeInfo instanceof IRelativeTypeInfo ? ((IRelativeTypeInfo)typeInfo).getMethods(rootType) : typeInfo.getMethods();
        for (IMethodInfo mi : methods) {
            if (!mi.getDisplayName().equals(name)) continue;
            functionTypes.add(new FunctionType(mi));
        }
        return functionTypes;
    }

    private List<? extends IInvocableType> getConstructorTypes() {
        ArrayList<ConstructorType> constructorTypes = new ArrayList<ConstructorType>();
        IType rootType = this.getRootTypeToResolveFeaturesAgainst();
        ITypeInfo typeInfo = rootType.getTypeInfo();
        List constructors = typeInfo instanceof IRelativeTypeInfo ? ((IRelativeTypeInfo)typeInfo).getConstructors(rootType) : typeInfo.getConstructors();
        for (IConstructorInfo ci : constructors) {
            constructorTypes.add(new ConstructorType(ci));
        }
        return constructorTypes;
    }

    private void resolveExpressionType() {
        if (this._feature instanceof IPropertyInfo) {
            this.setType(this.resolvePropertyLiteralType((IPropertyInfo)this._feature));
        } else if (this._feature instanceof IMethodInfo) {
            this.setType(this.resolveMethodLiteralType((IMethodInfo)this._feature));
        } else if (this._feature instanceof IConstructorInfo) {
            this.setType(this.resolveConstructorLiteralType((IConstructorInfo)this._feature));
        } else {
            this.setType((IType)ErrorType.getInstance());
        }
    }

    private IType resolvePropertyLiteralType(IPropertyInfo propertyInfo) {
        this._parameterTypes = new IType[0];
        IType propertyReferenceType = this.getRoot() instanceof FeatureLiteral ? TypeSystem.get(this.isBound() ? BoundPropertyChainReference.class : PropertyChainReference.class) : TypeSystem.get(this.isBound() ? BoundPropertyReference.class : PropertyReference.class);
        return propertyReferenceType.getParameterizedType(new IType[]{this.getFinalRootType(), propertyInfo.getFeatureType()});
    }

    private IType resolveMethodLiteralType(IMethodInfo methodInfo) {
        IType rawType = TypeSystem.get(this.isBound() ? BoundMethodReference.class : MethodReference.class);
        this._parameterTypes = this.boundGenericFunctionTypeVariables((IHasParameterInfos)methodInfo, this.getParameterTypes((IHasParameterInfos)methodInfo));
        this._blockType = this.makeBlockType(TypeLord.boundTypes(methodInfo.getReturnType(), this.getFunctionTypeVarsToBound((IHasParameterInfos)methodInfo)), this.adjustParametersForFeature((IHasParameterInfos)methodInfo, this._parameterTypes), this.argNames((IHasParameterInfos)methodInfo));
        return rawType.getParameterizedType(new IType[]{this.getFinalRootType(), this._blockType});
    }

    private IType resolveConstructorLiteralType(IConstructorInfo constructorInfo) {
        IType rawType = TypeSystem.get(ConstructorReference.class);
        this._parameterTypes = this.boundGenericFunctionTypeVariables((IHasParameterInfos)constructorInfo, this.getParameterTypes((IHasParameterInfos)constructorInfo));
        this._blockType = this.makeBlockType(constructorInfo.getOwnersType(), this.adjustParametersForFeature((IHasParameterInfos)constructorInfo, this._parameterTypes), this.argNames((IHasParameterInfos)constructorInfo));
        return rawType.getParameterizedType(new IType[]{this.getFinalRootType(), this._blockType});
    }

    private List<String> argNames(IHasParameterInfos hasParams) {
        if (this.hasBoundArgs(hasParams)) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < hasParams.getParameters().length && i <= 16; ++i) {
            IParameterInfo iParameterInfo = hasParams.getParameters()[i];
            names.add(iParameterInfo.getName());
        }
        return names;
    }

    private IType[] adjustParametersForFeature(IHasParameterInfos feature, IType[] params) {
        if (this.hasBoundArgs(feature)) {
            params = new IType[]{};
        }
        if (this.hasImplicitFirstArg()) {
            ArrayList<IType> combined = new ArrayList<IType>();
            combined.add(this.getRootType());
            combined.addAll(Arrays.asList(params));
            params = combined.toArray(new IType[combined.size()]);
        }
        return params;
    }

    private boolean hasBoundArgs(IHasParameterInfos feature) {
        return this._boundArgs != null && this._boundArgs.size() > 0 && this._boundArgs.size() == feature.getParameters().length;
    }

    private boolean hasImplicitFirstArg() {
        return !this.isBound() && !this.isStaticish();
    }

    private IType[] getParameterTypes(IHasParameterInfos hasParameterInfos) {
        IParameterInfo[] parameters = hasParameterInfos.getParameters();
        ArrayList<IType> types = new ArrayList<IType>();
        for (IParameterInfo parameter : parameters) {
            types.add(parameter.getFeatureType());
        }
        return types.toArray(new IType[types.size()]);
    }

    private String featureRepresentation() {
        return this._feature == null ? "<ERROR>" : this._feature.getName();
    }

    private IType getRootTypeToResolveFeaturesAgainst() {
        if (this._root instanceof FeatureLiteral) {
            return ((FeatureLiteral)this._root).getFeatureReturnType();
        }
        if (this._root instanceof TypeLiteral) {
            return ((TypeLiteral)this._root).getType().getType();
        }
        return this._root.getType();
    }

    private IType getFeatureReturnType() {
        if (this._feature instanceof IPropertyInfo) {
            return ((IPropertyInfo)this._feature).getFeatureType();
        }
        if (this._feature instanceof IMethodInfo) {
            return ((IMethodInfo)this._feature).getReturnType();
        }
        if (this._feature instanceof IConstructorInfo) {
            return ((IConstructorInfo)this._feature).getType();
        }
        return ErrorType.getInstance();
    }
}

