/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.compiler.bytecode;

import gw.internal.ext.org.objectweb.asm.Type;
import gw.lang.ir.IRType;

public class AbstractBytecodeCompiler {
    public static final Type OBJECT_TYPE = Type.getType(Object.class);

    public static int getIns(int opcode, IRType type) {
        if (opcode == 89) {
            return AbstractBytecodeCompiler.isWide(type) ? 92 : opcode;
        }
        if (opcode == 87) {
            return AbstractBytecodeCompiler.isWide(type) ? 88 : opcode;
        }
        switch (opcode) {
            case 21: 
            case 46: 
            case 54: 
            case 79: 
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 116: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 172: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Opcode: " + Integer.toHexString(opcode) + " is not handled");
            }
        }
        if (type.isByte()) {
            return Type.BYTE_TYPE.getOpcode(opcode);
        }
        if (type.isChar()) {
            return Type.CHAR_TYPE.getOpcode(opcode);
        }
        if (type.isShort()) {
            return Type.SHORT_TYPE.getOpcode(opcode);
        }
        if (type.isBoolean()) {
            return Type.BOOLEAN_TYPE.getOpcode(opcode);
        }
        if (type.isInt()) {
            return Type.INT_TYPE.getOpcode(opcode);
        }
        if (type.isLong()) {
            return Type.LONG_TYPE.getOpcode(opcode);
        }
        if (type.isFloat()) {
            return Type.FLOAT_TYPE.getOpcode(opcode);
        }
        if (type.isDouble()) {
            return Type.DOUBLE_TYPE.getOpcode(opcode);
        }
        return OBJECT_TYPE.getOpcode(opcode);
    }

    public static boolean isWide(IRType type) {
        return type.getName().equals("long") || type.getName().equals("double");
    }
}

