/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.ParsedElement;
import gw.internal.gosu.parser.ProgramClassFunctionSymbol;
import gw.internal.gosu.parser.Statement;
import gw.internal.gosu.parser.expressions.NewExpression;
import gw.internal.gosu.parser.statements.FunctionStatement;
import gw.lang.parser.IParseIssue;
import gw.lang.parser.IParseTree;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.IParsedElementWithAtLeastOneDeclaration;
import gw.lang.parser.IScriptPartId;
import gw.lang.parser.IStatement;
import gw.lang.parser.IToken;
import gw.lang.parser.exceptions.ParseIssue;
import gw.lang.parser.expressions.IMemberAccessExpression;
import gw.lang.parser.statements.IFunctionStatement;
import gw.lang.reflect.IType;
import gw.util.DynamicArray;
import gw.util.GosuObjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class ParseTree
implements IParseTree {
    private static final DynamicArray<ParseTree> EMPTY_PARSE_TREE_LIST = new DynamicArray(0);
    private transient ParsedElement _pe;
    private DynamicArray<ParseTree> _children;
    private int _iOffset;
    private int _iLength;
    private transient IScriptPartId _scriptPart;

    ParseTree(ParsedElement pe, int iOffset, int iLength, IScriptPartId scriptPart) {
        this._pe = pe;
        this._iOffset = iOffset;
        this._iLength = iLength;
        this._scriptPart = scriptPart;
        this._children = EMPTY_PARSE_TREE_LIST;
    }

    public IType getEnclosingType() {
        return this._scriptPart == null ? null : this._scriptPart.getContainingType();
    }

    public IScriptPartId getScriptPartId() {
        return this._scriptPart;
    }

    public int getOffset() {
        return this._iOffset;
    }

    public int getLength() {
        return this._iLength;
    }

    public void setLength(int iLength) {
        this._iLength = iLength;
    }

    public int getLineNum() {
        return this._pe.getLineNum();
    }

    public int getColumn() {
        return this._pe.getColumn();
    }

    public ParsedElement getParsedElement() {
        return this._pe;
    }

    public int getExtent() {
        return this.getOffset() + this.getLength() - 1;
    }

    public boolean contains(int iPosition) {
        return this.contains(iPosition, iPosition);
    }

    public boolean contains(IParseTree l) {
        return this.contains(l.getOffset(), l.getExtent());
    }

    private boolean contains(int start, int end) {
        return start >= this.getOffset() && end <= this.getExtent();
    }

    public boolean containsOrBorders(int iPosition, boolean strict) {
        return this.containsOrBorders(iPosition, iPosition, strict);
    }

    public boolean containsOrBorders(IParseTree l, boolean strict) {
        return this.containsOrBorders(l.getOffset(), l.getExtent(), strict);
    }

    private boolean containsOrBorders(int start, int end, boolean strict) {
        ParseTree nextSibling;
        int rightBounds = strict ? this.getOffset() + this.getLength() : ((nextSibling = this.getNextSibling()) != null ? nextSibling.getOffset() - 1 : this.getOffset() + this.getLength());
        return start >= this.getOffset() && end <= rightBounds;
    }

    public ParseTree getDeepestLocation(boolean statementsOnly, int iStart, int iEnd, boolean strict) {
        ParseTree l;
        Statement embededStmt;
        if (!this.containsOrBorders(iStart, iEnd, strict)) {
            return null;
        }
        ParseTree deepest = null;
        if (!statementsOnly || this._pe instanceof IStatement) {
            deepest = this;
        }
        if (this._children != null) {
            for (int i = 0; i < this._children.size; ++i) {
                ParseTree child = (ParseTree)this._children.data[i];
                ParseTree l2 = child.getDeepestLocation(statementsOnly, iStart, iEnd, strict);
                if (!IParseTree.Search.isDeeper((IParseTree)deepest, (IParseTree)l2)) continue;
                deepest = l2;
            }
        }
        if ((embededStmt = (Statement)IParseTree.Search.getHiddenStatement((IParsedElement)this.getParsedElement())) != null && embededStmt.getLocation() != null && IParseTree.Search.isDeeper((IParseTree)deepest, (IParseTree)(l = embededStmt.getLocation().getDeepestLocation(statementsOnly, iStart, iEnd, strict)))) {
            deepest = l;
        }
        return deepest;
    }

    public boolean isAncestorOf(IParseTree l) {
        while (l != null && l.getParent() != l) {
            if ((l = l.getParent()) != this) continue;
            return true;
        }
        return false;
    }

    private ParseTree getDeepestLocation(boolean statementsOnly, int iPosition, boolean strict) {
        return this.getDeepestLocation(statementsOnly, iPosition, iPosition, strict);
    }

    public ParseTree getDeepestLocation(int iPosition, boolean strict) {
        return this.getDeepestLocation(iPosition, iPosition, strict);
    }

    public ParseTree getDeepestLocation(int iStart, int iEnd, boolean strict) {
        return this.getDeepestLocation(false, iStart, iEnd, strict);
    }

    public ParseTree getDeepestStatementLocation(int iPosition, boolean strict) {
        return this.getDeepestLocation(true, iPosition, strict);
    }

    public ParseTree getStatementAtLine(int iLineNum, Class clsSkip) {
        NewExpression newExpression;
        IType type;
        if (this._pe instanceof NewExpression && (type = (newExpression = (NewExpression)this._pe).getType()) instanceof IGosuClassInternal && newExpression.isAnonymousClass()) {
            return (ParseTree)((IGosuClassInternal)type).getClassStatement().getLocation().getStatementAtLine(iLineNum, clsSkip);
        }
        if (!(!(this._pe instanceof Statement) || this._pe instanceof FunctionStatement && ((FunctionStatement)this._pe).getDynamicFunctionSymbol() instanceof ProgramClassFunctionSymbol || this.getLineNum() != iLineNum || clsSkip != null && clsSkip.isAssignableFrom(this._pe.getClass()))) {
            return this;
        }
        ParseTree deepest = null;
        for (int i = 0; i < this._children.size; ++i) {
            ParseTree child = (ParseTree)this._children.data[i];
            ParseTree l = child.getStatementAtLine(iLineNum, clsSkip);
            if (!IParseTree.Search.isDeeper(deepest, (IParseTree)l)) continue;
            deepest = l;
        }
        return deepest;
    }

    public void addChild(IParseTree l) {
        this.addChild(-1, l);
    }

    public void addChild(int iIndex, IParseTree l) {
        if (l == null) {
            throw new NullPointerException("Attempted to add a Null child location.");
        }
        if (!this.contains(l) && l.getLength() > 0) {
            throw new IllegalArgumentException("Attempted to add a child location whose bounds extend beyond the containing location: (" + this.getOffset() + ", " + this.getExtent() + ") does not contain (" + l.getOffset() + ", " + l.getExtent() + ")");
        }
        if (this._children == EMPTY_PARSE_TREE_LIST) {
            this._children = new DynamicArray(2);
        }
        l.setParent((IParseTree)this);
        if (iIndex >= 0) {
            this._children.add(iIndex, (Object)((ParseTree)l));
        } else {
            this._children.add((Object)((ParseTree)l));
        }
    }

    public void removeChild(IParseTree l) {
        if (l != null && this._children != null) {
            this._children.remove((Object)l);
            l.setParent(null);
        }
    }

    public List<IParseTree> getChildren() {
        return this._children == null ? Collections.emptyList() : Collections.unmodifiableList(this._children);
    }

    public int getChildCount() {
        return this._children == null ? 0 : this._children.size;
    }

    public void setParent(IParseTree l) {
        if (l != null && !l.contains((IParseTree)this) && this.getLength() > 0) {
            throw new IllegalArgumentException("Attempted set the parent location, but the parent location's area is not a superset of this location's area.");
        }
        if (this._pe != null) {
            ParseTree oldParent;
            ParsedElement parentElement = (ParsedElement)this._pe.getParent();
            if (parentElement != null && (oldParent = parentElement.getLocation()) != null) {
                oldParent._children.remove((Object)this);
            }
            this._pe.setParent(l == null ? null : ((ParseTree)l)._pe);
        }
    }

    public IParseTree getParent() {
        return this._pe != null && this._pe.getParent() != null ? this._pe.getParent().getLocation() : null;
    }

    public IParseTree getParentOtherThanThis() {
        IParseTree parent = this.getParent();
        return parent == this ? null : parent;
    }

    public boolean areOffsetAndExtentEqual(IParseTree location) {
        return location != null && location.getOffset() == this.getOffset() && location.getExtent() == this.getExtent();
    }

    public String toString() {
        return "Offset: " + this.getOffset() + "\n" + "Length: " + this.getLength() + "\n" + (this._pe != null ? this._pe.getClass().getSimpleName() : "ParsedElement") + ": " + this._pe;
    }

    public void initLocation(ParsedElement pe, int iOffset, int iLength) {
        this._pe = this._pe == null ? pe : this._pe;
        this._iOffset = iOffset;
        this._iLength = iLength;
    }

    public void compactParseTree() {
        if (this._children != null) {
            for (int i = 0; i < this._children.size; ++i) {
                ParseTree child = (ParseTree)this._children.data[i];
                child.compactParseTree();
            }
            this._children.trimToSize();
        }
    }

    public void clearParseTreeInformation() {
        if (this.getParsedElement() == null || this.getParsedElement().shouldClearParseInfo()) {
            if (this._children != null) {
                for (int i = 0; i < this._children.size; ++i) {
                    ParseTree child = (ParseTree)this._children.data[i];
                    child.clearParseTreeInformation();
                }
            }
            this._children = EMPTY_PARSE_TREE_LIST;
            if (this._pe != null) {
                this._pe.setLocation(null);
            }
            this._pe = null;
        }
    }

    public boolean areAllChildrenAfterPosition(int caret) {
        for (int i = 0; i < this._children.size; ++i) {
            ParseTree child = (ParseTree)this._children.data[i];
            if (child.getOffset() >= caret) continue;
            return false;
        }
        return true;
    }

    public List<IParseTree> getDominatingLocationList() {
        ArrayList<IParseTree> dominatingLocations = new ArrayList<IParseTree>();
        if (this.getParent() != null) {
            List parentDominators = this.getParent().getDominatingLocationList();
            dominatingLocations.addAll(parentDominators);
            dominatingLocations.add(this.getParent());
            dominatingLocations.addAll(this.getParent().getChildrenBefore((IParseTree)this));
        }
        return dominatingLocations;
    }

    public List<IParseTree> getChildrenBefore(IParseTree parseTree) {
        ArrayList<IParseTree> childrenBefore = new ArrayList<IParseTree>();
        for (int i = 0; i < this._children.size; ++i) {
            ParseTree child = (ParseTree)this._children.data[i];
            if (child.getOffset() >= parseTree.getOffset()) continue;
            childrenBefore.add(child);
        }
        return childrenBefore;
    }

    public boolean isSiblingOf(IParseTree deepestAtEnd) {
        return this.getParent() != null && GosuObjectUtil.equals((Object)this.getParent(), (Object)deepestAtEnd.getParent());
    }

    public ParseTree getChildAfter(int point) {
        int minDistance = Integer.MAX_VALUE;
        ParseTree closestTrailingChild = null;
        for (int i = 0; i < this._children.size; ++i) {
            ParseTree child = (ParseTree)this._children.data[i];
            int dist = child.getOffset() - point;
            if (dist <= 0 || dist >= minDistance) continue;
            minDistance = dist;
            closestTrailingChild = child;
        }
        return closestTrailingChild;
    }

    public ParseTree getChildBefore(int point) {
        int minDistance = Integer.MAX_VALUE;
        ParseTree closestTrailingChild = null;
        for (int i = 0; i < this._children.size; ++i) {
            ParseTree child = (ParseTree)this._children.data[i];
            int dist = point - child.getOffset();
            if (dist <= 0 || dist >= minDistance) continue;
            minDistance = dist;
            closestTrailingChild = child;
        }
        return closestTrailingChild;
    }

    public ParseTree getChildBefore(IParseTree child) {
        return this.getChildBefore(child.getOffset());
    }

    public ParseTree getChildAfter(IParseTree child) {
        return this.getChildAfter(child.getExtent());
    }

    public ParseTree getFirstChildWithParsedElementType(Class<? extends IParsedElement> aClass) {
        ParseTree returnChild = null;
        for (int i = 0; i < this._children.size; ++i) {
            ParseTree child = (ParseTree)this._children.data[i];
            if (!aClass.isInstance(child.getParsedElement()) || returnChild != null && child.getOffset() >= returnChild.getOffset()) continue;
            returnChild = child;
        }
        return returnChild;
    }

    public ParseTree getLastChildWithParsedElementType(Class<? extends IParsedElement> aClass) {
        ParseTree returnChild = null;
        for (int i = 0; i < this._children.size; ++i) {
            ParseTree child = (ParseTree)this._children.data[i];
            if (!aClass.isInstance(child.getParsedElement()) || returnChild != null && child.getOffset() <= returnChild.getOffset()) continue;
            returnChild = child;
        }
        return returnChild;
    }

    public ParseTree getLastChild() {
        return this.getChildBefore(this.getExtent());
    }

    public ParseTree getNextSibling() {
        IParseTree parent = this.getParent();
        if (parent == null || parent == this) {
            return null;
        }
        return (ParseTree)this.getParent().getChildAfter((IParseTree)this);
    }

    public ParseTree getPreviousSibling() {
        if (this.getParent() == null) {
            return null;
        }
        return (ParseTree)this.getParent().getChildBefore((IParseTree)this);
    }

    public ParseTree getDeepestFirstChild() {
        ParseTree parseTree = this;
        while (parseTree.getFirstChildWithParsedElementType(ParsedElement.class) != null) {
            parseTree = parseTree.getFirstChildWithParsedElementType(ParsedElement.class);
        }
        return parseTree;
    }

    public Collection<IParseTree> findDescendantsWithParsedElementType(Class type) {
        ArrayList<IParseTree> matches = new ArrayList<IParseTree>();
        this.findDescendantsWithParsedElementType(matches, type);
        return matches;
    }

    public void addUnder(IParseTree parent) {
        int offset = parent.getOffset();
        int lineNumOffset = parent.getParsedElement().getLineNum() - 1;
        int columnOffset = parent.getParsedElement().getColumn();
        this.adjustOffset(offset, lineNumOffset, columnOffset);
        this.setParent(parent);
        this._scriptPart = parent.getScriptPartId();
        parent.addChild((IParseTree)this);
    }

    void adjustOffset(int offset, int lineNumOffset, int columnOffset) {
        if (this.getLineNum() > 1) {
            columnOffset = 0;
        }
        this.recursivelyAdjustOffset(offset, lineNumOffset, columnOffset);
        if (this._pe != null) {
            for (IParseIssue parseIssue : this._pe.getParseIssues()) {
                ((ParseIssue)parseIssue).adjustOffset(offset, lineNumOffset, columnOffset);
            }
        }
    }

    private void recursivelyAdjustOffset(int offset, int lineNumOffset, int columnOffset) {
        if (this.getLineNum() > 1) {
            columnOffset = 0;
        }
        this._iOffset += offset;
        if (this._pe != null) {
            this._pe.adjustLineNum(lineNumOffset);
            this._pe.adjustColumn(columnOffset);
        }
        for (int i = 0; i < this._children.size; ++i) {
            ParseTree child = (ParseTree)this._children.data[i];
            child.recursivelyAdjustOffset(offset, lineNumOffset, columnOffset);
        }
        if (this._pe instanceof IMemberAccessExpression) {
            IMemberAccessExpression mae = (IMemberAccessExpression)this._pe;
            mae.setStartOffset(mae.getStartOffset() + offset);
        }
        if (this._pe instanceof IParsedElementWithAtLeastOneDeclaration) {
            IParsedElementWithAtLeastOneDeclaration peo = (IParsedElementWithAtLeastOneDeclaration)this._pe;
            String[] stringArray = peo.getDeclarations();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String name;
                String charSeq = name = stringArray[i];
                peo.setNameOffset(peo.getNameOffset(charSeq) + offset, charSeq);
            }
        }
    }

    private void findDescendantsWithParsedElementType(ArrayList<IParseTree> matches, Class type) {
        if (type.isAssignableFrom(this._pe.getClass())) {
            matches.add(this);
        }
        for (int i = 0; i < this._children.size; ++i) {
            ParseTree child = (ParseTree)this._children.data[i];
            child.findDescendantsWithParsedElementType(matches, type);
        }
    }

    public IFunctionStatement getEnclosingFunctionStatement() {
        for (ParseTree csr = this; csr != null; csr = (ParseTree)csr.getParentOtherThanThis()) {
            ParsedElement pe = csr.getParsedElement();
            if (!(pe instanceof IFunctionStatement)) continue;
            return (IFunctionStatement)pe;
        }
        return null;
    }

    public final IParseTree getMatchingElement(int iStart, int iLength) {
        if (this._iOffset == iStart && this._iLength == iLength) {
            return this;
        }
        if (this._children != null) {
            for (int i = 0; i < this._children.size; ++i) {
                ParseTree child = (ParseTree)this._children.data[i];
                IParseTree tree = child.getMatchingElement(iStart, iLength);
                if (tree == null) continue;
                return tree;
            }
        }
        return null;
    }

    public String getTreeOutline() {
        return this.getTreeOutline("");
    }

    private String getTreeOutline(String strIndent) {
        List<IToken> tokens = this.getParsedElement().getTokens();
        StringBuilder source = new StringBuilder();
        source.append("\n" + strIndent + "- <" + this.getParsedElement().getClass().getSimpleName() + ">  Offset: " + this.getOffset() + " Extent: " + this.getExtent());
        strIndent = strIndent + "  ";
        StringBuilder tokenContent = new StringBuilder();
        this.appendTokensForOutline(null, tokens, tokenContent);
        if (tokenContent.length() > 0) {
            source.append("\n" + strIndent + "- ");
            source.append((CharSequence)tokenContent);
        }
        for (IParseTree child : this.getChildrenSorted()) {
            source.append(((ParseTree)child).getTreeOutline(strIndent));
            tokenContent = new StringBuilder();
            this.appendTokensForOutline((ParseTree)child, tokens, tokenContent);
            if (tokenContent.length() <= 0) continue;
            source.append("\n" + strIndent + "- ");
            source.append((CharSequence)tokenContent);
        }
        return source.toString();
    }

    private void appendTokensForOutline(ParseTree child, List<IToken> tokens, StringBuilder source) {
        StringBuilder sbTokens = new StringBuilder();
        this.addTokens(child, tokens, sbTokens);
        source.append(sbTokens.toString().replace('\n', '\u014a').replace('\r', '\u019d').replace(' ', '\u1d13'));
    }

    public String getTextFromTokens() {
        List<IToken> tokens = this.getParsedElement().getTokens();
        StringBuilder source = new StringBuilder();
        this.addTokens(null, tokens, source);
        for (IParseTree child : this.getChildrenSorted()) {
            source.append(child.getTextFromTokens());
            this.addTokens((ParseTree)child, tokens, source);
        }
        return source.toString();
    }

    private void addTokens(ParseTree after, List<IToken> tokens, StringBuilder source) {
        for (IToken t : tokens) {
            if (t.getAfter() != after && (after == null || !after.isAncestor(t.getAfter())) || t.getType() == -1) continue;
            source.append(t.getText());
        }
    }

    public List<IParseTree> getChildrenSorted() {
        ArrayList<IParseTree> children = new ArrayList<IParseTree>((Collection<IParseTree>)this._children);
        Collections.sort(children, new Comparator<IParseTree>(){

            @Override
            public int compare(IParseTree o1, IParseTree o2) {
                return o1.getOffset() - o2.getOffset();
            }
        });
        return children;
    }

    public boolean isAncestor(IParseTree child) {
        if (child == null) {
            return false;
        }
        if (this == child) {
            return true;
        }
        if (child == child.getParent()) {
            return false;
        }
        return this.isAncestor(child.getParent());
    }
}

