/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.expression;

import gw.internal.gosu.ir.transform.ExpressionTransformer;
import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.expression.AbstractExpressionTransformer;
import gw.internal.gosu.ir.transform.expression.AdditiveExpressionTransformer;
import gw.internal.gosu.parser.BeanAccess;
import gw.internal.gosu.parser.expressions.AdditiveExpression;
import gw.internal.gosu.parser.expressions.NumericLiteral;
import gw.internal.gosu.parser.expressions.UnaryExpression;
import gw.internal.gosu.parser.expressions.UnsupportedNumberTypeException;
import gw.lang.IDimension;
import gw.lang.ir.IRExpression;
import gw.lang.reflect.IType;
import gw.lang.reflect.java.JavaTypes;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;

public class UnaryExpressionTransformer
extends AbstractExpressionTransformer<UnaryExpression> {
    public static IRExpression compile(TopLevelTransformationContext cc, UnaryExpression expr) {
        UnaryExpressionTransformer gen = new UnaryExpressionTransformer(cc, expr);
        return gen.compile();
    }

    private UnaryExpressionTransformer(TopLevelTransformationContext cc, UnaryExpression expr) {
        super(cc, expr);
    }

    @Override
    protected IRExpression compile_impl() {
        IRExpression root = ExpressionTransformer.compile(((UnaryExpression)this._expr()).getExpression(), this._cc());
        if (((UnaryExpression)this._expr()).getType().isPrimitive() && BeanAccess.isNumericType(((UnaryExpression)this._expr()).getType())) {
            return this.negateSimple(root);
        }
        return this.negateComplex(root);
    }

    private IRExpression negateSimple(IRExpression root) {
        if (((UnaryExpression)this._expr()).isNegated()) {
            IType type = ((UnaryExpression)this._expr()).getType();
            if (this.isCheckedArithmeticEnabled() && (type == JavaTypes.pINT() || type == JavaTypes.pLONG()) && !((UnaryExpression)this._expr()).isUnchecked()) {
                IRExpression zero;
                Class[] paramTypes;
                if (type == JavaTypes.pINT()) {
                    paramTypes = new Class[]{Integer.TYPE, Integer.TYPE};
                    zero = this.pushConstant(0);
                } else {
                    paramTypes = new Class[]{Long.TYPE, Long.TYPE};
                    zero = this.pushConstant(0L);
                }
                return this.callStaticMethod(Math.class, "subtractExact", paramTypes, Arrays.asList(zero, root));
            }
            return this.buildNegation(root);
        }
        return root;
    }

    private IRExpression negateComplex(IRExpression root) {
        IType type = ((UnaryExpression)this._expr()).getType();
        if (UnaryExpressionTransformer.isNumberType(type) || JavaTypes.BIG_DECIMAL().equals(type) || JavaTypes.BIG_INTEGER().equals(type)) {
            AdditiveExpression expr = new AdditiveExpression();
            expr.setLHS(new NumericLiteral("0", 0, (IType)JavaTypes.pINT()));
            expr.setRHS(((UnaryExpression)this._expr()).getExpression());
            expr.setOperator(((UnaryExpression)this._expr()).isUnchecked() ? "!-" : "-");
            expr.setType(type);
            return AdditiveExpressionTransformer.compile(this._cc(), expr);
        }
        IRExpression negateCall = this.callStaticMethod(this.getClass(), "negateComplex", new Class[]{Object.class, Boolean.TYPE}, UnaryExpressionTransformer.exprList(this.boxValue(((UnaryExpression)this._expr()).getExpression().getType(), root), this.pushConstant(((UnaryExpression)this._expr()).isNegated())));
        return this.unboxValueToType(((UnaryExpression)this._expr()).getType(), negateCall);
    }

    public static Object negateComplex(Object value, boolean bNegated) {
        if (value == null) {
            return null;
        }
        if (bNegated) {
            IDimension dimension = null;
            if (value instanceof IDimension) {
                dimension = (IDimension)value;
                value = ((IDimension)value).toNumber();
            }
            if (value instanceof BigDecimal) {
                value = ((BigDecimal)value).negate();
            } else if (value instanceof BigInteger) {
                value = ((BigInteger)value).negate();
            } else if (value instanceof Integer) {
                value = -((Integer)value).intValue();
            } else if (value instanceof Long) {
                value = -((Long)value).longValue();
            } else if (value instanceof Double) {
                value = -((Double)value).doubleValue();
            } else if (value instanceof Float) {
                value = Float.valueOf(-((Float)value).floatValue());
            } else if (value instanceof Short) {
                value = -((Short)value).shortValue();
            } else if (value instanceof Byte) {
                value = -((Byte)value).byteValue();
            } else {
                throw new UnsupportedNumberTypeException(value.getClass());
            }
            if (dimension != null) {
                value = dimension.fromNumber((Number)value);
            }
        }
        return value;
    }
}

