/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.config.CommonServices;
import gw.fs.IDirectory;
import gw.fs.IFile;
import gw.fs.IResource;
import gw.internal.gosu.module.fs.FileSystemImpl;
import gw.lang.reflect.IDefaultTypeLoader;
import gw.lang.reflect.ITypeLoader;
import gw.lang.reflect.gs.TypeName;
import gw.lang.reflect.module.IClassPath;
import gw.lang.reflect.module.IFileSystem;
import gw.lang.reflect.module.IModule;
import gw.util.cache.FqnCache;
import gw.util.cache.FqnCacheNode;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ClassPath
implements IClassPath {
    private static final String CLASS_FILE_EXT = ".class";
    private IModule _module;
    private IClassPath.ClassPathFilter _filter;
    private FqnCache<Object> _cache = new FqnCache();
    private IFileSystem _fs;
    private boolean _bStableFiles;

    public ClassPath(IModule module, IClassPath.ClassPathFilter filter) {
        this._module = module;
        this._filter = filter;
        this._fs = CommonServices.getFileSystem();
        this._bStableFiles = this._fs instanceof FileSystemImpl;
        this.loadClasspathInfo();
    }

    public ArrayList<IDirectory> getPaths() {
        return new ArrayList<IDirectory>(this._module.getJavaClassPath());
    }

    public boolean contains(String fqn) {
        return this._cache.contains(fqn);
    }

    public IFile get(String fqn) {
        FqnCacheNode node = this._cache.getNode(fqn);
        if (node == null) {
            return null;
        }
        Object value = node.getUserData();
        if (value instanceof IFile) {
            if (this._bStableFiles) {
                return (IFile)value;
            }
            try {
                value = ((IFile)value).toURI().toURL();
                node.setUserData(value);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return this._fs.getIFile((URL)value);
    }

    public Set<String> getFilteredClassNames() {
        return this._cache.getFqns();
    }

    public boolean isEmpty() {
        return this._cache.getRoot().isLeaf();
    }

    private void loadClasspathInfo() {
        List javaClassPath = this._module.getJavaClassPath();
        IDirectory[] paths = javaClassPath.toArray(new IDirectory[javaClassPath.size()]);
        for (int i = paths.length - 1; i >= 0; --i) {
            IDirectory path = paths[i];
            this.addClassNames(path, path, this._filter);
        }
    }

    private void addClassNames(IDirectory root, IDirectory dir, IClassPath.ClassPathFilter filter) {
        for (IFile file : dir.listFiles()) {
            String strClassName;
            if (!this.isClassFileName(file.getName()) || !this.isValidClassName(strClassName = this.getClassNameFromFile(root, file))) continue;
            this.putClassName(file, strClassName, filter);
        }
        for (IDirectory subDir : dir.listDirs()) {
            this.addClassNames(root, subDir, filter);
        }
    }

    private void putClassName(IFile file, String strClassName, IClassPath.ClassPathFilter filter) {
        boolean bFiltered;
        boolean bl = bFiltered = filter != null && !filter.acceptClass(strClassName);
        if (bFiltered) {
            strClassName = ClassPath.getPlaceholderClassNameForFilteredPackage(strClassName);
        }
        if (strClassName != null) {
            this._cache.add(strClassName, (Object)file);
        }
    }

    private static String getPlaceholderClassNameForFilteredPackage(String strClassName) {
        int iIndex = strClassName.lastIndexOf(46);
        if (iIndex > 0) {
            return strClassName.substring(0, iIndex + 1) + "PLACEHOLDER";
        }
        return null;
    }

    private String getClassNameFromFile(IDirectory root, IFile file) {
        String strQualifiedClassName = root.relativePath((IResource)file);
        if (!this.isClassFileName(strQualifiedClassName)) {
            throw new IllegalArgumentException(file.getPath() + " is not a legal Java class name. " + "It does not end with " + CLASS_FILE_EXT);
        }
        strQualifiedClassName = strQualifiedClassName.substring(0, strQualifiedClassName.length() - CLASS_FILE_EXT.length());
        return strQualifiedClassName.replace('/', '.');
    }

    private boolean isClassFileName(String strFileName) {
        return strFileName.toLowerCase().endsWith(CLASS_FILE_EXT);
    }

    private boolean isValidClassName(String strClassName) {
        if (strClassName.endsWith("package-info")) {
            return false;
        }
        int index = strClassName.lastIndexOf(36);
        return !this._filter.isIgnoreAnonymous() || index < 0 || index >= strClassName.length() - 1 || !Character.isDigit(strClassName.charAt(index + 1));
    }

    public boolean hasNamespace(String namespace) {
        FqnCacheNode infoNode = this._cache.getNode(namespace);
        return infoNode != null && !infoNode.isLeaf();
    }

    public Set<TypeName> getTypeNames(String namespace) {
        FqnCacheNode node = this._cache.getNode(namespace);
        IDefaultTypeLoader defaultTypeLoader = this._module.getModuleTypeLoader().getDefaultTypeLoader();
        if (node != null) {
            HashSet<TypeName> names = new HashSet<TypeName>();
            for (FqnCacheNode child : node.getChildren()) {
                if (child.isLeaf()) {
                    names.add(new TypeName(namespace + "." + child.getName(), (ITypeLoader)defaultTypeLoader, TypeName.Kind.TYPE, TypeName.Visibility.PUBLIC));
                    continue;
                }
                names.add(new TypeName(child.getName(), (ITypeLoader)defaultTypeLoader, TypeName.Kind.NAMESPACE, TypeName.Visibility.PUBLIC));
            }
            return names;
        }
        return Collections.emptySet();
    }

    public String toString() {
        return this._module.getName();
    }
}

