/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.coercer;

import gw.internal.gosu.compiler.GosuClassLoader;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.TypeLord;
import gw.lang.parser.IHasInnerClass;
import gw.lang.parser.ISource;
import gw.lang.parser.TypeVarToTypeMap;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.ClassType;
import gw.lang.reflect.gs.GosuClassTypeLoader;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuEnhancement;
import gw.lang.reflect.gs.IGosuObject;
import gw.lang.reflect.gs.ISourceFileHandle;
import gw.lang.reflect.gs.StringSourceFileHandle;
import gw.lang.reflect.java.IJavaMethodInfo;
import gw.lang.reflect.java.JavaTypes;
import gw.lang.reflect.module.IModule;
import gw.util.fingerprint.FP64;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;

public class FunctionToInterfaceClassGenerator {
    private static final Map<String, String> MAP = new HashMap<String, String>();
    public static final String PROXY_FOR = "ProxyFor_";

    public static synchronized IGosuClass getBlockToInterfaceConversionClass(IType typeToCoerceTo, IType enclosingType) {
        if (!(enclosingType instanceof IGosuClass)) {
            enclosingType = TypeSystem.getByFullName((String)"gw.lang.TopLevelBlockToInterfaceHolder");
        }
        typeToCoerceTo = TypeLord.replaceTypeVariableTypeParametersWithBoundingTypes(typeToCoerceTo, enclosingType);
        String relativeNameWithEncodedSuffix = PROXY_FOR + FunctionToInterfaceClassGenerator.encodeClassName(typeToCoerceTo.getName());
        return (IGosuClass)((IHasInnerClass)enclosingType).getInnerClass((CharSequence)relativeNameWithEncodedSuffix);
    }

    public static synchronized IGosuClass getBlockToInterfaceConversionClass(String relativeNameWithEncodedSuffix, IType enclosingType) {
        String name = FunctionToInterfaceClassGenerator.decodeClassName(enclosingType, relativeNameWithEncodedSuffix.substring(PROXY_FOR.length()));
        IType typeToCoerceTo = TypeLord.parseType(name, new TypeVarToTypeMap());
        return FunctionToInterfaceClassGenerator.createProxy(name, typeToCoerceTo, enclosingType, relativeNameWithEncodedSuffix);
    }

    private static String encodeClassName(String name) {
        String fp = String.valueOf(new FP64(name).getRawFingerprint()).replace('-', '_');
        MAP.put(fp, name);
        return fp;
    }

    private static String decodeClassName(IType enclosingType, String fp) {
        String name = MAP.get(fp);
        if (name == null) {
            try {
                Class<?> cls = GosuClassLoader.instance().getActualLoader().loadClass(((IGosuClass)enclosingType).getBackingClass().getName() + "$" + PROXY_FOR + fp);
                Field field = cls.getDeclaredField("$REDRUM");
                field.setAccessible(true);
                name = (String)field.get(null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IGosuClass createProxy(final String name, final IType typeToCoerceTo, IType enclosingType, final String relativeName) {
        IModule mod = enclosingType.getTypeLoader().getModule();
        TypeSystem.pushModule((IModule)mod);
        try {
            final String namespace = enclosingType.getNamespace();
            IGosuClassInternal gsClass = (IGosuClassInternal)GosuClassTypeLoader.getDefaultClassLoader().makeNewClass((ISourceFileHandle)new LazyStringSourceFileHandle(enclosingType.getName() + "." + relativeName, TypeLord.getPureGenericType(enclosingType), new Callable<StringBuilder>(){

                @Override
                public StringBuilder call() {
                    return FunctionToInterfaceClassGenerator.genProxy(name, typeToCoerceTo, namespace, relativeName);
                }
            }));
            gsClass.setEnclosingType(enclosingType);
            ((IGosuClassInternal)enclosingType).addInnerClass(gsClass);
            gsClass.compileDeclarationsIfNeeded();
            IGosuClassInternal iGosuClassInternal = gsClass;
            return iGosuClassInternal;
        }
        finally {
            TypeSystem.popModule((IModule)mod);
        }
    }

    private static StringBuilder genProxy(String name, IType type, String namespace, String relativeName) {
        IType ifaceType = type.isParameterizedType() ? TypeLord.replaceTypeVariableTypeParametersWithBoundingTypes(type) : type;
        StringBuilder sb = new StringBuilder().append("package ").append(namespace).append("\n").append("\n").append("static class ").append(relativeName).append(" implements ").append(ifaceType.getName()).append(" {\n").append("  static final var $REDRUM = \"").append(name).append("\"\n").append("  final var _block: gw.lang.function.IBlock\n").append("  \n").append("  construct( brock: gw.lang.function.IBlock ) {\n").append("    _block = brock\n").append("  }\n").append("  \n").append("  override function toString() : String {\n").append("    return _block.toString()\n").append("  }\n").append("\n");
        FunctionToInterfaceClassGenerator.implementIface(sb, type);
        sb.append("}");
        return sb;
    }

    private static void implementIface(StringBuilder sb, IType type) {
        int i;
        IMethodInfo mi = FunctionToInterfaceClassGenerator.getSingleMethod(type);
        IType returnType = TypeLord.replaceTypeVariableTypeParametersWithBoundingTypes(mi.getReturnType());
        if (mi instanceof IJavaMethodInfo) {
            IMethodInfo miGosu = FunctionToInterfaceClassGenerator.getSingleMethod((IType)IGosuClassInternal.Util.getGosuClassFrom(type));
            IMethodInfo iMethodInfo = mi = miGosu == null ? mi : miGosu;
        }
        if (mi.getName().startsWith("@")) {
            if (returnType == JavaTypes.pVOID()) {
                sb.append("  property set ");
            } else {
                sb.append("  property get ");
            }
            sb.append(mi.getDisplayName().substring(1)).append("(");
        } else {
            sb.append("  function ");
            sb.append(mi.getDisplayName()).append("(");
        }
        IParameterInfo[] params = mi.getParameters();
        for (i = 0; i < params.length; ++i) {
            IParameterInfo pi = params[i];
            sb.append(' ').append("p").append(i).append(": ").append(TypeLord.replaceTypeVariableTypeParametersWithBoundingTypes(pi.getFeatureType()).getName());
            sb.append(i < params.length - 1 ? (char)',' : ' ');
        }
        sb.append(") : ").append(returnType.getName()).append(" {\n").append(returnType == JavaTypes.pVOID() ? "    " : "    return ").append("_block.invokeWithArgs( {");
        for (i = 0; i < params.length; ++i) {
            sb.append(' ').append("p").append(i).append(i < params.length - 1 ? (char)',' : ' ');
        }
        sb.append("} )\n").append(FunctionToInterfaceClassGenerator.maybeCastReturnType(returnType)).append("  }\n");
    }

    private static String maybeCastReturnType(IType returnType) {
        return returnType != JavaTypes.pVOID() ? " as " + returnType.getName() : "";
    }

    private static IMethodInfo getSingleMethod(IType interfaceType) {
        if (interfaceType.isInterface()) {
            ArrayList list = new ArrayList(interfaceType.getTypeInfo().getMethods());
            Iterator it = list.iterator();
            while (it.hasNext()) {
                IMethodInfo methodInfo = (IMethodInfo)it.next();
                IParameterInfo[] parameterInfos = methodInfo.getParameters();
                IType[] paramTypes = new IType[parameterInfos.length];
                for (int i = 0; i < parameterInfos.length; ++i) {
                    paramTypes[i] = parameterInfos[i].getFeatureType();
                }
                String methodName = methodInfo.getDisplayName();
                if (JavaTypes.OBJECT().getTypeInfo().getMethod((CharSequence)methodName, paramTypes) != null || methodInfo.getOwnersType() instanceof IGosuEnhancement) {
                    it.remove();
                    continue;
                }
                if (methodName.startsWith("@") && JavaTypes.OBJECT().getTypeInfo().getProperty((CharSequence)methodName.substring(1)) != null) {
                    it.remove();
                    continue;
                }
                if (methodInfo.getOwnersType().getName().contains(IGosuObject.class.getName())) {
                    it.remove();
                    continue;
                }
                if (methodInfo.isAbstract()) continue;
                it.remove();
            }
            if (list.size() == 1) {
                return (IMethodInfo)list.get(0);
            }
        }
        return null;
    }

    private static class LazyStringSourceFileHandle
    extends StringSourceFileHandle {
        private Callable<StringBuilder> _sourceGen;
        private String _typeNamespace;

        public LazyStringSourceFileHandle(String fqn, IType enclosingType, Callable<StringBuilder> sourceGen) {
            super(fqn, null, false, ClassType.Class);
            this._sourceGen = sourceGen;
            this.setParentType(enclosingType.getName());
            this._typeNamespace = enclosingType.getName();
        }

        public String getTypeNamespace() {
            return this._typeNamespace;
        }

        public ISource getSource() {
            if (this.getRawSource() == null) {
                try {
                    this.setRawSource(this._sourceGen.call().toString());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return super.getSource();
        }
    }
}

