/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.compiler.bytecode.expression;

import gw.internal.ext.org.objectweb.asm.MethodVisitor;
import gw.internal.gosu.ir.compiler.bytecode.AbstractBytecodeCompiler;
import gw.internal.gosu.ir.compiler.bytecode.IRBytecodeContext;
import gw.lang.ir.expression.IRNumericLiteral;

public class IRNumericLiteralCompiler
extends AbstractBytecodeCompiler {
    public static void compile(IRNumericLiteral expression, IRBytecodeContext context) {
        block35: {
            Number constant;
            MethodVisitor mv;
            block33: {
                int iValue;
                block34: {
                    mv = context.getMv();
                    constant = expression.getValue();
                    if (!(constant instanceof Byte) && !(constant instanceof Short) && !(constant instanceof Integer)) break block33;
                    iValue = constant.intValue();
                    if (iValue > 5 || iValue < -1) break block34;
                    switch (iValue) {
                        case -1: {
                            mv.visitInsn(2);
                            break block35;
                        }
                        case 0: {
                            mv.visitInsn(3);
                            break block35;
                        }
                        case 1: {
                            mv.visitInsn(4);
                            break block35;
                        }
                        case 2: {
                            mv.visitInsn(5);
                            break block35;
                        }
                        case 3: {
                            mv.visitInsn(6);
                            break block35;
                        }
                        case 4: {
                            mv.visitInsn(7);
                            break block35;
                        }
                        case 5: {
                            mv.visitInsn(8);
                            break block35;
                        }
                        default: {
                            throw new IllegalArgumentException("Whoops");
                        }
                    }
                }
                if (iValue >= -128 && iValue <= 127) {
                    mv.visitIntInsn(16, iValue);
                } else if (iValue >= Short.MIN_VALUE && iValue <= Short.MAX_VALUE) {
                    mv.visitIntInsn(17, iValue);
                } else {
                    mv.visitLdcInsn((Object)constant);
                }
                break block35;
            }
            if (constant instanceof Long) {
                long lValue = constant.longValue();
                if (lValue == 0L) {
                    mv.visitInsn(9);
                } else if (lValue == 1L) {
                    mv.visitInsn(10);
                } else {
                    mv.visitLdcInsn((Object)constant);
                }
            } else if (constant instanceof Float) {
                Float fValue = (Float)constant;
                if (fValue.floatValue() == 0.0f && !fValue.toString().startsWith("-")) {
                    mv.visitInsn(11);
                } else if (fValue.floatValue() == 1.0f) {
                    mv.visitInsn(12);
                } else if (fValue.floatValue() == 2.0f) {
                    mv.visitInsn(13);
                } else {
                    mv.visitLdcInsn((Object)constant);
                }
            } else if (constant instanceof Double) {
                Double dValue = (Double)constant;
                if (dValue == 0.0 && !dValue.toString().startsWith("-")) {
                    mv.visitInsn(14);
                } else if (dValue == 1.0) {
                    mv.visitInsn(15);
                } else {
                    mv.visitLdcInsn((Object)constant);
                }
            } else {
                throw new IllegalStateException("Unexpected numeric literal type " + constant.getClass());
            }
        }
    }
}

