/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.compiler.bytecode.expression;

import gw.internal.ext.org.objectweb.asm.MethodVisitor;
import gw.internal.gosu.ir.compiler.bytecode.AbstractBytecodeCompiler;
import gw.internal.gosu.ir.compiler.bytecode.IRBytecodeCompiler;
import gw.internal.gosu.ir.compiler.bytecode.IRBytecodeContext;
import gw.lang.ir.IRType;
import gw.lang.ir.expression.IRPrimitiveTypeConversion;

public class IRPrimitiveTypeConversionCompiler
extends AbstractBytecodeCompiler {
    public static void compile(IRPrimitiveTypeConversion conversion, IRBytecodeContext context) {
        IRBytecodeCompiler.compileIRExpression(conversion.getRoot(), context);
        MethodVisitor mv = context.getMv();
        IRType from = conversion.getFromType();
        IRType to = conversion.getToType();
        if (IRPrimitiveTypeConversionCompiler.isIntType(from)) {
            if (to.isLong()) {
                mv.visitInsn(133);
            } else if (to.isByte()) {
                mv.visitInsn(145);
            } else if (to.isChar()) {
                mv.visitInsn(146);
            } else if (to.isShort()) {
                mv.visitInsn(147);
            } else if (to.isFloat()) {
                mv.visitInsn(134);
            } else if (to.isDouble()) {
                mv.visitInsn(135);
            }
        } else if (from.isLong()) {
            if (IRPrimitiveTypeConversionCompiler.isIntType(to)) {
                mv.visitInsn(136);
                IRPrimitiveTypeConversionCompiler.maybeConvertIntToByteCharShort(mv, to);
            } else if (to.isFloat()) {
                mv.visitInsn(137);
            } else if (to.isDouble()) {
                mv.visitInsn(138);
            }
        } else if (from.isFloat()) {
            if (IRPrimitiveTypeConversionCompiler.isIntType(to)) {
                mv.visitInsn(139);
                IRPrimitiveTypeConversionCompiler.maybeConvertIntToByteCharShort(mv, to);
            } else if (to.isLong()) {
                mv.visitInsn(140);
            } else if (to.isDouble()) {
                mv.visitInsn(141);
            }
        } else if (from.isDouble()) {
            if (IRPrimitiveTypeConversionCompiler.isIntType(to)) {
                mv.visitInsn(142);
                IRPrimitiveTypeConversionCompiler.maybeConvertIntToByteCharShort(mv, to);
            } else if (to.isLong()) {
                mv.visitInsn(143);
            } else if (to.isFloat()) {
                mv.visitInsn(144);
            }
        }
    }

    private static void maybeConvertIntToByteCharShort(MethodVisitor mv, IRType to) {
        if (to.isByte()) {
            mv.visitInsn(145);
        } else if (to.isChar()) {
            mv.visitInsn(146);
        } else if (to.isShort()) {
            mv.visitInsn(147);
        }
    }

    private static boolean isIntType(IRType type) {
        return type.isByte() || type.isShort() || type.isChar() || type.isInt();
    }
}

