/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.compiler.bytecode.expression;

import gw.internal.ext.org.objectweb.asm.Label;
import gw.internal.ext.org.objectweb.asm.MethodVisitor;
import gw.internal.gosu.ir.compiler.bytecode.AbstractBytecodeCompiler;
import gw.internal.gosu.ir.compiler.bytecode.IRBytecodeCompiler;
import gw.internal.gosu.ir.compiler.bytecode.IRBytecodeContext;
import gw.lang.ir.IRType;
import gw.lang.ir.expression.IRRelationalExpression;

public class IRRelationalExpressionCompiler
extends AbstractBytecodeCompiler {
    public static void compile(IRRelationalExpression expression, IRBytecodeContext context) {
        if (!expression.getLhs().getType().equals(expression.getRhs().getType())) {
            throw new IllegalStateException("Relational expression had one side as a " + expression.getLhs().getType().getName() + " and the other as a " + expression.getRhs().getType().getName());
        }
        IRBytecodeCompiler.compileIRExpression(expression.getLhs(), context);
        IRBytecodeCompiler.compileIRExpression(expression.getRhs(), context);
        MethodVisitor mv = context.getMv();
        Label trueLabel = new Label();
        IRType type = expression.getLhs().getType();
        IRRelationalExpression.Operation op = expression.getOp();
        if (type.isLong() || type.isDouble() || type.isFloat()) {
            if (op == IRRelationalExpression.Operation.LTE || op == IRRelationalExpression.Operation.LT) {
                mv.visitInsn(type.isDouble() ? 152 : (type.isFloat() ? 150 : 148));
            } else {
                mv.visitInsn(type.isDouble() ? 151 : (type.isFloat() ? 149 : 148));
            }
            if (op == IRRelationalExpression.Operation.LTE) {
                mv.visitJumpInsn(158, trueLabel);
            } else if (op == IRRelationalExpression.Operation.LT) {
                mv.visitJumpInsn(155, trueLabel);
            } else if (op == IRRelationalExpression.Operation.GTE) {
                mv.visitJumpInsn(156, trueLabel);
            } else {
                mv.visitJumpInsn(157, trueLabel);
            }
        } else if (op == IRRelationalExpression.Operation.LTE) {
            mv.visitJumpInsn(164, trueLabel);
        } else if (op == IRRelationalExpression.Operation.LT) {
            mv.visitJumpInsn(161, trueLabel);
        } else if (op == IRRelationalExpression.Operation.GTE) {
            mv.visitJumpInsn(162, trueLabel);
        } else {
            mv.visitJumpInsn(163, trueLabel);
        }
        mv.visitInsn(3);
        Label falseLabel = new Label();
        mv.visitJumpInsn(167, falseLabel);
        mv.visitLabel(trueLabel);
        mv.visitInsn(4);
        mv.visitLabel(falseLabel);
    }
}

