/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.compiler.bytecode.statement;

import gw.internal.ext.org.objectweb.asm.Label;
import gw.internal.ext.org.objectweb.asm.MethodVisitor;
import gw.internal.gosu.ir.compiler.bytecode.AbstractBytecodeCompiler;
import gw.internal.gosu.ir.compiler.bytecode.IRBytecodeContext;
import gw.lang.ir.IRElement;
import gw.lang.ir.IRStatement;
import gw.lang.ir.IRTypeConstants;
import gw.lang.ir.statement.IRCaseClause;
import gw.lang.ir.statement.IRSwitchStatement;
import java.util.ArrayList;
import java.util.List;

public class IRSwitchStatementCompiler
extends AbstractBytecodeCompiler {
    public static void compile(IRSwitchStatement statement, IRBytecodeContext context) {
        MethodVisitor mv = context.getMv();
        context.compile((IRElement)statement.getInit());
        Label endSwitchLabel = new Label();
        int iCaseMatchedIndex = context.makeTempVar(IRTypeConstants.pBOOLEAN()).getIndex();
        mv.visitInsn(3);
        mv.visitVarInsn(54, iCaseMatchedIndex);
        ArrayList<Label> caseBodyLabels = new ArrayList<Label>();
        List cases = statement.getCases();
        for (IRCaseClause caseClause : cases) {
            Label caseBodyLabel = new Label();
            caseBodyLabels.add(caseBodyLabel);
            context.compile((IRElement)caseClause.getCondition());
            mv.visitJumpInsn(154, caseBodyLabel);
        }
        Label defaultLabel = new Label();
        mv.visitJumpInsn(167, defaultLabel);
        for (int i = 0; i < cases.size(); ++i) {
            IRCaseClause caseClause = (IRCaseClause)cases.get(i);
            Label caseBodyLabel = (Label)caseBodyLabels.get(i);
            context.visitLabel(caseBodyLabel);
            IRSwitchStatementCompiler.compileCaseBody(endSwitchLabel, caseClause.getStatements(), context);
        }
        context.visitLabel(defaultLabel);
        IRSwitchStatementCompiler.compileCaseBody(endSwitchLabel, statement.getDefaultStatements(), context);
        context.visitLabel(endSwitchLabel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compileCaseBody(Label endSwitchLabel, List<IRStatement> statements, IRBytecodeContext context) {
        context.pushBreakLabel(endSwitchLabel);
        context.pushScope();
        try {
            for (IRStatement caseStatement : statements) {
                context.compile((IRElement)caseStatement);
            }
        }
        finally {
            context.popScope();
            context.popBreakLabel();
        }
    }
}

