/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.nodes;

import gw.internal.gosu.ir.nodes.GosuClassIRType;
import gw.internal.gosu.ir.nodes.IRFeatureBase;
import gw.internal.gosu.ir.nodes.IRMethod;
import gw.internal.gosu.ir.nodes.JavaClassIRType;
import gw.internal.gosu.ir.transform.util.AccessibilityUtil;
import gw.internal.gosu.ir.transform.util.IRTypeResolver;
import gw.internal.gosu.parser.ReducedParameterizedDynamicFunctionSymbol;
import gw.internal.gosu.parser.TypeLord;
import gw.lang.ir.IRType;
import gw.lang.parser.IReducedDynamicFunctionSymbol;
import gw.lang.parser.IReducedSymbol;
import gw.lang.reflect.IAspectMethodInfoDelegate;
import gw.lang.reflect.IAttributedFeatureInfo;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IMetaType;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IMethodInfoDelegate;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGenericTypeVariable;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuEnhancement;
import gw.lang.reflect.gs.IGosuMethodInfo;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaClassMethod;
import gw.lang.reflect.java.IJavaMethodInfo;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.java.JavaTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class IRMethodFromMethodInfo
extends IRFeatureBase
implements IRMethod {
    private IMethodInfo _originalMethod;
    private IMethodInfo _terminalMethod;
    private IFunctionType _functionType;

    public IRMethodFromMethodInfo(IMethodInfo originalMethod, IFunctionType functionType) {
        this._originalMethod = originalMethod;
        this._terminalMethod = originalMethod;
        while (this._terminalMethod instanceof IMethodInfoDelegate && !(this._terminalMethod instanceof IAspectMethodInfoDelegate)) {
            this._terminalMethod = ((IMethodInfoDelegate)this._terminalMethod).getSource();
        }
        this._functionType = functionType;
    }

    public IMethodInfo getOriginalMethod() {
        return this._originalMethod;
    }

    public IMethodInfo getTerminalMethod() {
        return this._terminalMethod;
    }

    @Override
    public IRType getReturnType() {
        return this.getBoundedReturnType(this._terminalMethod);
    }

    @Override
    public List<IRType> getExplicitParameterTypes() {
        return this.getBoundedParameterTypeDescriptors(this._terminalMethod);
    }

    @Override
    public List<IRType> getAllParameterTypes() {
        return this.getMethodDescriptor(this._terminalMethod);
    }

    @Override
    public String getName() {
        return this.getActualMethodName(this._terminalMethod);
    }

    @Override
    public IRType getOwningIRType() {
        return IRMethodFromMethodInfo.getTrueOwningType(this._terminalMethod);
    }

    @Override
    public IType getOwningIType() {
        IJavaClassMethod m;
        IType owningType = this._terminalMethod instanceof IJavaMethodInfo ? ((m = ((IJavaMethodInfo)this._terminalMethod).getMethod()) != null ? TypeSystem.get((IJavaClassInfo)m.getEnclosingClass()) : this._terminalMethod.getOwnersType()) : this._terminalMethod.getOwnersType();
        if (owningType instanceof IMetaType) {
            owningType = ((IMetaType)owningType).getType();
        }
        return owningType;
    }

    @Override
    public IRelativeTypeInfo.Accessibility getAccessibility() {
        return AccessibilityUtil.forFeatureInfo((IAttributedFeatureInfo)this._terminalMethod);
    }

    @Override
    public boolean isStatic() {
        return this._terminalMethod.isStatic();
    }

    @Override
    public IRType getTargetRootIRType() {
        IRType owner = this.getOwningIRType();
        if (owner instanceof GosuClassIRType && ((GosuClassIRType)owner).getType() instanceof IGosuEnhancement) {
            return IRTypeResolver.getDescriptor(((IGosuEnhancement)((GosuClassIRType)owner).getType()).getEnhancedType());
        }
        return owner;
    }

    @Override
    public IGenericTypeVariable[] getTypeVariables() {
        if (this._terminalMethod instanceof IGosuMethodInfo && !IGosuClass.ProxyUtil.isProxy((IType)this._terminalMethod.getOwnersType())) {
            return ((IGosuMethodInfo)this._terminalMethod).getTypeVariables();
        }
        return null;
    }

    @Override
    public IFunctionType getFunctionType() {
        return this._functionType;
    }

    @Override
    protected boolean isImplicitMethod() {
        return this.isGeneratedEnumMethod();
    }

    @Override
    public boolean isGeneratedEnumMethod() {
        return this.getOwningIType().isEnum() && this.isStatic() && (this.hasSignature("getAllValues", new IType[0]) || this.hasSignature("values", new IType[0]) || this.hasSignature("valueOf", new IType[]{JavaTypes.STRING()}));
    }

    private boolean hasSignature(String name, IType ... argTypes) {
        if (this.getName().equals(name) && this._originalMethod.getParameters().length == argTypes.length) {
            for (int i = 0; i < argTypes.length; ++i) {
                if (this._originalMethod.getParameters()[i].getFeatureType().equals(argTypes[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isBytecodeMethod() {
        return this._terminalMethod instanceof IGosuMethodInfo || this._terminalMethod instanceof IJavaMethodInfo;
    }

    private static IRType getTrueOwningType(IMethodInfo mi) {
        IJavaClassMethod m;
        if (mi instanceof IJavaMethodInfo && (m = ((IJavaMethodInfo)mi).getMethod()) != null) {
            return IRTypeResolver.getDescriptor(m.getEnclosingClass());
        }
        return IRTypeResolver.getDescriptor(mi.getOwnersType());
    }

    @Override
    public boolean couldHaveTypeVariables() {
        return this._terminalMethod instanceof IGosuMethodInfo && !IGosuClass.ProxyUtil.isProxy((IType)this._terminalMethod.getOwnersType());
    }

    private String getActualMethodName(IMethodInfo methodInfo) {
        if (methodInfo instanceof IJavaMethodInfo) {
            return ((IJavaMethodInfo)methodInfo).getMethod().getName();
        }
        return methodInfo.getDisplayName();
    }

    private IRType getBoundedReturnType(IMethodInfo mi) {
        if (mi instanceof IJavaMethodInfo) {
            return IRTypeResolver.getDescriptor(((IJavaMethodInfo)mi).getMethod().getReturnClassInfo());
        }
        if (mi instanceof IGosuMethodInfo) {
            IReducedDynamicFunctionSymbol dfs = ((IGosuMethodInfo)mi).getDfs();
            while (dfs instanceof ReducedParameterizedDynamicFunctionSymbol) {
                ReducedParameterizedDynamicFunctionSymbol pdfs = (ReducedParameterizedDynamicFunctionSymbol)dfs;
                dfs = pdfs.getBackingDfs();
            }
            if (IGosuClass.ProxyUtil.isProxy((IType)dfs.getGosuClass())) {
                return this.getBoundedReturnTypeFromProxiedClass(dfs);
            }
            return IRTypeResolver.getDescriptor(TypeLord.getDefaultParameterizedTypeWithTypeVars(dfs.getReturnType()));
        }
        return IRTypeResolver.getDescriptor(mi.getReturnType());
    }

    private IRType getBoundedReturnTypeFromProxiedClass(IReducedDynamicFunctionSymbol dfs) {
        IJavaClassMethod m = this.getJavaMethodFromProxy(dfs);
        return JavaClassIRType.get(m.getReturnClassInfo());
    }

    public List<IRType> getMethodDescriptor(IMethodInfo mi) {
        ArrayList<IRType> paramTypes = new ArrayList<IRType>();
        IFunctionType functionType = null;
        if (mi instanceof IGosuMethodInfo && !IGosuClass.ProxyUtil.isProxy((IType)mi.getOwnersType())) {
            functionType = (IFunctionType)((IGosuMethodInfo)mi).getDfs().getType();
        }
        this.addImplicitParameters(this.getOwningIType(), functionType, this.isStatic(), paramTypes);
        paramTypes.addAll(this.getBoundedParameterTypeDescriptors(mi));
        return paramTypes;
    }

    private List<IRType> getBoundedParameterTypeDescriptors(IMethodInfo mi) {
        if (mi.getParameters().length == 0) {
            return Collections.emptyList();
        }
        if (mi instanceof IJavaMethodInfo) {
            return IRTypeResolver.getDescriptors(((IJavaMethodInfo)mi).getMethod().getParameterTypes());
        }
        if (mi instanceof IGosuMethodInfo) {
            IReducedDynamicFunctionSymbol dfs = ((IGosuMethodInfo)mi).getDfs();
            while (dfs instanceof ReducedParameterizedDynamicFunctionSymbol) {
                ReducedParameterizedDynamicFunctionSymbol pdfs = (ReducedParameterizedDynamicFunctionSymbol)dfs;
                dfs = pdfs.getBackingDfs();
            }
            ArrayList<IRType> boundedTypes = new ArrayList<IRType>(dfs.getArgs().size());
            if (IGosuClass.ProxyUtil.isProxy((IType)dfs.getGosuClass())) {
                return this.getBoundedParamTypesFromProxiedClass(dfs);
            }
            for (int i = 0; i < dfs.getArgs().size(); ++i) {
                boundedTypes.add(IRTypeResolver.getDescriptor(TypeLord.getDefaultParameterizedTypeWithTypeVars(((IReducedSymbol)dfs.getArgs().get(i)).getType())));
            }
            return boundedTypes;
        }
        return this.getTypeDescriptors(mi.getParameters());
    }

    private List<IRType> getBoundedParamTypesFromProxiedClass(IReducedDynamicFunctionSymbol dfs) {
        IJavaClassMethod m = this.getJavaMethodFromProxy(dfs);
        IJavaClassInfo[] paramClasses = m.getParameterTypes();
        ArrayList<IRType> paramTypes = new ArrayList<IRType>(paramClasses.length);
        for (int i = 0; i < paramClasses.length; ++i) {
            paramTypes.add(JavaClassIRType.get(paramClasses[i]));
        }
        return paramTypes;
    }

    private IJavaClassMethod getJavaMethodFromProxy(IReducedDynamicFunctionSymbol dfs) {
        IGosuClass proxyType = dfs.getGosuClass();
        IJavaType javaType = (IJavaType)IGosuClass.ProxyUtil.getProxiedType((IType)proxyType);
        IType[] boundedDfsParams = new IType[dfs.getArgs().size()];
        for (int i = 0; i < boundedDfsParams.length; ++i) {
            IType param;
            boundedDfsParams[i] = param = ((IReducedSymbol)dfs.getArgs().get(i)).getType();
        }
        IJavaMethodInfo jmi = (IJavaMethodInfo)((IRelativeTypeInfo)javaType.getTypeInfo()).getMethod((IType)javaType, (CharSequence)dfs.getDisplayName(), boundedDfsParams);
        return jmi.getMethod();
    }
}

