/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform;

import gw.internal.gosu.ir.nodes.GosuClassIRType;
import gw.internal.gosu.ir.nodes.IRMethod;
import gw.internal.gosu.ir.nodes.IRMethodFactory;
import gw.internal.gosu.ir.nodes.JavaClassIRType;
import gw.internal.gosu.ir.transform.AbstractElementTransformer;
import gw.internal.gosu.ir.transform.FunctionStatementTransformer;
import gw.internal.gosu.ir.transform.GosuClassTransformationContext;
import gw.internal.gosu.ir.transform.statement.FieldInitializerTransformer;
import gw.internal.gosu.ir.transform.util.AccessibilityUtil;
import gw.internal.gosu.ir.transform.util.IRTypeResolver;
import gw.internal.gosu.ir.transform.util.NameResolver;
import gw.internal.gosu.parser.AbstractDynamicSymbol;
import gw.internal.gosu.parser.DynamicFunctionSymbol;
import gw.internal.gosu.parser.EnumCodePropertySymbol;
import gw.internal.gosu.parser.EnumDisplayNamePropertySymbol;
import gw.internal.gosu.parser.EnumNamePropertySymbol;
import gw.internal.gosu.parser.EnumValueOfFunctionSymbol;
import gw.internal.gosu.parser.EnumValuesFunctionSymbol;
import gw.internal.gosu.parser.GosuAnnotationInfo;
import gw.internal.gosu.parser.ICompilableTypeInternal;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.IGosuEnhancementInternal;
import gw.internal.gosu.parser.IGosuTemplateInternal;
import gw.internal.gosu.parser.IJavaTypeInternal;
import gw.internal.gosu.parser.MemberFieldSymbol;
import gw.internal.gosu.parser.ParameterizedDynamicFunctionSymbol;
import gw.internal.gosu.parser.RepeatableContainerAnnotationInfo;
import gw.internal.gosu.parser.Symbol;
import gw.internal.gosu.parser.TemplateRenderFunctionSymbol;
import gw.internal.gosu.parser.TypeLord;
import gw.internal.gosu.parser.java.classinfo.CompileTimeExpressionParser;
import gw.internal.gosu.parser.statements.ClassStatement;
import gw.internal.gosu.parser.statements.FunctionStatement;
import gw.internal.gosu.parser.statements.VarStatement;
import gw.internal.gosu.runtime.GosuRuntimeMethods;
import gw.lang.ir.IRAnnotation;
import gw.lang.ir.IRClass;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRStatement;
import gw.lang.ir.IRSymbol;
import gw.lang.ir.IRType;
import gw.lang.ir.IRTypeConstants;
import gw.lang.ir.expression.IRIdentifier;
import gw.lang.ir.expression.IRMethodCallExpression;
import gw.lang.ir.statement.IRAssignmentStatement;
import gw.lang.ir.statement.IRCatchClause;
import gw.lang.ir.statement.IRFieldDecl;
import gw.lang.ir.statement.IRMethodCallStatement;
import gw.lang.ir.statement.IRMethodStatement;
import gw.lang.ir.statement.IRNoOpStatement;
import gw.lang.ir.statement.IRReturnStatement;
import gw.lang.ir.statement.IRStatementList;
import gw.lang.ir.statement.IRTryCatchFinallyStatement;
import gw.lang.parser.ICapturedSymbol;
import gw.lang.parser.IDynamicFunctionSymbol;
import gw.lang.parser.IDynamicPropertySymbol;
import gw.lang.parser.IExpression;
import gw.lang.parser.IProgramClassFunctionSymbol;
import gw.lang.parser.IReducedDynamicFunctionSymbol;
import gw.lang.parser.IScriptPartId;
import gw.lang.parser.IStatement;
import gw.lang.parser.ISymbol;
import gw.lang.parser.Keyword;
import gw.lang.parser.expressions.IVarStatement;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IModifierInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.LazyTypeResolver;
import gw.lang.reflect.MethodList;
import gw.lang.reflect.Modifier;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.BytecodeOptions;
import gw.lang.reflect.gs.GosuClassPathThing;
import gw.lang.reflect.gs.GosuMarker;
import gw.lang.reflect.gs.IExternalSymbolMap;
import gw.lang.reflect.gs.IGenericTypeVariable;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuMethodInfo;
import gw.lang.reflect.gs.IGosuProgram;
import gw.lang.reflect.gs.IManagedProgramInstance;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaClassMethod;
import gw.lang.reflect.java.IJavaMethodInfo;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.java.JavaTypes;
import gw.util.GosuExceptionUtil;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GosuClassTransformer
extends AbstractElementTransformer<ClassStatement> {
    public static final String ENUM_VALUES_FIELD = "ENUM$VALUES";
    public static final String ENHANCED_TYPE_FIELD = "ENHANCED$TYPE";
    private IGosuClassInternal _gsClass;
    private EnumOrdinalCounter _enumCounter;
    private IRClass _irClass;
    private GosuClassTransformationContext _context;
    private boolean _bHasAsserts;
    Set<String> bridges = new HashSet<String>();

    public static IRClass compile(IGosuClassInternal gsClass) {
        GosuClassTransformer cc = new GosuClassTransformer(gsClass);
        return cc.compile();
    }

    private GosuClassTransformer(IGosuClassInternal gsClass) {
        super(null, (ClassStatement)gsClass.getClassStatement());
        this._gsClass = gsClass;
        this._enumCounter = new EnumOrdinalCounter();
        this._context = new GosuClassTransformationContext(this, this._gsClass);
        this.setCc(this._context);
    }

    private IRClass compile() {
        if (!this._gsClass.isValid() || !this._gsClass.isDefinitionsCompiled()) {
            throw GosuExceptionUtil.forceThrow((Throwable)this._gsClass.getParseResultsException());
        }
        this._irClass = new IRClass();
        this._cc().setIrClass(this._irClass);
        this.compileClassHeader();
        this.addSourceFileRef();
        this.compileInnerClasses();
        this.compileStaticInitializer();
        this.compileFields();
        this.compileConstructors();
        this.compileMethods();
        this.addAnnotations();
        return this._irClass;
    }

    private void addAnnotations() {
        List<IRAnnotation> annotations = this.getIRAnnotations(this._gsClass.getTypeInfo().getAnnotations());
        this._irClass.setAnnotations(annotations);
    }

    private void addGosuMarker(List<IRAnnotation> annotations) {
        annotations.add(new IRAnnotation(GosuClassTransformer.getDescriptor(GosuMarker.class), true));
    }

    private List<IRAnnotation> getIRAnnotations(List<? extends IAnnotationInfo> gosuAnnotations) {
        ArrayList<IRAnnotation> annotations = new ArrayList<IRAnnotation>();
        LinkedHashMap<IType, ArrayList<IAnnotationInfo>> repeats = new LinkedHashMap<IType, ArrayList<IAnnotationInfo>>();
        for (IAnnotationInfo iAnnotationInfo : gosuAnnotations) {
            if (iAnnotationInfo instanceof GosuAnnotationInfo) {
                GosuAnnotationInfo gai = (GosuAnnotationInfo)iAnnotationInfo;
                IType type = iAnnotationInfo.getType();
                if (!BytecodeOptions.isGenerateAnnotationsToClassFiles() || !gai.getRawAnnotation().shouldPersistToClass()) continue;
                IType container = gai.getRepeatableContainer();
                if (container == null) {
                    if (repeats.containsKey(iAnnotationInfo.getType())) continue;
                } else {
                    ArrayList<IAnnotationInfo> repeatedAnnos = (ArrayList<IAnnotationInfo>)repeats.get(container);
                    if (repeatedAnnos == null) {
                        repeatedAnnos = new ArrayList<IAnnotationInfo>();
                        repeats.put(container, repeatedAnnos);
                    }
                    repeatedAnnos.add(iAnnotationInfo);
                    continue;
                }
                repeats.put(iAnnotationInfo.getType(), null);
                annotations.add(new IRAnnotation(GosuClassTransformer.getDescriptor(type), gai.getRawAnnotation().shouldRetainAtRuntime(), iAnnotationInfo));
                continue;
            }
            IType type = iAnnotationInfo.getType();
            if (!BytecodeOptions.isGenerateAnnotationsToClassFiles() || repeats.containsKey(type) || !this.hasRetentionPolicy(iAnnotationInfo, RetentionPolicy.SOURCE)) continue;
            repeats.put(iAnnotationInfo.getType(), null);
            annotations.add(new IRAnnotation(GosuClassTransformer.getDescriptor(iAnnotationInfo.getType()), this.hasRetentionPolicy(iAnnotationInfo, RetentionPolicy.RUNTIME), iAnnotationInfo));
        }
        for (IType iType : repeats.keySet()) {
            List repeatedAnnos = (List)repeats.get(iType);
            if (repeatedAnnos == null) continue;
            RepeatableContainerAnnotationInfo repeatable = new RepeatableContainerAnnotationInfo(repeatedAnnos.toArray(new IAnnotationInfo[repeatedAnnos.size()]), iType, (IType)this.getGosuClass());
            annotations.add(new IRAnnotation(GosuClassTransformer.getDescriptor(iType), repeatable.retainInBytecode(), (IAnnotationInfo)repeatable));
        }
        return annotations;
    }

    private boolean hasRetentionPolicy(IAnnotationInfo annotation, RetentionPolicy policy) {
        List annotationsOfType = annotation.getType().getTypeInfo().getAnnotationsOfType(TypeSystem.get(Retention.class));
        for (IAnnotationInfo retention : annotationsOfType) {
            if (retention == null || !retention.getFieldValue("value").equals(policy.name())) continue;
            return true;
        }
        return false;
    }

    private void compileInnerClasses() {
        if (this._gsClass.getEnclosingType() != null) {
            IGosuClassInternal thisInnerClass = this._gsClass;
            this.visitInnerClass(thisInnerClass);
        }
        for (IGosuClass innerClass : this._gsClass.getInnerClasses()) {
            this.visitInnerClass(innerClass);
        }
    }

    private void visitInnerClass(IGosuClass innerClass) {
        this._irClass.addInnerClass(GosuClassTransformer.getDescriptor((IType)innerClass), GosuClassTransformer.getDescriptor((IType)innerClass.getEnclosingType()), this.getClassModifiers(innerClass, true));
    }

    private void compileStaticInitializer() {
        ArrayList<IRStatement> initStatements = new ArrayList<IRStatement>();
        IRMethodCallExpression bootstrapGosuWhenInitiatedViaClassfile = this.buildMethodCall(JavaClassIRType.get(GosuClassPathThing.class), "init", false, IRTypeConstants.pBOOLEAN(), Collections.emptyList(), null, Collections.emptyList());
        initStatements.add((IRStatement)new IRMethodCallStatement((IRExpression)bootstrapGosuWhenInitiatedViaClassfile));
        ArrayList<IRSymbol> syms = new ArrayList<IRSymbol>(1);
        if (this.isProgramOrEnclosedInProgram((IType)this.getGosuClass())) {
            IRSymbol symbolsParam = new IRSymbol("$symbols$", GosuClassTransformer.getDescriptor(IExternalSymbolMap.class), true);
            IRAssignmentStatement nullExternalSymbols = this.buildAssignment(symbolsParam, this.pushNull());
            initStatements.add((IRStatement)nullExternalSymbols);
            syms.add(symbolsParam);
        }
        this.setUpFunctionContext(false, syms);
        this.initializeStaticFields(initStatements);
        if (initStatements.size() > 0) {
            initStatements.add((IRStatement)new IRReturnStatement());
            IRMethodStatement clinit = new IRMethodStatement((IRStatement)new IRStatementList(false, initStatements), "<clinit>", 8, false, IRTypeConstants.pVOID(), Collections.emptyList());
            this._irClass.addMethod(clinit);
        }
    }

    private void compileFields() {
        this.addInstanceFields();
        this.addStaticFields();
        this.addOuterThisField();
        this.addCapturedSymbolFields();
        this.addTypeParamFields();
    }

    private void addInstanceFields() {
        for (IVarStatement field : this.getOrderedFields()) {
            IRFieldDecl fieldDecl = new IRFieldDecl(this.getModifiers((AbstractDynamicSymbol)field.getSymbol()), field.isInternal(), field.getIdentifierName(), GosuClassTransformer.getDescriptor(field.getType()), field.getType(), null);
            fieldDecl.setAnnotations(this.getIRAnnotations(this.makeAnnotationInfos(((VarStatement)field).getAnnotations(), (IFeatureInfo)this.getGosuClass().getTypeInfo())));
            this._irClass.addField(fieldDecl);
        }
        this.maybeAddEnhancedTypeMarkerField();
    }

    private void maybeAddEnhancedTypeMarkerField() {
        if (this.getGosuClass() instanceof IGosuEnhancementInternal) {
            int iModifiers = 4120;
            IRFieldDecl enhancedTypeMarkerField = new IRFieldDecl(iModifiers |= BytecodeOptions.isSingleServingLoader() ? 1 : 2, false, ENHANCED_TYPE_FIELD, IRTypeResolver.getDescriptor(((IGosuEnhancementInternal)this.getGosuClass()).getEnhancedType()), null);
            this._irClass.addField(enhancedTypeMarkerField);
        }
    }

    private void addStaticFields() {
        for (IVarStatement field : this._gsClass.getStaticFields()) {
            IRFieldDecl fieldDecl = new IRFieldDecl(this.getModifiers((Symbol)field.getSymbol()), field.isInternal(), field.getIdentifierName(), GosuClassTransformer.getDescriptor(field.getType()), field.getType(), null);
            fieldDecl.setAnnotations(this.getIRAnnotations(this.makeAnnotationInfos(((VarStatement)field).getAnnotations(), (IFeatureInfo)this.getGosuClass().getTypeInfo())));
            this._irClass.addField(fieldDecl);
        }
        if (this._gsClass.isEnum()) {
            int iModifiers = 4120;
            IRFieldDecl fieldDecl = new IRFieldDecl(iModifiers |= BytecodeOptions.isSingleServingLoader() ? 1 : 2, false, ENUM_VALUES_FIELD, GosuClassTransformer.getDescriptor(this._gsClass.getArrayType()), null);
            this._irClass.addField(fieldDecl);
        }
    }

    private void addOuterThisField() {
        if (this.isNonStaticInnerClass() && !this._gsClass.isInterface()) {
            int iModifiers = 4112;
            IRFieldDecl fieldDecl = new IRFieldDecl(iModifiers |= BytecodeOptions.isSingleServingLoader() ? 1 : 0, false, this.getOuterThisFieldName(), GosuClassTransformer.getDescriptor(GosuClassTransformer.getRuntimeEnclosingType((IType)this._gsClass)), null);
            this._irClass.addField(fieldDecl);
        }
    }

    private void addCapturedSymbolFields() {
        if (this._gsClass.isInterface()) {
            return;
        }
        Map<String, ICapturedSymbol> capturedSymbols = this._gsClass.getCapturedSymbols();
        if (capturedSymbols != null) {
            for (ICapturedSymbol sym : capturedSymbols.values()) {
                int iModifiers = 4112;
                IRFieldDecl fieldDecl = new IRFieldDecl(iModifiers |= BytecodeOptions.isSingleServingLoader() ? 1 : 2, false, "val$" + sym.getName(), GosuClassTransformer.getDescriptor(sym.getType().getArrayType()), null);
                this._irClass.addField(fieldDecl);
            }
        }
        if (GosuClassTransformer.requiresExternalSymbolCapture((IType)this._gsClass)) {
            int iModifiers = 4112;
            IRFieldDecl fieldDecl = new IRFieldDecl(iModifiers |= BytecodeOptions.isSingleServingLoader() ? 1 : 2, false, "$symbols$", GosuClassTransformer.getDescriptor(IExternalSymbolMap.class), null);
            this._irClass.addField(fieldDecl);
        }
    }

    private void addTypeParamFields() {
        IDynamicFunctionSymbol dfs;
        IGosuClassInternal gsClass = this._gsClass;
        if (gsClass.isGenericType() && !gsClass.isInterface()) {
            for (IGenericTypeVariable genTypeVar : gsClass.getGenericTypeVariables()) {
                int iModifiers = 4112;
                IRFieldDecl fieldDecl = new IRFieldDecl(iModifiers |= BytecodeOptions.isSingleServingLoader() ? 1 : 0, false, "typeparam$" + genTypeVar.getName(), GosuClassTransformer.getDescriptor(LazyTypeResolver.class), null);
                this._irClass.addField(fieldDecl);
            }
        }
        while (gsClass.isAnonymous() && (dfs = GosuClassTransformer.getEnclosingDFS(gsClass)) != null) {
            for (IGenericTypeVariable genTypeVar : GosuClassTransformer.getTypeVarsForDFS(dfs)) {
                int iModifiers = 4112;
                IRFieldDecl fieldDecl = new IRFieldDecl(iModifiers |= BytecodeOptions.isSingleServingLoader() ? 1 : 0, false, "typeparam$" + genTypeVar.getName(), GosuClassTransformer.getDescriptor(LazyTypeResolver.class), null);
                this._irClass.addField(fieldDecl);
            }
            gsClass = (IGosuClassInternal)dfs.getGosuClass();
        }
    }

    public boolean isNonStaticInnerClass() {
        return !this._gsClass.isStatic() && this._gsClass.getEnclosingType() != null;
    }

    public String getOuterThisFieldName() {
        return Keyword.KW_this + "$" + (this._gsClass.getDepth() - 1);
    }

    private void compileConstructors() {
        for (DynamicFunctionSymbol dfs : this._gsClass.getConstructorFunctions()) {
            IRStatement methodBody;
            int iModifiers = this.getModifiers(dfs);
            ArrayList<IRSymbol> parameters = new ArrayList<IRSymbol>();
            this.maybeGetOuterThisParamType(parameters);
            this.maybeGetCapturedSymbolTypes(parameters);
            this.maybeGetTypeVarSymbolTypesForConstructor(parameters);
            this.maybeGetEnumSuperConstructorSymbols(parameters);
            for (ISymbol param : dfs.getArgs()) {
                String name = param.getName();
                if (this.isBlockInvoke(dfs)) {
                    name = name + "$$blockParam";
                } else if (param.isValueBoxed()) {
                    name = name + "$$unboxedParam";
                }
                parameters.add(this.makeParamSymbol(param, name));
            }
            FunctionStatement stmt = dfs.getDeclFunctionStmt();
            if (stmt == null && !this._gsClass.isAnonymous()) {
                this.setUpFunctionContext(true, parameters);
                methodBody = this.compileDefaultCtorBody();
            } else {
                this.setUpFunctionContext(dfs, true, parameters);
                FunctionStatementTransformer funcStmtCompiler = new FunctionStatementTransformer(dfs, this._context);
                methodBody = funcStmtCompiler.compile();
            }
            IExpression annotationDefault = dfs.getAnnotationDefault();
            Object[] annotationDefaultValue = null;
            if (annotationDefault != null) {
                annotationDefaultValue = new Object[]{CompileTimeExpressionParser.convertValueToInfoFriendlyValue(annotationDefault.evaluate(), (IFeatureInfo)this.getGosuClass().getTypeInfo())};
            }
            IRMethodStatement methodStatement = new IRMethodStatement(methodBody, "<init>", iModifiers, dfs.isInternal(), IRTypeConstants.pVOID(), dfs.getReturnType(), parameters, dfs.getArgTypes(), dfs.getType(), annotationDefaultValue);
            methodStatement.setAnnotations(this.getIRAnnotations(this.makeAnnotationInfos(dfs.getModifierInfo().getAnnotations(), (IFeatureInfo)this.getGosuClass().getTypeInfo())));
            this._irClass.addMethod(methodStatement);
        }
    }

    private IRSymbol makeParamSymbol(ISymbol param, String name) {
        IRSymbol irSym = new IRSymbol(name, GosuClassTransformer.getDescriptor(param.getType()), false);
        IModifierInfo modifierInfo = param.getModifierInfo();
        if (modifierInfo != null && modifierInfo.getAnnotations() != null) {
            irSym.setAnnotations(this.getIRAnnotations(this.makeAnnotationInfos(modifierInfo.getAnnotations(), (IFeatureInfo)this.getGosuClass().getTypeInfo())));
        }
        return irSym;
    }

    private void maybeGetTypeVarSymbolTypesForConstructor(List<IRSymbol> parameters) {
        if (this._gsClass.isGenericType()) {
            this.addTypeParamDescriptor(parameters, Arrays.asList(this._gsClass.getGenericTypeVariables()));
        }
        this.appendTypeVarsFromEnclosingFunctions(parameters, this._gsClass);
    }

    private void maybeGetEnumSuperConstructorSymbols(List<IRSymbol> parameters) {
        if (this._gsClass.isEnum()) {
            parameters.add(new IRSymbol("enum$name", GosuClassTransformer.getDescriptor(String.class), false));
            parameters.add(new IRSymbol("enum$ordinal", GosuClassTransformer.getDescriptor(Integer.TYPE), false));
        }
    }

    private void maybeAddImplicitEnhancementParameters(DynamicFunctionSymbol dfs, List<IRSymbol> parameters) {
        if (this.isCompilingEnhancement() && !dfs.isStatic()) {
            parameters.add(new IRSymbol("$that$", GosuClassTransformer.getDescriptor(this.getGosuEnhancement().getEnhancedType()), false));
        }
    }

    private void maybeAddImplicitExternalSymbolsParameter(DynamicFunctionSymbol dfs, List<IRSymbol> parameters) {
        if ((this._cc().getGosuClass() instanceof IGosuProgram || dfs.isStatic() && this.isProgramOrEnclosedInProgram((IType)this._cc().getGosuClass())) && !(dfs instanceof IProgramClassFunctionSymbol) && !(dfs instanceof TemplateRenderFunctionSymbol) && !this.isOverrideForSuperClass(dfs)) {
            parameters.add(new IRSymbol("$symbols$", GosuClassTransformer.getDescriptor(IExternalSymbolMap.class), false));
        }
    }

    private boolean isOverrideForSuperClass(DynamicFunctionSymbol dfs) {
        DynamicFunctionSymbol superDfs = dfs.getSuperDfs();
        if (superDfs == null) {
            return false;
        }
        return !superDfs.getScriptPart().equals(dfs.getScriptPart());
    }

    private void maybeGetTypeVarSymbolTypes(DynamicFunctionSymbol dfs, List<IRSymbol> parameters) {
        this.addTypeParamDescriptor(parameters, GosuClassTransformer.getTypeVarsForDFS(dfs));
    }

    private void addTypeParamDescriptor(List<IRSymbol> parameters, List<IGenericTypeVariable> genTypeVars) {
        for (int i = 0; i < genTypeVars.size(); ++i) {
            parameters.add(new IRSymbol(this.getTypeVarParamName(genTypeVars.get(i)), GosuClassTransformer.getDescriptor(LazyTypeResolver.class), false));
        }
    }

    private void appendTypeVarsFromEnclosingFunctions(List<IRSymbol> parameters, IGosuClassInternal gsClass) {
        IDynamicFunctionSymbol dfs;
        while (gsClass.isAnonymous() && (dfs = GosuClassTransformer.getEnclosingDFS(gsClass)) != null) {
            this.addTypeParamDescriptor(parameters, GosuClassTransformer.getTypeVarsForDFS(dfs));
            gsClass = (IGosuClassInternal)dfs.getGosuClass();
        }
    }

    private void maybeGetCapturedSymbolTypes(List<IRSymbol> parameters) {
        Map<String, ICapturedSymbol> capturedSymbols = this._gsClass.getCapturedSymbols();
        if (capturedSymbols != null) {
            for (ICapturedSymbol sym : capturedSymbols.values()) {
                parameters.add(new IRSymbol(this.getCapturedSymbolParameterName(sym), GosuClassTransformer.getDescriptor(sym.getType().getArrayType()), false));
            }
        }
        if (GosuClassTransformer.requiresExternalSymbolCapture((IType)this._gsClass)) {
            parameters.add(new IRSymbol("$symbols$arg", GosuClassTransformer.getDescriptor(IExternalSymbolMap.class), true));
        }
    }

    private void maybeGetOuterThisParamType(List<IRSymbol> parameters) {
        if (this.isNonStaticInnerClass()) {
            IType enclosingType = GosuClassTransformer.getRuntimeEnclosingType((IType)this._gsClass);
            parameters.add(new IRSymbol(this._context.getOuterThisParamName(), GosuClassTransformer.getDescriptor(enclosingType), false));
        }
    }

    private IRStatement compileDefaultCtorBody() {
        ArrayList<IRStatement> statements = new ArrayList<IRStatement>();
        this.maybeAssignOuterRef(statements);
        this.initCapturedSymbolFields(statements);
        this.initTypeVarFields(statements);
        ArrayList<IRExpression> superArgs = new ArrayList<IRExpression>();
        this.maybePushSupersEnclosingThisRef(superArgs);
        this.pushCapturedSymbols(this._cc().getSuperType(), superArgs, false);
        int iTypeParams = this.pushTypeParametersForConstructor(null, this._cc().getSuperType(), superArgs, true);
        this.pushEnumSuperConstructorArguments(superArgs);
        IType[] superParameterTypes = IType.EMPTY_ARRAY;
        if (this._gsClass.isEnum()) {
            superParameterTypes = new IType[]{JavaTypes.STRING(), JavaTypes.pINT()};
        }
        IRType[] params = this.getConstructorParamTypes(superParameterTypes, iTypeParams, this._cc().getSuperType());
        IRMethod irMethod = IRMethodFactory.createConstructorIRMethod(this._cc().getSuperType(), params);
        statements.add((IRStatement)new IRMethodCallStatement(this.callSpecialMethod(GosuClassTransformer.getDescriptor(this._cc().getSuperType()), irMethod, this.pushThis(), superArgs)));
        this.initializeInstanceFields(statements);
        statements.add((IRStatement)new IRReturnStatement());
        return new IRStatementList(false, statements);
    }

    public void maybeAssignOuterRef(List<IRStatement> statements) {
        if (this.isNonStaticInnerClass()) {
            statements.add(this.setInstanceField((IType)this._gsClass, this.getOuterThisFieldName(), GosuClassTransformer.getDescriptor(GosuClassTransformer.getRuntimeEnclosingType((IType)this._gsClass)), AccessibilityUtil.forOuter(), this.pushThis(), (IRExpression)this.identifier(this._context.getSymbol(this._context.getOuterThisParamName()))));
        }
    }

    public void maybePushSupersEnclosingThisRef(List<IRExpression> arguments) {
        IType superType = this._gsClass.getSupertype();
        if (GosuClassTransformer.isNonStaticInnerClass(superType)) {
            IGosuClass typeToPass = (IGosuClass)superType.getEnclosingType();
            ICompilableTypeInternal outerType = this._gsClass.getEnclosingType();
            if (outerType == typeToPass || typeToPass != null && outerType != null && typeToPass.isAssignableFrom((IType)outerType)) {
                arguments.add((IRExpression)this.identifier(this._context.getSymbol(this._context.getOuterThisParamName())));
            } else {
                arguments.add(this.pushOuter((IType)typeToPass));
            }
        }
    }

    private void compileMethods() {
        for (IDynamicFunctionSymbol iDynamicFunctionSymbol : this._gsClass.getStaticFunctions()) {
            this.compileMethod((DynamicFunctionSymbol)iDynamicFunctionSymbol);
        }
        LinkedHashSet methodSet = new LinkedHashSet(this._gsClass.getMemberFunctions());
        for (IDynamicFunctionSymbol idfs : methodSet) {
            this.compileMethod((DynamicFunctionSymbol)idfs);
            if (idfs.isAbstract()) continue;
            this.compileBridgeMethods((DynamicFunctionSymbol)idfs);
        }
        if (!(this._gsClass.isInterface() || this.isCompilingEnhancement() || this._cc().compilingBlock())) {
            this.compileIntrinsicTypePropertyGetter();
        }
        if (this._gsClass.isEnum()) {
            this.compileEnumValuesMethod();
            this.compileEnumAllValuesPropertyGetter();
            this.compileEnumValueOfMethod();
            this.compileEnumValuePropertyGetter();
            this.compileEnumCodePropertyGetter();
            this.compileEnumOrdinalPropertyGetter();
            this.compileEnumDisplayNamePropertyGetter();
            this.compileEnumNamePropertyGetter();
        }
        if (this.isNonStaticInnerClass() && !this._gsClass.isInterface()) {
            this.compileOuterAccessMethod();
        }
        this.compileMainMethod();
    }

    private void compileBridgeMethods(DynamicFunctionSymbol dfs) {
        List<DynamicFunctionSymbol> list = this.maybeGetSuperDfs(dfs);
        if (list.isEmpty()) {
            if (dfs.isOverride()) {
                dfs = dfs.getSuperDfs();
                this.compileBridgeMethods(dfs);
            }
            return;
        }
        for (DynamicFunctionSymbol superDfs : list) {
            while (superDfs instanceof ParameterizedDynamicFunctionSymbol) {
                superDfs = ((ParameterizedDynamicFunctionSymbol)superDfs).getBackingDfs();
            }
            if (this.genProxyCovariantBridgeMethod(dfs, superDfs)) continue;
            IRType superRetDescriptor = this.getDescriptorNoStructures(superDfs.getReturnType());
            IRType overrideRetDescriptor = this.getDescriptorNoStructures(dfs.getReturnType());
            String superParamDescriptors = this.getParameterDescriptors(superDfs.getArgTypes());
            String overrideParamDescriptors = this.getParameterDescriptors(dfs.getArgTypes());
            if (!superRetDescriptor.equals(overrideRetDescriptor) || !overrideParamDescriptors.equals(superParamDescriptors)) {
                ArrayList<IRSymbol> parameters = new ArrayList<IRSymbol>();
                this.maybeGetTypeVarSymbolTypes(superDfs, parameters);
                for (ISymbol arg : superDfs.getArgs()) {
                    parameters.add(new IRSymbol(arg.getName(), GosuClassTransformer.getDescriptor(arg.getType()), false));
                }
                this.setUpFunctionContext(superDfs, true, parameters);
                ArrayList<IRExpression> methodCallArgs = new ArrayList<IRExpression>();
                this.maybePassTypeParams(dfs, methodCallArgs);
                for (int i = 0; i < dfs.getArgs().size(); ++i) {
                    ISymbol dfsArg = dfs.getArgs().get(i);
                    ISymbol superDfsArg = superDfs.getArgs().get(i);
                    IRIdentifier arg = this.identifier(this._context.getSymbol(superDfsArg.getName()));
                    IRType expectedType = GosuClassTransformer.getDescriptor(dfsArg.getType());
                    if (!expectedType.isAssignableFrom(arg.getType())) {
                        arg = this.buildCast(expectedType, (IRExpression)arg);
                    }
                    methodCallArgs.add((IRExpression)arg);
                }
                IRMethod irMethod = IRMethodFactory.createIRMethod((IType)this._gsClass, NameResolver.getFunctionName(dfs), dfs.getReturnType(), this.getParamsIncludingTypeParams(dfs), AccessibilityUtil.forSymbol(dfs), false);
                IRExpression methodCall = this.callMethod(irMethod, this.pushThis(), methodCallArgs);
                Object methodBody = superDfs.getReturnType() != JavaTypes.pVOID() ? new IRReturnStatement(null, methodCall) : new IRStatementList(false, new IRStatement[]{new IRMethodCallStatement(methodCall), new IRReturnStatement()});
                IRMethodStatement bridgeMethod = new IRMethodStatement((IRStatement)methodBody, NameResolver.getFunctionName(superDfs), this.makeModifiersForBridgeMethod(this.getModifiers(dfs)), dfs.isInternal(), superRetDescriptor, parameters);
                if (!this.bridges.contains(bridgeMethod.signature())) {
                    this._irClass.addMethod(bridgeMethod);
                    this.bridges.add(bridgeMethod.signature());
                }
            } else {
                IGosuClassInternal gsProxyClass = superDfs.getGosuClass();
                if (gsProxyClass != null && gsProxyClass.isProxy() && this.addCovarientProxyBridgeMethods(superDfs)) continue;
            }
            this.compileBridgeMethods(superDfs);
        }
    }

    private List<DynamicFunctionSymbol> maybeGetSuperDfs(DynamicFunctionSymbol dfs) {
        IType[] interfaces;
        DynamicFunctionSymbol superDfs;
        IType superType;
        IScriptPartId scriptPart = dfs.getScriptPart();
        if (scriptPart == null) {
            return Collections.emptyList();
        }
        IType gsClass = scriptPart.getContainingType();
        if (gsClass == null) {
            return Collections.emptyList();
        }
        boolean bProxy = IGosuClass.ProxyUtil.isProxy((IType)gsClass);
        ArrayList<DynamicFunctionSymbol> list = new ArrayList<DynamicFunctionSymbol>(2);
        HashSet<IType> set = new HashSet<IType>();
        IType iType = superType = bProxy ? ((IGosuClass)gsClass).getJavaType().getSupertype() : gsClass.getSupertype();
        if (superType != null && (superDfs = this.getSuperDfs(dfs, gsClass, superType)) != null && !set.contains(superDfs.getReturnType())) {
            list.add(superDfs);
            set.add(superDfs.getReturnType());
        }
        IType[] iTypeArray = interfaces = bProxy ? ((IGosuClass)gsClass).getJavaType().getInterfaces() : gsClass.getInterfaces();
        if (interfaces != null) {
            for (IType iface : interfaces) {
                DynamicFunctionSymbol superDfs2 = this.getSuperDfs(dfs, gsClass, iface);
                if (superDfs2 == null || set.contains(superDfs2.getReturnType())) continue;
                list.add(superDfs2);
                set.add(superDfs2.getReturnType());
            }
        }
        return list;
    }

    private DynamicFunctionSymbol getSuperDfs(DynamicFunctionSymbol dfs, IType gsClass, IType superType) {
        IGosuClassInternal gosuSuperType;
        if (superType instanceof IJavaType) {
            gosuSuperType = IGosuClassInternal.Util.getGosuClassFrom(superType);
            if (gosuSuperType == null) {
                return null;
            }
        } else if (superType instanceof IGosuClass) {
            gosuSuperType = (IGosuClassInternal)superType;
        } else {
            return null;
        }
        gosuSuperType.isValid();
        DynamicFunctionSymbol superDfs = gosuSuperType.getParseInfo().getMemberFunctions().get(dfs.getName());
        if (superDfs != null) {
            return superDfs;
        }
        MethodList methods = gosuSuperType.getTypeInfo().getMethods(gsClass);
        for (IMethodInfo mi : methods) {
            IReducedDynamicFunctionSymbol csr;
            if (!(mi instanceof IGosuMethodInfo) || !(csr = ((IGosuMethodInfo)mi).getDfs()).getName().equals(dfs.getName()) || csr.getBackingDfs() == null) continue;
            csr = csr.getBackingDfs();
            superDfs = gosuSuperType.getParseInfo().getMemberFunctions().get(csr.getName());
            if (superDfs == null) {
                IScriptPartId scriptPart = csr.getScriptPart();
                IGosuClassInternal iGosuClassInternal = gosuSuperType = scriptPart != null ? (IGosuClassInternal)scriptPart.getContainingType() : null;
                if (gosuSuperType != null) {
                    superDfs = gosuSuperType.getParseInfo().getMemberFunctions().get(csr.getName());
                }
            }
            return superDfs;
        }
        return null;
    }

    private int makeModifiersForBridgeMethod(int modifiers) {
        return (modifiers | 0x40 | 0x1000) & 0xFFFFFBFF;
    }

    private boolean addCovarientProxyBridgeMethods(DynamicFunctionSymbol dfs) {
        IJavaClassMethod m;
        IGosuClassInternal gsProxyClass = dfs.getGosuClass();
        if (gsProxyClass == null || !gsProxyClass.isProxy()) {
            return false;
        }
        if (dfs.getReturnType().isPrimitive()) {
            return false;
        }
        IJavaTypeInternal javaType = (IJavaTypeInternal)gsProxyClass.getJavaType();
        if (javaType.isInterface() && (m = this.getMethodOverridableFromDfs(dfs, javaType.getBackingClassInfo())) != null && Modifier.isAbstract((int)m.getModifiers())) {
            return this.genInterfaceProxyBridgeMethod(m, javaType.getBackingClassInfo());
        }
        return false;
    }

    private IJavaClassMethod getMethodOverridableFromDfs(DynamicFunctionSymbol dfs, IJavaClassInfo declaringClass) {
        String strName = dfs.getDisplayName();
        IJavaClassMethod m = null;
        if (strName.startsWith("@")) {
            strName = strName.substring(1);
            try {
                m = declaringClass.getDeclaredMethod("get" + strName, this.getClassInfos(dfs.getArgTypes()));
            }
            catch (NoSuchMethodException e) {
                try {
                    m = declaringClass.getDeclaredMethod("is" + strName, this.getClassInfos(dfs.getArgTypes()));
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
        } else {
            try {
                m = declaringClass.getDeclaredMethod(strName, this.getClassInfos(dfs.getArgTypes()));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return m;
    }

    private boolean genInterfaceProxyBridgeMethod(IJavaClassMethod m, IJavaClassInfo iJavaClassInfo) {
        boolean bRet = false;
        for (IJavaClassInfo iface : iJavaClassInfo.getInterfaces()) {
            try {
                IJavaClassMethod bridge = iface.getDeclaredMethod(m.getName(), m.getParameterTypes());
                if (!bridge.getReturnType().equals(m.getReturnType())) {
                    bRet = this.genBridgeMethod(bridge, m) || bRet;
                    m = bridge;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            bRet = this.genInterfaceProxyBridgeMethod(m, iface) || bRet;
        }
        return bRet;
    }

    private boolean genBridgeMethod(IJavaClassMethod bridge, IJavaClassMethod m) {
        IRType superRetDescriptor = GosuClassTransformer.getDescriptor(bridge.getReturnType());
        IRType overrideRetDescriptor = GosuClassTransformer.getDescriptor(m.getReturnType());
        String superParamDescriptors = this.getParameterDescriptors(bridge.getParameterTypes());
        String overrideParamDescriptors = this.getParameterDescriptors(m.getParameterTypes());
        if (!superRetDescriptor.equals(overrideRetDescriptor) || !overrideParamDescriptors.equals(superParamDescriptors)) {
            ArrayList<IRSymbol> parameters = new ArrayList<IRSymbol>();
            for (IJavaClassInfo param : bridge.getParameterTypes()) {
                parameters.add(new IRSymbol(param.getName(), GosuClassTransformer.getDescriptor(param), false));
            }
            this.setUpFunctionContext(true, parameters);
            ArrayList<IRExpression> methodCallArgs = new ArrayList<IRExpression>();
            IJavaClassInfo[] params = m.getParameterTypes();
            for (int i = 0; i < params.length; ++i) {
                IJavaClassInfo param;
                param = params[i];
                IJavaClassInfo superParam = bridge.getParameterTypes()[i];
                IRIdentifier arg = this.identifier(this._context.getSymbol(superParam.getName()));
                IRType expectedType = GosuClassTransformer.getDescriptor(param);
                if (!expectedType.isAssignableFrom(arg.getType())) {
                    arg = this.buildCast(expectedType, (IRExpression)arg);
                }
                methodCallArgs.add((IRExpression)arg);
            }
            IRMethod irMethod = IRMethodFactory.createIRMethod((IType)this._gsClass, m.getName(), GosuClassTransformer.getDescriptor(m.getReturnType()), GosuClassTransformer.getIRTypes(m.getParameterTypes()), IRelativeTypeInfo.Accessibility.fromModifiers((int)m.getModifiers()), false);
            IRExpression methodCall = this.callMethod(irMethod, this.pushThis(), methodCallArgs);
            IRReturnStatement methodBody = new IRReturnStatement(null, methodCall);
            IRMethodStatement bridgeMethod = new IRMethodStatement((IRStatement)methodBody, bridge.getName(), this.makeModifiersForBridgeMethod(m.getModifiers()), Modifier.isInternal((int)m.getModifiers()), superRetDescriptor, parameters);
            if (!this.bridges.contains(bridgeMethod.signature())) {
                this._irClass.addMethod(bridgeMethod);
                this.bridges.add(bridgeMethod.signature());
            }
            return true;
        }
        return false;
    }

    private boolean genProxyCovariantBridgeMethod(DynamicFunctionSymbol dfs, DynamicFunctionSymbol superDfs) {
        IGosuClassInternal superType = (IGosuClassInternal)superDfs.getScriptPart().getContainingType();
        if (superType.isProxy()) {
            String superReturnClassName;
            String returnClassName;
            IJavaType javaType = superType.getJavaType();
            javaType = (IJavaType)TypeLord.getDefaultParameterizedType((IType)javaType);
            IType[] dfsArgTypes = dfs.getArgTypes();
            IType[] defDfsArgTypes = new IType[dfsArgTypes.length];
            for (int i = 0; i < dfsArgTypes.length; ++i) {
                defDfsArgTypes[i] = TypeLord.getDefaultParameterizedTypeWithTypeVars(dfsArgTypes[i]);
            }
            IJavaMethodInfo mi = (IJavaMethodInfo)((IRelativeTypeInfo)javaType.getTypeInfo()).getMethod((IType)javaType, (CharSequence)NameResolver.getFunctionName(dfs), defDfsArgTypes);
            if (mi == null) {
                return false;
            }
            IJavaClassMethod method = mi.getMethod();
            IJavaClassInfo[] paramClasses = method.getParameterTypes();
            for (int i = 0; i < paramClasses.length; ++i) {
                String dfsParamClass;
                if (AbstractElementTransformer.isBytecodeType(defDfsArgTypes[i]) || (dfsParamClass = GosuClassTransformer.getDescriptor(defDfsArgTypes[i]).getName().replace('$', '.')).equals(paramClasses[i].getName().replace('$', '.'))) continue;
                this.makeCovariantParamBridgeMethod(dfs, superDfs, method);
                return true;
            }
            if (!AbstractElementTransformer.isBytecodeType(superDfs.getReturnType()) && !(returnClassName = GosuClassTransformer.getDescriptor(method.getReturnClassInfo()).getName()).equals(superReturnClassName = GosuClassTransformer.getDescriptor(superDfs.getReturnType()).getName())) {
                this.makeCovariantParamBridgeMethod(dfs, superDfs, method);
                return true;
            }
        }
        return false;
    }

    private void makeCovariantParamBridgeMethod(DynamicFunctionSymbol dfs, DynamicFunctionSymbol superDfs, IJavaClassMethod method) {
        IJavaClassInfo[] paramTypes = method.getParameterTypes();
        IType[] chainedMethodParams = this.getParamsIncludingTypeParams(dfs);
        ArrayList<IRSymbol> parameters = new ArrayList<IRSymbol>();
        for (int i = 0; i < paramTypes.length; ++i) {
            parameters.add(new IRSymbol("arg" + i, GosuClassTransformer.getDescriptor(paramTypes[i]), false));
        }
        this.setUpFunctionContext(superDfs, true, parameters);
        ArrayList<IRExpression> args = new ArrayList<IRExpression>();
        for (int i = 0; i < parameters.size(); ++i) {
            IRIdentifier arg = this.identifier((IRSymbol)parameters.get(i));
            IRType chainedParamType = GosuClassTransformer.getDescriptor(chainedMethodParams[i]);
            if (!chainedParamType.isAssignableFrom(arg.getType())) {
                arg = this.buildCast(chainedParamType, (IRExpression)arg);
            }
            args.add((IRExpression)arg);
        }
        IRMethod irMethod = IRMethodFactory.createIRMethod((IType)this._gsClass, NameResolver.getFunctionName(dfs), dfs.getReturnType(), chainedMethodParams, AccessibilityUtil.forSymbol(dfs), false);
        IRExpression methodCall = this.callMethod(irMethod, this.pushThis(), args);
        IRStatementList methodBody = new IRStatementList(true, new IRStatement[0]);
        if (!method.getReturnType().getName().equals(Void.TYPE.getName())) {
            methodBody.addStatement((IRStatement)new IRReturnStatement(null, methodCall));
        } else {
            methodBody.addStatement((IRStatement)this.buildMethodCall(methodCall));
            methodBody.addStatement(this.buildReturn());
        }
        IRMethodStatement bridgeMethod = new IRMethodStatement((IRStatement)methodBody, method.getName(), this.makeModifiersForBridgeMethod(this.getModifiers(dfs)), dfs.isInternal(), GosuClassTransformer.getDescriptor(method.getReturnClassInfo()), parameters);
        if (!this.bridges.contains(bridgeMethod.signature())) {
            this._irClass.addMethod(bridgeMethod);
            this.bridges.add(bridgeMethod.signature());
        }
    }

    private IType[] getParamsIncludingTypeParams(DynamicFunctionSymbol dfs) {
        List<IGenericTypeVariable> typeVars = GosuClassTransformer.getTypeVarsForDFS(dfs);
        IType[] argTypes = dfs.getArgTypes();
        IType[] paramTypes = new IType[typeVars.size() + argTypes.length];
        System.arraycopy(argTypes, 0, paramTypes, typeVars.size(), argTypes.length);
        for (int i = 0; i < typeVars.size(); ++i) {
            paramTypes[i] = TypeSystem.get(LazyTypeResolver.class);
        }
        return paramTypes;
    }

    private void maybePassTypeParams(DynamicFunctionSymbol dfs, List<IRExpression> args) {
        IType type = dfs.getType();
        if (type.isGenericType()) {
            IGenericTypeVariable[] typeVars = type.getGenericTypeVariables();
            for (int i = 0; i < typeVars.length; ++i) {
                args.add((IRExpression)this.identifier(this._context.getSymbol(this.getTypeVarParamName(typeVars[i]))));
            }
        }
    }

    private void compileOuterAccessMethod() {
        int iModifiers = 4104;
        int n = BytecodeOptions.isSingleServingLoader() ? 1 : 0;
        IRSymbol staticThis = new IRSymbol("staticThis", GosuClassTransformer.getDescriptor((IType)this._gsClass), false);
        this.setUpFunctionContext(false, Collections.singletonList(staticThis));
        IRReturnStatement body = new IRReturnStatement(null, this.getInstanceField((IType)this._gsClass, this.getOuterThisFieldName(), GosuClassTransformer.getDescriptor(GosuClassTransformer.getRuntimeEnclosingType((IType)this._gsClass)), AccessibilityUtil.forOuter(), (IRExpression)this.identifier(staticThis)));
        this._irClass.addMethod(new IRMethodStatement((IRStatement)body, "access$0", iModifiers |= n, false, GosuClassTransformer.getDescriptor(GosuClassTransformer.getRuntimeEnclosingType((IType)this._gsClass)), Collections.singletonList(staticThis)));
    }

    private void compileMethod(DynamicFunctionSymbol dfs) {
        IRNoOpStatement methodBody;
        if (this.isGosuObjectMethod(dfs) || this.isStaticEnumMethod(dfs)) {
            return;
        }
        if (!(dfs instanceof TemplateRenderFunctionSymbol) && this.getGosuClass() instanceof IGosuTemplateInternal) {
            return;
        }
        ArrayList<IRSymbol> parameters = new ArrayList<IRSymbol>();
        this.maybeAddImplicitEnhancementParameters(dfs, parameters);
        this.maybeGetTypeVarSymbolTypes(dfs, parameters);
        this.maybeAddImplicitExternalSymbolsParameter(dfs, parameters);
        for (ISymbol param : dfs.getArgs()) {
            String name = param.getName();
            if (this.isBlockInvoke(dfs)) {
                name = name + "$$blockParam";
            } else if (param.isValueBoxed()) {
                name = name + "$$unboxedParam";
            }
            if (param.getName().equals("p0") && param.getType().equals(JavaTypes.IEXTERNAL_SYMBOL_MAP())) {
                name = "$symbols$";
            }
            parameters.add(this.makeParamSymbol(param, name));
        }
        if (!dfs.isAbstract()) {
            IStatement stmt = (IStatement)dfs.getValueDirectly();
            if (stmt != null) {
                this.setUpFunctionContext(dfs, !dfs.isStatic() && !this.isCompilingEnhancement(), parameters);
                FunctionStatementTransformer funcStmtCompiler = new FunctionStatementTransformer(dfs, this._context);
                methodBody = funcStmtCompiler.compile();
                methodBody = this.maybeWrapProgramEvaluateForManangedProgram(dfs, (IRStatement)methodBody);
            } else {
                methodBody = new IRNoOpStatement();
            }
        } else {
            methodBody = null;
        }
        IExpression annotationDefault = dfs.getAnnotationDefault();
        Object[] annotationDefaultValue = null;
        if (annotationDefault != null) {
            annotationDefaultValue = new Object[]{CompileTimeExpressionParser.convertValueToInfoFriendlyValue(annotationDefault.evaluate(), (IFeatureInfo)this.getGosuClass().getTypeInfo())};
        }
        IRMethodStatement method = new IRMethodStatement((IRStatement)methodBody, NameResolver.getFunctionName(dfs), this.getModifiers(dfs), dfs.isInternal(), GosuClassTransformer.getDescriptor(dfs.getReturnType()), dfs.getReturnType(), parameters, dfs.getArgTypes(), dfs.getType(), annotationDefaultValue);
        method.setAnnotations(this.getIRAnnotations(this.makeAnnotationInfos(dfs.getModifierInfo().getAnnotations(), (IFeatureInfo)this.getGosuClass().getTypeInfo())));
        this._irClass.addMethod(method);
    }

    private IRStatement maybeWrapProgramEvaluateForManangedProgram(DynamicFunctionSymbol dfs, IRStatement methodBody) {
        IType declaringType;
        IType[] argTypes;
        if (dfs.getDisplayName().equals("evaluate") && (argTypes = dfs.getArgTypes()).length == 1 && argTypes[0] == JavaTypes.IEXTERNAL_SYMBOL_MAP() && (declaringType = dfs.getDeclaringTypeInfo().getOwnersType()) instanceof IGosuProgram && TypeSystem.get(IManagedProgramInstance.class).isAssignableFrom(declaringType)) {
            IRSymbol exceptionId = new IRSymbol("$failure", GosuClassTransformer.getDescriptor(Throwable.class), true);
            this._cc().putSymbol(exceptionId);
            IRAssignmentStatement exceptionIdInit = this.buildAssignment(exceptionId, this.pushNull());
            methodBody = new IRStatementList(true, new IRStatement[]{exceptionIdInit, this.buildIf((IRExpression)this.buildMethodCall(IManagedProgramInstance.class, "beforeExecution", Boolean.TYPE, new Class[0], this.pushThis(), Collections.emptyList()), (IRStatement)new IRTryCatchFinallyStatement(methodBody, Collections.singletonList(new IRCatchClause(exceptionId, (IRStatement)new IRNoOpStatement())), (IRStatement)this.buildMethodCall((IRExpression)this.buildMethodCall(IManagedProgramInstance.class, "afterExecution", Void.TYPE, new Class[]{Throwable.class}, this.pushThis(), Collections.singletonList(this.identifier(exceptionId)))))), new IRReturnStatement(null, this.nullLiteral())});
        }
        return methodBody;
    }

    private boolean isStaticEnumMethod(DynamicFunctionSymbol dfs) {
        return this.getGosuClass().isEnum() && (dfs instanceof EnumValueOfFunctionSymbol || dfs instanceof EnumValuesFunctionSymbol);
    }

    private boolean isGosuObjectMethod(DynamicFunctionSymbol dfs) {
        return dfs.getScriptPart() != null && dfs.getScriptPart().getContainingType() == this.getGosuObjectInterface();
    }

    private IGosuClassInternal getGosuObjectInterface() {
        return IGosuClassInternal.Util.getGosuClassFrom((IType)JavaTypes.IGOSU_OBJECT());
    }

    private void compileIntrinsicTypePropertyGetter() {
        this.setUpFunctionContext(true, Collections.emptyList());
        IRExpression getTypeExpression = this.callStaticMethod(GosuRuntimeMethods.class, "getType", new Class[]{Object.class}, Collections.singletonList(this.pushThis()));
        if (this._gsClass.isGenericType()) {
            getTypeExpression = this.callMethod(IType.class, "getParameterizedType", new Class[]{IType[].class}, getTypeExpression, Collections.singletonList(this.makeArrayOfTypeParameters()));
        }
        IRReturnStatement methodBody = new IRReturnStatement(null, getTypeExpression);
        IRMethodStatement method = new IRMethodStatement((IRStatement)methodBody, "getIntrinsicType", 4097, false, GosuClassTransformer.getDescriptor(IType.class), Collections.emptyList());
        this._irClass.addMethod(method);
    }

    private void compileMainMethod() {
        if (!(this.getGosuClass() instanceof IGosuProgram)) {
            return;
        }
        ArrayList<IType> paramTypes = new ArrayList<IType>();
        IMethodInfo evaluateMethod = null;
        for (IMethodInfo mi : this.getGosuClass().getTypeInfo().getMethods()) {
            if (!mi.getName().startsWith("evaluate(")) continue;
            evaluateMethod = mi;
            for (IParameterInfo param : mi.getParameters()) {
                IType paramType = param.getFeatureType();
                paramTypes.add(paramType);
            }
        }
        IRExpression newProgram = this.buildNewExpression(IRTypeResolver.getDescriptor((IType)this.getGosuClass()), Collections.emptyList(), Collections.emptyList());
        IRMethod evaluateIRMethod = IRMethodFactory.createIRMethod((IType)this.getGosuClass(), "evaluate", evaluateMethod.getReturnType(), paramTypes.toArray(new IType[paramTypes.size()]), IRelativeTypeInfo.Accessibility.PUBLIC, false);
        IRExpression callEvaluate = this.callMethod(evaluateIRMethod, newProgram, Collections.singletonList(this.nullLiteral()));
        IRStatementList methodBody = new IRStatementList(true, new IRStatement[]{this.buildMethodCall(callEvaluate), this.buildReturn()});
        IRMethodStatement method = new IRMethodStatement((IRStatement)methodBody, "main", 9, false, GosuClassTransformer.getDescriptor(Void.TYPE), Collections.singletonList(new IRSymbol("args", GosuClassTransformer.getDescriptor(String[].class), false)));
        this._irClass.addMethod(method);
    }

    private void compileEnumValuesMethod() {
        this.setUpFunctionContext(true, Collections.emptyList());
        int numberOfEnumFields = 0;
        for (IVarStatement varStatement : this._gsClass.getStaticFields()) {
            if (!varStatement.isEnumConstant()) continue;
            ++numberOfEnumFields;
        }
        ArrayList<Object> bodyStatements = new ArrayList<Object>();
        IRSymbol tempSymbol = this._context.makeAndIndexTempSymbol(GosuClassTransformer.getDescriptor(this._gsClass.getArrayType()));
        IRAssignmentStatement arrayCreation = this.buildAssignment(tempSymbol, this.newArray(GosuClassTransformer.getDescriptor((IType)this._gsClass), this.numericLiteral(numberOfEnumFields)));
        bodyStatements.add(arrayCreation);
        IRExpression arrayCopy = this.callStaticMethod(System.class, "arraycopy", new Class[]{Object.class, Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE}, GosuClassTransformer.exprList(new IRExpression[]{this.getStaticField((IType)this._gsClass, ENUM_VALUES_FIELD, GosuClassTransformer.getDescriptor(this._gsClass.getArrayType()), IRelativeTypeInfo.Accessibility.PUBLIC), this.numericLiteral(0), this.identifier(tempSymbol), this.numericLiteral(0), this.numericLiteral(numberOfEnumFields)}));
        bodyStatements.add(this.buildMethodCall(arrayCopy));
        bodyStatements.add(new IRReturnStatement(null, (IRExpression)this.identifier(tempSymbol)));
        IRMethodStatement method = new IRMethodStatement((IRStatement)new IRStatementList(true, bodyStatements), "values", 9, false, GosuClassTransformer.getDescriptor(this._gsClass.getArrayType()), Collections.emptyList());
        this._irClass.addMethod(method);
    }

    private void compileEnumAllValuesPropertyGetter() {
        this.setUpFunctionContext(true, Collections.emptyList());
        IRMethod valuesMethod = IRMethodFactory.createIRMethod((IType)this._gsClass, "values", this._gsClass.getArrayType(), new IType[0], IRelativeTypeInfo.Accessibility.PUBLIC, true);
        IRExpression result = this.callStaticMethod(Arrays.class, "asList", new Class[]{Object[].class}, GosuClassTransformer.exprList(this.callMethod(valuesMethod, null, GosuClassTransformer.exprList(new IRExpression[0]))));
        IRMethodStatement method = new IRMethodStatement((IRStatement)new IRStatementList(true, new IRStatement[]{new IRReturnStatement(null, result)}), "getAllValues", 9, false, GosuClassTransformer.getDescriptor(List.class), Collections.emptyList());
        this._irClass.addMethod(method);
    }

    private void compileEnumValueOfMethod() {
        IRSymbol argSymbol = new IRSymbol("arg", IRTypeConstants.STRING(), false);
        this.setUpFunctionContext(true, Collections.singletonList(argSymbol));
        IRExpression result = this.callStaticMethod(Enum.class, "valueOf", new Class[]{Class.class, String.class}, GosuClassTransformer.exprList(new IRExpression[]{this.classLiteral(GosuClassTransformer.getDescriptor((IType)this._gsClass)), this.identifier(argSymbol)}));
        IRMethodStatement method = new IRMethodStatement((IRStatement)new IRStatementList(true, new IRStatement[]{new IRReturnStatement(null, this.checkCast((IType)this._gsClass, result))}), "valueOf", 9, false, GosuClassTransformer.getDescriptor((IType)this._gsClass), Collections.singletonList(argSymbol));
        this._irClass.addMethod(method);
    }

    private void compileEnumValuePropertyGetter() {
        this.setUpFunctionContext(true, Collections.emptyList());
        IRMethodStatement method = new IRMethodStatement((IRStatement)new IRStatementList(true, new IRStatement[]{new IRReturnStatement(null, this.pushThis())}), "getValue", 17, false, IRTypeConstants.OBJECT(), Collections.emptyList());
        this._irClass.addMethod(method);
    }

    private void compileEnumCodePropertyGetter() {
        IDynamicPropertySymbol existingProperty = this.getGosuClass().getMemberProperty("Code");
        if (existingProperty != null && !(existingProperty instanceof EnumCodePropertySymbol)) {
            return;
        }
        this.setUpFunctionContext(true, Collections.emptyList());
        IRExpression returnValue = this.callMethod(Enum.class, "name", new Class[0], this.pushThis(), GosuClassTransformer.exprList(new IRExpression[0]));
        IRMethodStatement method = new IRMethodStatement((IRStatement)new IRStatementList(true, new IRStatement[]{new IRReturnStatement(null, returnValue)}), "getCode", 17, false, IRTypeConstants.STRING(), Collections.emptyList());
        this._irClass.addMethod(method);
    }

    private void compileEnumOrdinalPropertyGetter() {
        this.setUpFunctionContext(true, Collections.emptyList());
        IRExpression returnValue = this.callMethod(Enum.class, "ordinal", new Class[0], this.pushThis(), GosuClassTransformer.exprList(new IRExpression[0]));
        IRMethodStatement method = new IRMethodStatement((IRStatement)new IRStatementList(true, new IRStatement[]{new IRReturnStatement(null, returnValue)}), "getOrdinal", 17, false, IRTypeConstants.pINT(), Collections.emptyList());
        this._irClass.addMethod(method);
    }

    private void compileEnumNamePropertyGetter() {
        IDynamicPropertySymbol existingProperty = this.getGosuClass().getMemberProperty("Name");
        if (existingProperty != null && !(existingProperty instanceof EnumNamePropertySymbol)) {
            return;
        }
        this.setUpFunctionContext(true, Collections.emptyList());
        IRExpression returnValue = this.callMethod(Enum.class, "name", new Class[0], this.pushThis(), GosuClassTransformer.exprList(new IRExpression[0]));
        IRMethodStatement method = new IRMethodStatement((IRStatement)new IRStatementList(true, new IRStatement[]{new IRReturnStatement(null, returnValue)}), "getName", 17, false, IRTypeConstants.STRING(), Collections.emptyList());
        this._irClass.addMethod(method);
    }

    private void compileEnumDisplayNamePropertyGetter() {
        IDynamicPropertySymbol existingProperty = this.getGosuClass().getMemberProperty("DisplayName");
        if (existingProperty != null && !(existingProperty instanceof EnumDisplayNamePropertySymbol)) {
            return;
        }
        this.setUpFunctionContext(true, Collections.emptyList());
        IRExpression returnValue = this.callMethod(Enum.class, "toString", new Class[0], this.pushThis(), GosuClassTransformer.exprList(new IRExpression[0]));
        IRMethodStatement method = new IRMethodStatement((IRStatement)new IRStatementList(true, new IRStatement[]{new IRReturnStatement(null, returnValue)}), "getDisplayName", 17, false, IRTypeConstants.STRING(), Collections.emptyList());
        this._irClass.addMethod(method);
    }

    private IRExpression makeArrayOfTypeParameters() {
        IGenericTypeVariable[] genTypeVars = this._gsClass.getGenericTypeVariables();
        ArrayList<IRExpression> values = new ArrayList<IRExpression>();
        for (IGenericTypeVariable gv : genTypeVars) {
            values.add(this.buildCast(GosuClassTransformer.getDescriptor(IType.class), (IRExpression)this.buildMethodCall(LazyTypeResolver.class, "get", Object.class, new Class[0], this.getInstanceField((IType)this._gsClass, "typeparam$" + gv.getName(), GosuClassTransformer.getDescriptor(LazyTypeResolver.class), AccessibilityUtil.forTypeParameter(), this.pushThis()), Collections.emptyList())));
        }
        return this.buildInitializedArray(IRTypeConstants.ITYPE(), values);
    }

    public void initializeInstanceFields(List<IRStatement> statements) {
        List<IVarStatement> fields = this.getOrderedFields();
        for (IVarStatement field : fields) {
            statements.add(FieldInitializerTransformer.compile(this._context, field));
        }
    }

    public void initTypeVarFields(List<IRStatement> statements) {
        IDynamicFunctionSymbol dfs;
        IGosuClassInternal gsClass = this._gsClass;
        if (gsClass.isGenericType()) {
            for (IGenericTypeVariable genTypeVar : gsClass.getGenericTypeVariables()) {
                statements.add(this.setInstanceField((IType)gsClass, "typeparam$" + genTypeVar.getName(), GosuClassTransformer.getDescriptor(LazyTypeResolver.class), AccessibilityUtil.forTypeParameter(), this.pushThis(), (IRExpression)this.identifier(this._context.getSymbol(this.getTypeVarParamName(genTypeVar)))));
            }
        }
        while (gsClass.isAnonymous() && (dfs = GosuClassTransformer.getEnclosingDFS(gsClass)) != null) {
            for (IGenericTypeVariable genTypeVar : GosuClassTransformer.getTypeVarsForDFS(dfs)) {
                statements.add(this.setInstanceField((IType)this._gsClass, "typeparam$" + genTypeVar.getName(), GosuClassTransformer.getDescriptor(LazyTypeResolver.class), AccessibilityUtil.forTypeParameter(), this.pushThis(), (IRExpression)this.identifier(this._context.getSymbol(this.getTypeVarParamName(genTypeVar)))));
            }
            gsClass = (IGosuClassInternal)dfs.getGosuClass();
        }
    }

    public void initCapturedSymbolFields(List<IRStatement> statements) {
        Map<String, ICapturedSymbol> capturedSymbols = this._gsClass.getCapturedSymbols();
        if (capturedSymbols != null) {
            int iIndex = 1;
            iIndex += this._gsClass.isStatic() ? 0 : 1;
            for (ICapturedSymbol sym : capturedSymbols.values()) {
                statements.add(this.setInstanceField((IType)this._gsClass, "val$" + sym.getName(), GosuClassTransformer.getDescriptor(sym.getType().getArrayType()), AccessibilityUtil.forCapturedVar(), this.pushThis(), (IRExpression)this.identifier(this._context.getSymbol(this.getCapturedSymbolParameterName(sym)))));
            }
        }
        if (GosuClassTransformer.requiresExternalSymbolCapture((IType)this._gsClass)) {
            statements.add(this.setInstanceField((IType)this._gsClass, "$symbols$", GosuClassTransformer.getDescriptor(IExternalSymbolMap.class), AccessibilityUtil.forCapturedVar(), this.pushThis(), (IRExpression)this.identifier(this._context.getSymbol("$symbols$arg"))));
        }
    }

    public void initializeStaticFields(List<IRStatement> statements) {
        boolean needToCompileEnumValuesField = this._gsClass.isEnum();
        List<IVarStatement> fields = this._gsClass.getStaticFields();
        for (IVarStatement field : fields) {
            if (field.isEnumConstant()) {
                this._enumCounter.increment(field.getIdentifierName());
            } else if (needToCompileEnumValuesField && !field.isEnumConstant()) {
                this.compileEnumValuesFieldInitializer(statements);
                needToCompileEnumValuesField = false;
            }
            statements.add(FieldInitializerTransformer.compile(this._context, field));
        }
        if (needToCompileEnumValuesField) {
            this.compileEnumValuesFieldInitializer(statements);
        }
        if (this.getGosuClass().hasAssertions()) {
            statements.add(this.initializeAssertionsDisabledField());
        }
    }

    private IRStatement initializeAssertionsDisabledField() {
        return this.buildFieldSet(this._irClass.getThisType(), "$assertionsDisabled", IRTypeConstants.pBOOLEAN(), null, (IRExpression)this.buildEquals((IRExpression)this.buildMethodCall(Class.class, "desiredAssertionStatus", Boolean.TYPE, new Class[0], this.classLiteral(GosuClassIRType.get((IType)this.getGosuClass())), Collections.emptyList()), this.booleanLiteral(false)));
    }

    private void compileEnumValuesFieldInitializer(List<IRStatement> statements) {
        ArrayList<IVarStatement> enumFields = new ArrayList<IVarStatement>();
        for (IVarStatement varStatement : this._gsClass.getStaticFields()) {
            if (!varStatement.isEnumConstant()) continue;
            enumFields.add(varStatement);
        }
        ArrayList<IRExpression> values = new ArrayList<IRExpression>();
        for (int i = 0; i < enumFields.size(); ++i) {
            values.add(this.getStaticField((IType)this._gsClass, ((IVarStatement)enumFields.get(i)).getIdentifierName(), GosuClassTransformer.getDescriptor(((IVarStatement)enumFields.get(i)).getType()), IRelativeTypeInfo.Accessibility.PUBLIC));
        }
        IRExpression arrayBuilder = this.buildInitializedArray(GosuClassTransformer.getDescriptor((IType)this._gsClass), values);
        statements.add(this.setStaticField((IType)this._gsClass, ENUM_VALUES_FIELD, GosuClassTransformer.getDescriptor(this._gsClass.getArrayType()), IRelativeTypeInfo.Accessibility.PUBLIC, arrayBuilder));
    }

    private List<IVarStatement> getOrderedFields() {
        ArrayList<ISymbol> fields = new ArrayList<ISymbol>(this._gsClass.getMemberFieldIndexByName().values());
        Collections.sort(fields, new Comparator<MemberFieldSymbol>(){

            @Override
            public int compare(MemberFieldSymbol o1, MemberFieldSymbol o2) {
                return o1.getIndex() - o2.getIndex();
            }
        });
        ArrayList<IVarStatement> fieldStmts = new ArrayList<IVarStatement>(fields.size());
        for (MemberFieldSymbol memberFieldSymbol : fields) {
            fieldStmts.add(this._gsClass.getMemberField(memberFieldSymbol.getName()));
        }
        return fieldStmts;
    }

    private IRType getDescriptorNoStructures(IType type) {
        if (type instanceof IGosuClassInternal && ((IGosuClassInternal)type).isStructure()) {
            type = JavaTypes.OBJECT();
        }
        return GosuClassTransformer.getDescriptor(type);
    }

    private String getParameterDescriptors(IType[] types) {
        StringBuilder sb = new StringBuilder();
        for (IType type : types) {
            if (type instanceof IGosuClassInternal && ((IGosuClassInternal)type).isStructure()) {
                type = JavaTypes.OBJECT();
            }
            sb.append(GosuClassTransformer.getDescriptor(type).getName());
        }
        return sb.toString();
    }

    private String getParameterDescriptors(IJavaClassInfo[] iJavaClassInfos) {
        StringBuilder sb = new StringBuilder();
        for (IJavaClassInfo type : iJavaClassInfos) {
            sb.append(GosuClassTransformer.getDescriptor(type).getName());
        }
        return sb.toString();
    }

    private void compileClassHeader() {
        this._irClass.setName(this._gsClass.getName());
        this._irClass.setThisType(GosuClassTransformer.getDescriptor((IType)this._gsClass));
        this._irClass.setModifiers(this.getClassModifiers());
        this._irClass.setSuperType(this.getSuperSlashName());
        for (IRType iface : this.getInterfaceNames()) {
            this._irClass.addInterface(iface);
        }
        this._irClass.makeGenericSignature((IType)this._gsClass);
    }

    private IRType getSuperSlashName() {
        return this._gsClass.getSupertype() == null ? GosuClassTransformer.getDescriptor(Object.class) : GosuClassTransformer.getDescriptor(this._gsClass.getSupertype());
    }

    private void addSourceFileRef() {
        String sourceFileRef = this._context.getSourceFileRef();
        if (sourceFileRef != null) {
            this._irClass.setSourceFile(sourceFileRef);
        }
    }

    private int getClassModifiers() {
        return this.getClassModifiers(this._gsClass, false);
    }

    private int getClassModifiers(IGosuClass gsClass, boolean bForInnerClass) {
        int iGsModifiers;
        int iModifiers = 0;
        if (gsClass == this._gsClass) {
            if (gsClass.isInterface()) {
                iModifiers |= 0x200;
            } else {
                if (gsClass.isEnum()) {
                    iModifiers |= 0x4010;
                }
                if (!bForInnerClass) {
                    iModifiers |= 0x20;
                }
            }
        }
        if (Modifier.isPublic((int)(iGsModifiers = gsClass.getModifiers())) || !Modifier.isInternal((int)iGsModifiers) && !Modifier.isPrivate((int)iGsModifiers) || BytecodeOptions.isSingleServingLoader()) {
            iModifiers |= 1;
        } else if (bForInnerClass && gsClass.getEnclosingType() != null && Modifier.isPrivate((int)iGsModifiers) && !BytecodeOptions.isSingleServingLoader()) {
            iModifiers |= 2;
        }
        if (Modifier.isFinal((int)iGsModifiers)) {
            iModifiers |= 0x10;
        }
        if (Modifier.isAbstract((int)iGsModifiers) || gsClass.isInterface()) {
            iModifiers |= 0x400;
        }
        if (bForInnerClass && (Modifier.isStatic((int)iGsModifiers) || gsClass.getEnclosingType() != null && gsClass.isInterface())) {
            iModifiers |= 8;
        }
        if (Modifier.isAnnotation((int)iGsModifiers)) {
            iModifiers |= 0x2000;
        }
        return iModifiers;
    }

    private IRType[] getInterfaceNames() {
        IType[] interfaces = this._gsClass.getInterfaces();
        if (interfaces == null || interfaces.length == 0) {
            return new IRType[0];
        }
        ArrayList<IRType> ifaceNames = new ArrayList<IRType>();
        for (IType iface : interfaces) {
            IRType irInterface;
            if (iface == this.getGosuObjectInterface()) {
                iface = JavaTypes.IGOSU_CLASS_OBJECT();
            }
            if (ifaceNames.contains(irInterface = GosuClassTransformer.getDescriptor(iface))) continue;
            ifaceNames.add(irInterface);
        }
        return ifaceNames.toArray(new IRType[ifaceNames.size()]);
    }

    public IGosuEnhancementInternal getGosuEnhancement() {
        return (IGosuEnhancementInternal)this._gsClass;
    }

    public void pushEnumNameAndOrdinal(IType type, List<IRExpression> args) {
        if (type.isEnum()) {
            args.add(this.pushConstant(this._enumCounter.getNextEnumName()));
            args.add(this.pushConstant(this._enumCounter.getNextEnumOrdinal()));
        }
    }

    public void setHasAsserts() {
        if (this._bHasAsserts) {
            return;
        }
        this._bHasAsserts = true;
        IRFieldDecl fieldDecl = new IRFieldDecl(4120, false, "$assertionsDisabled", GosuClassTransformer.getDescriptor((IType)JavaTypes.pBOOLEAN()), null);
        this._irClass.addField(fieldDecl);
    }

    public boolean isBlockInvoke(DynamicFunctionSymbol dfs) {
        return dfs.getDisplayName().equals("invoke") && this._context.compilingBlock();
    }

    private void setUpFunctionContext(boolean instanceMethod, List<IRSymbol> params) {
        this._context.initBodyContext(!instanceMethod);
        this._context.pushScope(instanceMethod);
        this._context.putSymbols(params);
    }

    private void setUpFunctionContext(DynamicFunctionSymbol dfs, boolean instanceMethod, List<IRSymbol> params) {
        this._context.initBodyContext(dfs.isStatic(), dfs);
        this._context.pushScope(instanceMethod);
        this._context.putSymbols(params);
    }

    public String toString() {
        return "Transforming Class: " + this.getGosuClass().getName();
    }

    static final class EnumOrdinalCounter {
        private int _nextEnumOrdinal = -1;
        private String _nextEnumName;

        EnumOrdinalCounter() {
        }

        public int getNextEnumOrdinal() {
            return this._nextEnumOrdinal;
        }

        public String getNextEnumName() {
            return this._nextEnumName;
        }

        private void increment(String name) {
            ++this._nextEnumOrdinal;
            this._nextEnumName = name;
        }
    }
}

