/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.expression;

import gw.internal.gosu.ir.nodes.IRMethod;
import gw.internal.gosu.ir.transform.AbstractElementTransformer;
import gw.internal.gosu.ir.transform.ExpressionTransformer;
import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.parser.ParameterizedGosuConstructorInfo;
import gw.internal.gosu.parser.TypeLord;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRType;
import gw.lang.parser.IExpression;
import gw.lang.parser.IReducedSymbol;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IPlaceholder;
import gw.lang.reflect.IType;
import gw.lang.reflect.gs.IGosuConstructorInfo;
import gw.lang.reflect.java.IJavaConstructorInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractExpressionTransformer<T extends IExpression>
extends AbstractElementTransformer<T> {
    public AbstractExpressionTransformer(TopLevelTransformationContext cc, T parsedElem) {
        super(cc, parsedElem);
    }

    public final IRExpression compile() {
        IRExpression expr = this.compile_impl();
        return expr;
    }

    protected abstract IRExpression compile_impl();

    public T _expr() {
        return (T)((IExpression)this.getParsedElement());
    }

    static List<IRType> getIRParameters(IConstructorInfo ci) {
        if (ci.getParameters().length == 0) {
            return Collections.emptyList();
        }
        if (ci instanceof IJavaConstructorInfo) {
            Class<?>[] parameterClasses = ((IJavaConstructorInfo)ci).getRawConstructor().getParameterTypes();
            ArrayList<IRType> irTypes = new ArrayList<IRType>(parameterClasses.length);
            for (Class<?> parameterClass : parameterClasses) {
                irTypes.add(AbstractExpressionTransformer.getDescriptor(parameterClass));
            }
            return irTypes;
        }
        if (ci instanceof IGosuConstructorInfo) {
            IGosuConstructorInfo cInfo = (IGosuConstructorInfo)ci;
            while (cInfo instanceof ParameterizedGosuConstructorInfo) {
                ParameterizedGosuConstructorInfo pdfs = (ParameterizedGosuConstructorInfo)cInfo;
                cInfo = pdfs.getBackingConstructorInfo();
            }
            ArrayList<IRType> boundedTypes = new ArrayList<IRType>(cInfo.getArgs().size());
            for (int i = 0; i < cInfo.getArgs().size(); ++i) {
                IType type = ((IReducedSymbol)cInfo.getArgs().get(i)).getType();
                boundedTypes.add(AbstractExpressionTransformer.getDescriptor(TypeLord.getDefaultParameterizedTypeWithTypeVars(type)));
            }
            return boundedTypes;
        }
        ArrayList<IRType> boundedTypes = new ArrayList<IRType>(ci.getParameters().length);
        for (IType type : AbstractExpressionTransformer.getTypes(ci.getParameters())) {
            boundedTypes.add(AbstractExpressionTransformer.getDescriptor(type));
        }
        return boundedTypes;
    }

    protected IRExpression shortCircuitValue(IRType expressionType) {
        if (this._expr().getType().isPrimitive()) {
            return this.getDefaultConstIns(this._expr().getType());
        }
        return this.buildCast(expressionType, this.nullLiteral());
    }

    protected void pushArgumentsNoCasting(IRMethod irMethod, IExpression[] args, List<IRExpression> irArgs) {
        this._pushArguments(irMethod, args, irArgs, false);
    }

    protected void pushArgumentsWithCasting(IRMethod irMethod, IExpression[] args, List<IRExpression> irArgs) {
        this._pushArguments(irMethod, args, irArgs, true);
    }

    private void _pushArguments(IRMethod irMethod, IExpression[] args, List<IRExpression> irArgs, boolean bCast) {
        if (args != null) {
            List<Object> paramClasses = bCast ? irMethod.getExplicitParameterTypes() : Collections.emptyList();
            for (int i = 0; i < args.length; ++i) {
                IExpression arg = args[i];
                IRExpression irArg = ExpressionTransformer.compile(arg, this._cc());
                if (bCast) {
                    IRType type = (IRType)paramClasses.get(i);
                    irArg = type.isPrimitive() && arg.getType() instanceof IPlaceholder && ((IPlaceholder)arg.getType()).isPlaceholder() ? this.unboxValueToType(type, irArg) : this.maybeCast(paramClasses, i, irArg);
                }
                irArgs.add(irArg);
            }
        }
    }

    private IRExpression maybeCast(List<IRType> paramClasses, int i, IRExpression irArg) {
        IRType paramClass = paramClasses.get(i);
        if (!paramClass.isAssignableFrom(irArg.getType())) {
            irArg = this.buildCast(paramClass, irArg);
        }
        return irArg;
    }
}

