/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.expression;

import gw.internal.gosu.ir.nodes.IRMethodFactory;
import gw.internal.gosu.ir.nodes.JavaClassIRType;
import gw.internal.gosu.ir.transform.ExpressionTransformer;
import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.expression.AbstractExpressionTransformer;
import gw.internal.gosu.parser.BeanAccess;
import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.expressions.ArithmeticExpression;
import gw.lang.ir.IRElement;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRStatement;
import gw.lang.ir.IRSymbol;
import gw.lang.ir.IRType;
import gw.lang.ir.expression.IRArithmeticExpression;
import gw.lang.ir.expression.IRCompositeExpression;
import gw.lang.ir.statement.IRAssignmentStatement;
import gw.lang.parser.StandardCoercionManager;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.JavaTypes;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Arrays;
import java.util.Collections;

abstract class ArithmeticExpressionTransformer<T extends ArithmeticExpression>
extends AbstractExpressionTransformer<T> {
    public ArithmeticExpressionTransformer(TopLevelTransformationContext cc, T parsedElem) {
        super(cc, parsedElem);
    }

    final IRExpression compileNumericArithmetic() {
        IType rhsType;
        IType type = ((ArithmeticExpression)this._expr()).getType();
        boolean bNumeric = BeanAccess.isNumericType(type);
        IMethodInfo operatorOverload = ((ArithmeticExpression)this._expr()).getOverride();
        if (bNumeric && operatorOverload != null) {
            IRExpression lhs = ExpressionTransformer.compile(((ArithmeticExpression)this._expr()).getLHS(), this._cc());
            IRExpression rhs = ExpressionTransformer.compile(((ArithmeticExpression)this._expr()).getRHS(), this._cc());
            return this.callMethod(IRMethodFactory.createIRMethod(operatorOverload, null), lhs, ArithmeticExpressionTransformer.exprList(rhs));
        }
        if (this.isPrimitiveArithmetic()) {
            return this.primitiveArithmetic();
        }
        IType lhsType = ((ArithmeticExpression)this._expr()).getLHS().getType();
        if (this.isMixedPrimitiveAndBoxedArithmetic(type, lhsType, rhsType = ((ArithmeticExpression)this._expr()).getRHS().getType())) {
            return this.mixedPrimitiveAndBoxedArithmetic(type, ((ArithmeticExpression)this._expr()).getLHS(), ((ArithmeticExpression)this._expr()).getRHS(), ((ArithmeticExpression)this._expr()).isNullSafe(), ((ArithmeticExpression)this._expr()).getOperator());
        }
        if (this.isBigDecimalArithmetic(type, lhsType, rhsType) || this.isBigIntegerArithmetic(type, lhsType, rhsType)) {
            return this.bigArithmetic();
        }
        if (this.isMixedBigDecimalArithmetic(type, lhsType, rhsType) || this.isMixedBigIntegerArithmetic(type, lhsType, rhsType)) {
            return this.mixedBigArithmetic(type, ((ArithmeticExpression)this._expr()).getLHS(), ((ArithmeticExpression)this._expr()).getRHS(), ((ArithmeticExpression)this._expr()).isNullSafe(), ((ArithmeticExpression)this._expr()).getOperator());
        }
        return null;
    }

    final boolean isPrimitiveArithmetic() {
        return this.isPrimitiveNumberType(((ArithmeticExpression)this._expr()).getType()) && this.isPrimitiveNumberType(((ArithmeticExpression)this._expr()).getLHS().getType()) && this.isPrimitiveNumberType(((ArithmeticExpression)this._expr()).getRHS().getType());
    }

    final boolean isMixedPrimitiveAndBoxedArithmetic(IType type, IType lhsType, IType rhsType) {
        return ArithmeticExpressionTransformer.isNumberType(type) && ArithmeticExpressionTransformer.isNumberType(lhsType) && ArithmeticExpressionTransformer.isNumberType(rhsType);
    }

    final boolean isBigDecimalArithmetic(IType type, IType lhsType, IType rhsType) {
        return JavaTypes.BIG_DECIMAL().equals(type) && JavaTypes.BIG_DECIMAL().equals(lhsType) && JavaTypes.BIG_DECIMAL().equals(rhsType);
    }

    final boolean isBigIntegerArithmetic(IType type, IType lhsType, IType rhsType) {
        return JavaTypes.BIG_INTEGER().equals(type) && JavaTypes.BIG_INTEGER().equals(lhsType) && JavaTypes.BIG_INTEGER().equals(rhsType);
    }

    final boolean isMixedBigDecimalArithmetic(IType type, IType lhsType, IType rhsType) {
        return !(!JavaTypes.BIG_DECIMAL().equals(type) || !ArithmeticExpressionTransformer.isNumberType(lhsType) && !JavaTypes.BIG_DECIMAL().equals(lhsType) || !ArithmeticExpressionTransformer.isNumberType(rhsType) && !JavaTypes.BIG_DECIMAL().equals(rhsType));
    }

    final boolean isMixedBigIntegerArithmetic(IType type, IType lhsType, IType rhsType) {
        return !(!JavaTypes.BIG_INTEGER().equals(type) || !ArithmeticExpressionTransformer.isNumberType(lhsType) && !JavaTypes.BIG_INTEGER().equals(lhsType) || !ArithmeticExpressionTransformer.isNumberType(rhsType) && !JavaTypes.BIG_INTEGER().equals(rhsType));
    }

    final IRExpression mixedPrimitiveAndBoxedArithmetic(IType exprType, Expression lhsExpr, Expression rhsExpr, boolean bNullSafe, String strOp) {
        IType primitiveType;
        IType iType = primitiveType = exprType.isPrimitive() ? exprType : TypeSystem.getPrimitiveType((IType)exprType);
        if (bNullSafe) {
            IRSymbol rhsPrim;
            IRSymbol lhsPrim;
            IRExpression lhs = ExpressionTransformer.compile(lhsExpr, this._cc());
            IRExpression rhs = ExpressionTransformer.compile(rhsExpr, this._cc());
            IRSymbol tempLhs = this._cc().makeAndIndexTempSymbol(ArithmeticExpressionTransformer.getDescriptor(lhsExpr.getType()));
            IRAssignmentStatement tempLhsAssn = this.buildAssignment(tempLhs, lhs);
            IRSymbol tempRhs = this._cc().makeAndIndexTempSymbol(ArithmeticExpressionTransformer.getDescriptor(rhsExpr.getType()));
            IRAssignmentStatement tempRhsAssn = this.buildAssignment(tempRhs, rhs);
            IRCompositeExpression compExpr = new IRCompositeExpression(new IRElement[]{tempLhsAssn, tempRhsAssn});
            IRSymbol isNull = this._cc().makeAndIndexTempSymbol(ArithmeticExpressionTransformer.getDescriptor(Boolean.TYPE));
            IRAssignmentStatement isNullAssn = this.buildAssignment(isNull, this.booleanLiteral(false));
            compExpr.addElement((IRElement)isNullAssn);
            if (StandardCoercionManager.isBoxed((IType)lhsExpr.getType())) {
                IType lhsPrimType = TypeSystem.getPrimitiveType((IType)lhsExpr.getType());
                lhsPrim = this._cc().makeAndIndexTempSymbol(ArithmeticExpressionTransformer.getDescriptor(primitiveType));
                compExpr.addElement((IRElement)this.buildAssignment(lhsPrim, this.convertNullToPrimitive(primitiveType)));
                compExpr.addElement((IRElement)this.buildIfElse((IRExpression)this.buildEquals((IRExpression)this.identifier(tempLhs), this.nullLiteral()), (IRStatement)this.buildAssignment(isNull, this.booleanLiteral(true)), (IRStatement)this.buildAssignment(lhsPrim, this.numberConvert(lhsPrimType, primitiveType, this.unboxValueFromType(lhsExpr.getType(), (IRExpression)this.identifier(tempLhs))))));
            } else {
                lhsPrim = this._cc().makeAndIndexTempSymbol(ArithmeticExpressionTransformer.getDescriptor(primitiveType));
                compExpr.addElement((IRElement)this.buildAssignment(lhsPrim, this.numberConvert(lhsExpr.getType(), primitiveType, (IRExpression)this.identifier(tempLhs))));
            }
            if (StandardCoercionManager.isBoxed((IType)rhsExpr.getType())) {
                IType rhsPrimType = TypeSystem.getPrimitiveType((IType)rhsExpr.getType());
                rhsPrim = this._cc().makeAndIndexTempSymbol(ArithmeticExpressionTransformer.getDescriptor(primitiveType));
                compExpr.addElement((IRElement)this.buildAssignment(rhsPrim, this.convertNullToPrimitive(primitiveType)));
                compExpr.addElement((IRElement)this.buildIfElse((IRExpression)this.buildEquals((IRExpression)this.identifier(tempRhs), this.nullLiteral()), (IRStatement)this.buildAssignment(isNull, this.booleanLiteral(true)), (IRStatement)this.buildAssignment(rhsPrim, this.numberConvert(rhsPrimType, primitiveType, this.unboxValueFromType(rhsExpr.getType(), (IRExpression)this.identifier(tempRhs))))));
            } else {
                rhsPrim = this._cc().makeAndIndexTempSymbol(ArithmeticExpressionTransformer.getDescriptor(primitiveType));
                compExpr.addElement((IRElement)this.buildAssignment(rhsPrim, this.numberConvert(rhsExpr.getType(), primitiveType, (IRExpression)this.identifier(tempRhs))));
            }
            IRExpression expr = this.makeIRArithmeticExpression(primitiveType, (IRExpression)this.identifier(lhsPrim), (IRExpression)this.identifier(rhsPrim), this.isCheckedArithmeticEnabled());
            if (StandardCoercionManager.isBoxed((IType)exprType)) {
                expr = this.boxValueToType(exprType, expr);
            }
            expr = this.buildTernary((IRExpression)this.buildEquals((IRExpression)this.identifier(isNull), this.booleanLiteral(true)), StandardCoercionManager.isBoxed((IType)exprType) ? this.nullLiteral() : this.numberConvert((IType)JavaTypes.pINT(), exprType, this.pushConstant(0)), expr, ArithmeticExpressionTransformer.getDescriptor(exprType));
            compExpr.addElement((IRElement)expr);
            return compExpr;
        }
        IRExpression lhs = ExpressionTransformer.compile(lhsExpr, this._cc());
        if (StandardCoercionManager.isBoxed((IType)lhsExpr.getType())) {
            lhs = this.unboxValueFromType(lhsExpr.getType(), lhs);
        }
        lhs = this.numberConvert(lhs.getType(), ArithmeticExpressionTransformer.getDescriptor(primitiveType), lhs);
        IRExpression rhs = ExpressionTransformer.compile(rhsExpr, this._cc());
        if (StandardCoercionManager.isBoxed((IType)rhsExpr.getType())) {
            rhs = this.unboxValueFromType(rhsExpr.getType(), rhs);
        }
        rhs = this.numberConvert(rhs.getType(), ArithmeticExpressionTransformer.getDescriptor(primitiveType), rhs);
        IRExpression expr = this.makeIRArithmeticExpression(primitiveType, lhs, rhs, this.isCheckedArithmeticEnabled());
        if (StandardCoercionManager.isBoxed((IType)exprType)) {
            expr = this.boxValueToType(exprType, expr);
        }
        return expr;
    }

    final IRExpression mixedBigArithmetic(IType bigType, Expression lhsExpr, Expression rhsExpr, boolean bNullSafe, String strOp) {
        Class bigClass;
        Class clazz = bigClass = bigType == JavaTypes.BIG_INTEGER() ? BigInteger.class : BigDecimal.class;
        assert (bigType == JavaTypes.BIG_INTEGER() || bigType == JavaTypes.BIG_DECIMAL());
        IRExpression lhs = ExpressionTransformer.compile(lhsExpr, this._cc());
        IRExpression rhs = ExpressionTransformer.compile(rhsExpr, this._cc());
        IRSymbol tempLhsInit = this._cc().makeAndIndexTempSymbol(ArithmeticExpressionTransformer.getDescriptor(lhsExpr.getType()));
        IRAssignmentStatement tempLhsInitAssn = this.buildAssignment(tempLhsInit, lhs);
        IRSymbol tempRhsInit = this._cc().makeAndIndexTempSymbol(ArithmeticExpressionTransformer.getDescriptor(rhsExpr.getType()));
        IRAssignmentStatement tempRhsInitAssn = this.buildAssignment(tempRhsInit, rhs);
        IRSymbol tempLhsRet = this._cc().makeAndIndexTempSymbol(ArithmeticExpressionTransformer.getDescriptor(bigType));
        IRAssignmentStatement tempLhsRetAssn = this.convertOperandToBig(bigType, bigClass, lhsExpr.getType(), (IRExpression)this.identifier(tempLhsInit), tempLhsRet);
        IRSymbol tempRhsRet = this._cc().makeAndIndexTempSymbol(ArithmeticExpressionTransformer.getDescriptor(bigType));
        IRAssignmentStatement tempRhsRetAssn = this.convertOperandToBig(bigType, bigClass, rhsExpr.getType(), (IRExpression)this.identifier(tempRhsInit), tempRhsRet);
        if (bNullSafe) {
            return this.buildComposite(new IRElement[]{tempLhsInitAssn, tempRhsInitAssn, this.buildCast(ArithmeticExpressionTransformer.getDescriptor(bigType), this.buildTernary((IRExpression)(lhs.getType().isPrimitive() ? this.booleanLiteral(false) : this.buildEquals((IRExpression)this.identifier(tempLhsInit), this.nullLiteral())), this.nullLiteral(), this.buildTernary((IRExpression)(rhs.getType().isPrimitive() ? this.booleanLiteral(false) : this.buildEquals((IRExpression)this.identifier(tempRhsInit), this.nullLiteral())), this.nullLiteral(), (IRExpression)this.buildComposite(new IRElement[]{tempLhsRetAssn, tempRhsRetAssn, this.makeBigExpression(bigClass, (IRExpression)this.identifier(tempLhsRet), (IRExpression)this.identifier(tempRhsRet), strOp)}), ArithmeticExpressionTransformer.getDescriptor(bigType)), ArithmeticExpressionTransformer.getDescriptor(bigType)))});
        }
        return this.buildComposite(new IRElement[]{tempLhsInitAssn, tempRhsInitAssn, tempLhsRetAssn, tempRhsRetAssn, this.makeBigExpression(bigClass, (IRExpression)this.identifier(tempLhsRet), (IRExpression)this.identifier(tempRhsRet), strOp)});
    }

    final IRExpression bigArithmetic() {
        Class bigClass;
        IType bigType = ((ArithmeticExpression)this._expr()).getType();
        Class clazz = bigClass = bigType == JavaTypes.BIG_INTEGER() ? BigInteger.class : BigDecimal.class;
        assert (bigType == JavaTypes.BIG_INTEGER() || bigType == JavaTypes.BIG_DECIMAL());
        IRExpression lhs = ExpressionTransformer.compile(((ArithmeticExpression)this._expr()).getLHS(), this._cc());
        IRExpression rhs = ExpressionTransformer.compile(((ArithmeticExpression)this._expr()).getRHS(), this._cc());
        if (((ArithmeticExpression)this._expr()).isNullSafe()) {
            IRSymbol tempLhs = this._cc().makeAndIndexTempSymbol(ArithmeticExpressionTransformer.getDescriptor(bigType));
            IRAssignmentStatement tempLhsAssn = this.buildAssignment(tempLhs, lhs);
            IRSymbol tempRhs = this._cc().makeAndIndexTempSymbol(ArithmeticExpressionTransformer.getDescriptor(bigType));
            IRAssignmentStatement tempRhsAssn = this.buildAssignment(tempRhs, rhs);
            return this.buildComposite(new IRElement[]{tempLhsAssn, tempRhsAssn, this.buildCast(ArithmeticExpressionTransformer.getDescriptor(bigType), this.buildTernary((IRExpression)this.buildEquals((IRExpression)this.identifier(tempLhs), this.nullLiteral()), this.nullLiteral(), this.buildTernary((IRExpression)this.buildEquals((IRExpression)this.identifier(tempRhs), this.nullLiteral()), this.nullLiteral(), this.makeBigExpression(bigClass, (IRExpression)this.identifier(tempLhs), (IRExpression)this.identifier(tempRhs), ((ArithmeticExpression)this._expr()).getOperator()), ArithmeticExpressionTransformer.getDescriptor(bigType)), ArithmeticExpressionTransformer.getDescriptor(bigType)))});
        }
        return this.makeBigExpression(bigClass, lhs, rhs, ((ArithmeticExpression)this._expr()).getOperator());
    }

    final IRExpression makeBigExpression(Class bigClass, IRExpression lhs, IRExpression rhs, String strOp) {
        if (bigClass == BigDecimal.class) {
            return this.bigDecimalArithmetic(lhs, rhs, strOp);
        }
        return this.bigIntegerArithmetic(lhs, rhs, strOp);
    }

    final IRExpression bigDecimalArithmetic(IRExpression lhs, IRExpression rhs, String strOp) {
        if (strOp.equals("+") || strOp.equals("?+") || strOp.equals("!+")) {
            return this.callMethod(BigDecimal.class, "add", new Class[]{BigDecimal.class}, lhs, Collections.singletonList(rhs));
        }
        if (strOp.equals("-") || strOp.equals("?-") || strOp.equals("!-")) {
            return this.callMethod(BigDecimal.class, "subtract", new Class[]{BigDecimal.class}, lhs, Collections.singletonList(rhs));
        }
        if (strOp.equals("*") || strOp.equals("?*") || strOp.equals("!*")) {
            return this.callMethod(BigDecimal.class, "multiply", new Class[]{BigDecimal.class}, lhs, Collections.singletonList(rhs));
        }
        if (strOp.equals("/") || strOp.equals("?/")) {
            return this.callMethod(BigDecimal.class, "divide", new Class[]{BigDecimal.class, MathContext.class}, lhs, Arrays.asList(rhs, this.getStaticField(TypeSystem.get(MathContext.class), "DECIMAL128", JavaClassIRType.get(MathContext.class), IRelativeTypeInfo.Accessibility.PUBLIC)));
        }
        if (strOp.equals("%") || strOp.equals("?%")) {
            IRExpression remainder = this.callMethod(BigDecimal.class, "remainder", new Class[]{BigDecimal.class, MathContext.class}, lhs, Arrays.asList(rhs, this.getStaticField(TypeSystem.get(MathContext.class), "DECIMAL128", JavaClassIRType.get(MathContext.class), IRelativeTypeInfo.Accessibility.PUBLIC)));
            return this.callMethod(BigDecimal.class, "abs", new Class[0], remainder, Collections.emptyList());
        }
        throw new IllegalStateException();
    }

    final IRExpression bigIntegerArithmetic(IRExpression lhs, IRExpression rhs, String strOp) {
        if (strOp.equals("+") || strOp.equals("?+") || strOp.equals("!+")) {
            return this.callMethod(BigInteger.class, "add", new Class[]{BigInteger.class}, lhs, Collections.singletonList(rhs));
        }
        if (strOp.equals("-") || strOp.equals("?-") || strOp.equals("!-")) {
            return this.callMethod(BigInteger.class, "subtract", new Class[]{BigInteger.class}, lhs, Collections.singletonList(rhs));
        }
        if (strOp.equals("*") || strOp.equals("?*") || strOp.equals("!*")) {
            return this.callMethod(BigInteger.class, "multiply", new Class[]{BigInteger.class}, lhs, Collections.singletonList(rhs));
        }
        if (strOp.equals("/") || strOp.equals("?/")) {
            return this.callMethod(BigInteger.class, "divide", new Class[]{BigInteger.class}, lhs, Collections.singletonList(rhs));
        }
        if (strOp.equals("%") || strOp.equals("?%")) {
            return this.callMethod(BigInteger.class, "mod", new Class[]{BigInteger.class}, lhs, Collections.singletonList(rhs));
        }
        throw new IllegalStateException();
    }

    final IRExpression primitiveArithmetic() {
        IType type = ((ArithmeticExpression)this._expr()).getType();
        IRExpression lhs = ExpressionTransformer.compile(((ArithmeticExpression)this._expr()).getLHS(), this._cc());
        lhs = this.numberConvert(((ArithmeticExpression)this._expr()).getLHS().getType(), type, lhs);
        IRExpression rhs = ExpressionTransformer.compile(((ArithmeticExpression)this._expr()).getRHS(), this._cc());
        rhs = this.numberConvert(((ArithmeticExpression)this._expr()).getRHS().getType(), type, rhs);
        return this.makeIRArithmeticExpression(type, lhs, rhs, this.isCheckedArithmeticEnabled());
    }

    private IRExpression makeIRArithmeticExpression(IType type, IRExpression lhs, IRExpression rhs, boolean checked) {
        IRType descriptor = ArithmeticExpressionTransformer.getDescriptor(type);
        IRArithmeticExpression.Operation op = IRArithmeticExpression.Operation.fromString((String)((ArithmeticExpression)this._expr()).getOperator());
        if (checked && (type == JavaTypes.pINT() || type == JavaTypes.pLONG()) && !((ArithmeticExpression)this._expr()).isUnchecked()) {
            Class[] classArray;
            if (type == JavaTypes.pINT()) {
                Class[] classArray2 = new Class[2];
                classArray2[0] = Integer.TYPE;
                classArray = classArray2;
                classArray2[1] = Integer.TYPE;
            } else {
                Class[] classArray3 = new Class[2];
                classArray3[0] = Long.TYPE;
                classArray = classArray3;
                classArray3[1] = Long.TYPE;
            }
            Class[] paramTypes = classArray;
            switch (op) {
                case Addition: {
                    return this.callStaticMethod(Math.class, "addExact", paramTypes, Arrays.asList(lhs, rhs));
                }
                case Subtraction: {
                    return this.callStaticMethod(Math.class, "subtractExact", paramTypes, Arrays.asList(lhs, rhs));
                }
                case Multiplication: {
                    return this.callStaticMethod(Math.class, "multiplyExact", paramTypes, Arrays.asList(lhs, rhs));
                }
            }
            return new IRArithmeticExpression(descriptor, lhs, rhs, op);
        }
        return new IRArithmeticExpression(descriptor, lhs, rhs, op);
    }
}

