/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.expression;

import gw.internal.gosu.ir.transform.ExpressionTransformer;
import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.expression.AbstractExpressionTransformer;
import gw.internal.gosu.parser.expressions.IntervalExpression;
import gw.lang.ir.IRExpression;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.interval.BigDecimalInterval;
import gw.lang.reflect.interval.BigIntegerInterval;
import gw.lang.reflect.interval.ComparableInterval;
import gw.lang.reflect.interval.DateInterval;
import gw.lang.reflect.interval.ISequenceable;
import gw.lang.reflect.interval.IntegerInterval;
import gw.lang.reflect.interval.LongInterval;
import gw.lang.reflect.interval.SequenceableInterval;
import gw.lang.reflect.java.JavaTypes;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;

public class IntervalExpressionTransformer
extends AbstractExpressionTransformer<IntervalExpression> {
    public static IRExpression compile(TopLevelTransformationContext cc, IntervalExpression expr) {
        IntervalExpressionTransformer gen = new IntervalExpressionTransformer(cc, expr);
        return gen.compile();
    }

    private IntervalExpressionTransformer(TopLevelTransformationContext cc, IntervalExpression expr) {
        super(cc, expr);
    }

    @Override
    protected IRExpression compile_impl() {
        IType type = ((IntervalExpression)this._expr()).getType();
        if (type == JavaTypes.INTEGER_INTERVAL()) {
            return this.makeIntegerInterval();
        }
        if (type == JavaTypes.LONG_INTERVAL()) {
            return this.makeLongInterval();
        }
        if (type == JavaTypes.BIG_INTEGER_INTERVAL()) {
            return this.makeBigIntegerInterval();
        }
        if (type == JavaTypes.BIG_DECIMAL_INTERVAL()) {
            return this.makeBigDecimalInterval();
        }
        if (type == JavaTypes.DATE_INTERVAL()) {
            return this.makeDateInterval();
        }
        if (type.getGenericType() == JavaTypes.SEQUENCEABLE_INTERVAL()) {
            return this.makeSequenceableInterval();
        }
        if (type.getGenericType() == JavaTypes.COMPARABLE_INTERVAL()) {
            return this.makeComparableInterval();
        }
        throw new IllegalStateException("Unknown interval type: " + type.getName());
    }

    private IRExpression makeIntegerInterval() {
        ArrayList<IRExpression> args = new ArrayList<IRExpression>();
        args.add(this.boxValue(((IntervalExpression)this._expr()).getLHS().getType(), ExpressionTransformer.compile(((IntervalExpression)this._expr()).getLHS(), this._cc())));
        args.add(this.boxValue(((IntervalExpression)this._expr()).getRHS().getType(), ExpressionTransformer.compile(((IntervalExpression)this._expr()).getRHS(), this._cc())));
        args.add(this.boxValue((IType)JavaTypes.pINT(), this.pushConstant(1)));
        args.add(this.pushConstant(((IntervalExpression)this._expr()).isLeftClosed()));
        args.add(this.pushConstant(((IntervalExpression)this._expr()).isRightClosed()));
        return this.callStaticMethod(IntervalExpressionTransformer.class, "_makeIntegerInterval", new Class[]{Object.class, Object.class, Integer.class, Boolean.TYPE, Boolean.TYPE}, args);
    }

    private IRExpression makeLongInterval() {
        ArrayList<IRExpression> args = new ArrayList<IRExpression>();
        args.add(this.boxValue(((IntervalExpression)this._expr()).getLHS().getType(), ExpressionTransformer.compile(((IntervalExpression)this._expr()).getLHS(), this._cc())));
        args.add(this.boxValue(((IntervalExpression)this._expr()).getRHS().getType(), ExpressionTransformer.compile(((IntervalExpression)this._expr()).getRHS(), this._cc())));
        args.add(this.boxValue((IType)JavaTypes.pLONG(), this.pushConstant(1L)));
        args.add(this.pushConstant(((IntervalExpression)this._expr()).isLeftClosed()));
        args.add(this.pushConstant(((IntervalExpression)this._expr()).isRightClosed()));
        return this.callStaticMethod(IntervalExpressionTransformer.class, "_makeLongInterval", new Class[]{Long.class, Long.class, Long.class, Boolean.TYPE, Boolean.TYPE}, args);
    }

    private IRExpression makeBigIntegerInterval() {
        ArrayList<IRExpression> args = new ArrayList<IRExpression>();
        args.add(ExpressionTransformer.compile(((IntervalExpression)this._expr()).getLHS(), this._cc()));
        args.add(ExpressionTransformer.compile(((IntervalExpression)this._expr()).getRHS(), this._cc()));
        args.add(this.getStaticField((IType)JavaTypes.BIG_INTEGER(), "ONE", IntervalExpressionTransformer.getDescriptor((IType)JavaTypes.BIG_INTEGER()), IRelativeTypeInfo.Accessibility.PUBLIC));
        args.add(this.pushConstant(((IntervalExpression)this._expr()).isLeftClosed()));
        args.add(this.pushConstant(((IntervalExpression)this._expr()).isRightClosed()));
        return this.callStaticMethod(IntervalExpressionTransformer.class, "_makeBigIntegerInterval", new Class[]{BigInteger.class, BigInteger.class, BigInteger.class, Boolean.TYPE, Boolean.TYPE}, args);
    }

    private IRExpression makeBigDecimalInterval() {
        ArrayList<IRExpression> args = new ArrayList<IRExpression>();
        args.add(ExpressionTransformer.compile(((IntervalExpression)this._expr()).getLHS(), this._cc()));
        args.add(ExpressionTransformer.compile(((IntervalExpression)this._expr()).getRHS(), this._cc()));
        args.add(this.getStaticField((IType)JavaTypes.BIG_DECIMAL(), "ONE", IntervalExpressionTransformer.getDescriptor((IType)JavaTypes.BIG_DECIMAL()), IRelativeTypeInfo.Accessibility.PUBLIC));
        args.add(this.pushConstant(((IntervalExpression)this._expr()).isLeftClosed()));
        args.add(this.pushConstant(((IntervalExpression)this._expr()).isRightClosed()));
        return this.callStaticMethod(IntervalExpressionTransformer.class, "_makeBigDecimalInterval", new Class[]{Number.class, Number.class, BigDecimal.class, Boolean.TYPE, Boolean.TYPE}, args);
    }

    private IRExpression makeDateInterval() {
        ArrayList<IRExpression> args = new ArrayList<IRExpression>();
        args.add(ExpressionTransformer.compile(((IntervalExpression)this._expr()).getLHS(), this._cc()));
        args.add(ExpressionTransformer.compile(((IntervalExpression)this._expr()).getRHS(), this._cc()));
        args.add(this.pushNull());
        args.add(this.pushConstant(((IntervalExpression)this._expr()).isLeftClosed()));
        args.add(this.pushConstant(((IntervalExpression)this._expr()).isRightClosed()));
        return this.callStaticMethod(IntervalExpressionTransformer.class, "_makeDateInterval", new Class[]{Date.class, Date.class, Integer.class, Boolean.TYPE, Boolean.TYPE}, args);
    }

    private IRExpression makeSequenceableInterval() {
        ArrayList<IRExpression> args = new ArrayList<IRExpression>();
        args.add(ExpressionTransformer.compile(((IntervalExpression)this._expr()).getLHS(), this._cc()));
        args.add(ExpressionTransformer.compile(((IntervalExpression)this._expr()).getRHS(), this._cc()));
        args.add(this.pushConstant(((IntervalExpression)this._expr()).isLeftClosed()));
        args.add(this.pushConstant(((IntervalExpression)this._expr()).isRightClosed()));
        return this.callStaticMethod(IntervalExpressionTransformer.class, "_makeSequenceableInterval", new Class[]{ISequenceable.class, ISequenceable.class, Boolean.TYPE, Boolean.TYPE}, args);
    }

    private IRExpression makeComparableInterval() {
        ArrayList<IRExpression> args = new ArrayList<IRExpression>();
        args.add(ExpressionTransformer.compile(((IntervalExpression)this._expr()).getLHS(), this._cc()));
        args.add(ExpressionTransformer.compile(((IntervalExpression)this._expr()).getRHS(), this._cc()));
        args.add(this.pushConstant(((IntervalExpression)this._expr()).isLeftClosed()));
        args.add(this.pushConstant(((IntervalExpression)this._expr()).isRightClosed()));
        return this.callStaticMethod(IntervalExpressionTransformer.class, "_makeComparableInterval", new Class[]{Comparable.class, Comparable.class, Boolean.TYPE, Boolean.TYPE}, args);
    }

    public static IntegerInterval _makeIntegerInterval(Object lhs, Object rhs, Integer step, boolean bLeftClosed, boolean bRightClosed) {
        if (lhs instanceof Character) {
            lhs = (int)((Character)lhs).charValue();
        }
        if (rhs instanceof Character) {
            rhs = (int)((Character)rhs).charValue();
        }
        int iLhs = ((Number)lhs).intValue();
        int iRhs = ((Number)rhs).intValue();
        if (iRhs < iLhs) {
            return new IntegerInterval(Integer.valueOf(iRhs), Integer.valueOf(iLhs), step.intValue(), bLeftClosed, bRightClosed, true);
        }
        return new IntegerInterval(Integer.valueOf(iLhs), Integer.valueOf(iRhs), step.intValue(), bLeftClosed, bRightClosed, false);
    }

    public static LongInterval _makeLongInterval(Long lhs, Long rhs, Long step, boolean bLeftClosed, boolean bRightClosed) {
        if (rhs < lhs) {
            return new LongInterval(rhs, lhs, step.longValue(), bLeftClosed, bRightClosed, true);
        }
        return new LongInterval(lhs, rhs, step.longValue(), bLeftClosed, bRightClosed, false);
    }

    public static BigIntegerInterval _makeBigIntegerInterval(BigInteger lhs, BigInteger rhs, BigInteger step, boolean bLeftClosed, boolean bRightClosed) {
        if (rhs.compareTo(lhs) < 0) {
            return new BigIntegerInterval(rhs, lhs, step, bLeftClosed, bRightClosed, true);
        }
        return new BigIntegerInterval(lhs, rhs, step, bLeftClosed, bRightClosed, false);
    }

    public static BigDecimalInterval _makeBigDecimalInterval(Number lhs, Number rhs, BigDecimal step, boolean bLeftClosed, boolean bRightClosed) {
        BigDecimal bigrhs;
        BigDecimal biglhs;
        BigDecimal bigDecimal = biglhs = lhs instanceof BigDecimal ? (BigDecimal)lhs : new BigDecimal(lhs.toString());
        BigDecimal bigDecimal2 = rhs instanceof BigDecimal ? (BigDecimal)rhs : (bigrhs = new BigDecimal(rhs.doubleValue() == Double.POSITIVE_INFINITY ? "1E+1000" : rhs.toString()));
        if (bigrhs.compareTo(biglhs) < 0) {
            return new BigDecimalInterval(bigrhs, biglhs, step, bLeftClosed, bRightClosed, true);
        }
        return new BigDecimalInterval(biglhs, bigrhs, step, bLeftClosed, bRightClosed, false);
    }

    public static SequenceableInterval _makeSequenceableInterval(ISequenceable lhs, ISequenceable rhs, boolean bLeftClosed, boolean bRightClosed) {
        if (rhs.compareTo(lhs) < 0) {
            return new SequenceableInterval(rhs, lhs, null, null, bLeftClosed, bRightClosed, true);
        }
        return new SequenceableInterval(lhs, rhs, null, null, bLeftClosed, bRightClosed, false);
    }

    public static ComparableInterval _makeComparableInterval(Comparable lhs, Comparable rhs, boolean bLeftClosed, boolean bRightClosed) {
        if (rhs.compareTo(lhs) < 0) {
            return new ComparableInterval(rhs, lhs, bLeftClosed, bRightClosed, true);
        }
        return new ComparableInterval(lhs, rhs, bLeftClosed, bRightClosed, false);
    }

    public static DateInterval _makeDateInterval(Date lhs, Date rhs, Integer step, boolean bLeftClosed, boolean bRightClosed) {
        if (step == null) {
            step = 1;
        }
        if (rhs.compareTo(lhs) < 0) {
            return new DateInterval(rhs, lhs, step.intValue(), null, bLeftClosed, bRightClosed, true);
        }
        return new DateInterval(lhs, rhs, step.intValue(), null, bLeftClosed, bRightClosed, false);
    }
}

