/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.statement;

import gw.internal.gosu.ir.transform.ExpressionTransformer;
import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.statement.AbstractStatementTransformer;
import gw.internal.gosu.parser.BeanAccess;
import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.Statement;
import gw.internal.gosu.parser.statements.CaseClause;
import gw.internal.gosu.parser.statements.SwitchStatement;
import gw.internal.gosu.parser.statements.VarInitializationVerifier;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRStatement;
import gw.lang.ir.IRSymbol;
import gw.lang.ir.statement.IRAssignmentStatement;
import gw.lang.ir.statement.IRBreakStatement;
import gw.lang.ir.statement.IRCaseClause;
import gw.lang.ir.statement.IRSwitchStatement;
import gw.lang.reflect.IType;
import gw.lang.reflect.java.JavaTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SwitchStatementTransformer
extends AbstractStatementTransformer<SwitchStatement> {
    public static IRStatement compile(TopLevelTransformationContext cc, SwitchStatement stmt) {
        SwitchStatementTransformer compiler = new SwitchStatementTransformer(cc, stmt);
        return compiler.compile();
    }

    private SwitchStatementTransformer(TopLevelTransformationContext cc, SwitchStatement stmt) {
        super(cc, stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IRStatement compile_impl() {
        IType switchType = ((SwitchStatement)this._stmt()).getSwitchExpression().getType();
        IRExpression root = ExpressionTransformer.compile(((SwitchStatement)this._stmt()).getSwitchExpression(), this._cc());
        IRSymbol tempRoot = this._cc().makeAndIndexTempSymbol(root.getType());
        IRAssignmentStatement init = this.buildAssignment(tempRoot, root);
        ArrayList<IRCaseClause> irCases = new ArrayList<IRCaseClause>();
        CaseClause[] cases = ((SwitchStatement)this._stmt()).getCases();
        if (cases != null && cases.length > 0) {
            for (int i = 0; i < cases.length; ++i) {
                Expression caseExpression = cases[i].getExpression();
                IRExpression caseTest = !(!SwitchStatementTransformer.isIntType(switchType) && switchType != JavaTypes.pBOOLEAN() || !SwitchStatementTransformer.isIntType(caseExpression.getType()) && caseExpression.getType() != JavaTypes.pBOOLEAN()) ? this.compileCaseExpr_int(tempRoot, caseExpression) : this.compileCaseExpr_ref(switchType, tempRoot, caseExpression);
                List<Statement> caseStatements = cases[i].getStatements();
                ArrayList<IRStatement> irCaseStatements = new ArrayList<IRStatement>();
                if (caseStatements != null) {
                    this._cc().pushScope(false);
                    try {
                        for (Statement caseStatement : caseStatements) {
                            irCaseStatements.add(this._cc().compile(caseStatement));
                        }
                    }
                    finally {
                        this._cc().popScope();
                    }
                }
                irCases.add(new IRCaseClause(caseTest, irCaseStatements));
            }
        }
        List<Statement> defaultStmts = ((SwitchStatement)this._stmt()).getDefaultStatements();
        ArrayList<Object> irDefaultStatements = new ArrayList<Object>();
        if (defaultStmts != null) {
            for (Statement defaultStatement : defaultStmts) {
                irDefaultStatements.add(this._cc().compile(defaultStatement));
            }
        } else if (((SwitchStatement)this._stmt()).isCoveredEnumSwitch()) {
            IRCaseClause lastIrCase = (IRCaseClause)irCases.get(irCases.size() - 1);
            CaseClause lastCase = cases[cases.length - 1];
            List statements = lastCase.getStatements();
            if (!VarInitializationVerifier.doStatementsTerminate(statements)) {
                lastIrCase.getStatements().add(new IRBreakStatement());
            }
            irDefaultStatements.add(this.buildIfElse((IRExpression)this.buildEquals((IRExpression)this.identifier(tempRoot), this.pushNull()), (IRStatement)this.buildThrow(this.buildNewExpression(NullPointerException.class, new Class[]{String.class}, Collections.singletonList(this.pushConstant("null case unhandled for enum type")))), (IRStatement)this.buildThrow(this.buildNewExpression(IllegalStateException.class, new Class[]{String.class}, Collections.singletonList(this.pushConstant("Enum constant unhandled, recompile with new version of enum class"))))));
        }
        return new IRSwitchStatement((IRStatement)init, irCases, irDefaultStatements);
    }

    private IRExpression compileCaseExpr_int(IRSymbol tempRoot, Expression caseExpression) {
        return this.buildEquals((IRExpression)this.identifier(tempRoot), ExpressionTransformer.compile(caseExpression, this._cc()));
    }

    private IRExpression compileCaseExpr_ref(IType switchType, IRSymbol tempRoot, Expression caseExpression) {
        if (switchType == caseExpression.getType() && SwitchStatementTransformer.isBytecodeType(switchType)) {
            return this.callStaticMethod(this.getClass(), "areEqual", new Class[]{Object.class, Object.class}, SwitchStatementTransformer.exprList(new IRExpression[]{this.identifier(tempRoot), ExpressionTransformer.compile(caseExpression, this._cc())}));
        }
        return this.callStaticMethod(BeanAccess.class, "areValuesEqual", new Class[]{IType.class, Object.class, IType.class, Object.class}, SwitchStatementTransformer.exprList(new IRExpression[]{this.pushType(switchType), this.identifier(tempRoot), this.pushType(caseExpression.getType()), ExpressionTransformer.compile(caseExpression, this._cc())}));
    }

    public static boolean areEqual(Object p1, Object p2) {
        return p1 == null && p2 == null || p1 != null && p2 != null && p1.equals(p2);
    }
}

