/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.statement;

import gw.internal.gosu.ir.transform.ExpressionTransformer;
import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.statement.AbstractStatementTransformer;
import gw.internal.gosu.parser.statements.ThrowStatement;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRStatement;
import gw.lang.ir.IRSymbol;
import gw.lang.ir.expression.IRInstanceOfExpression;
import gw.lang.ir.statement.IRAssignmentStatement;
import gw.lang.ir.statement.IRIfStatement;
import gw.lang.ir.statement.IRStatementList;
import gw.lang.ir.statement.IRThrowStatement;
import gw.lang.parser.EvaluationException;
import gw.lang.reflect.java.JavaTypes;

public class ThrowStatementTransformer
extends AbstractStatementTransformer<ThrowStatement> {
    public static IRStatement compile(TopLevelTransformationContext cc, ThrowStatement stmt) {
        ThrowStatementTransformer compiler = new ThrowStatementTransformer(cc, stmt);
        return compiler.compile();
    }

    private ThrowStatementTransformer(TopLevelTransformationContext cc, ThrowStatement stmt) {
        super(cc, stmt);
    }

    @Override
    protected IRStatement compile_impl() {
        IRExpression exceptionValue = ExpressionTransformer.compile(((ThrowStatement)this._stmt()).getExpression(), this._cc());
        if (JavaTypes.THROWABLE().isAssignableFrom(((ThrowStatement)this._stmt()).getExpression().getType())) {
            if (!ThrowStatementTransformer.getDescriptor(Throwable.class).isAssignableFrom(exceptionValue.getType())) {
                exceptionValue = this.buildCast(ThrowStatementTransformer.getDescriptor(Throwable.class), exceptionValue);
            }
            return this.buildThrow(exceptionValue);
        }
        IRSymbol temp = this._cc().makeAndIndexTempSymbol(ThrowStatementTransformer.getDescriptor(((ThrowStatement)this._stmt()).getExpression().getType()));
        IRAssignmentStatement tempAssignment = this.buildAssignment(temp, exceptionValue);
        IRInstanceOfExpression test = new IRInstanceOfExpression((IRExpression)this.identifier(temp), ThrowStatementTransformer.getDescriptor(Throwable.class));
        IRThrowStatement trueCase = this.buildThrow(this.checkCast(Throwable.class, (IRExpression)this.identifier(temp)));
        IRThrowStatement falseCase = this.buildThrow(this.buildNewExpression(EvaluationException.class, new Class[]{String.class}, ThrowStatementTransformer.exprList(this.checkCast(String.class, (IRExpression)this.identifier(temp)))));
        IRIfStatement ifStatement = this.buildIfElse((IRExpression)test, (IRStatement)trueCase, (IRStatement)falseCase);
        return new IRStatementList(false, new IRStatement[]{tempAssignment, ifStatement});
    }
}

