/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.config.ExecutionMode;
import gw.fs.IFile;
import gw.internal.gosu.parser.ClassPath;
import gw.internal.gosu.parser.Primitives;
import gw.lang.reflect.IInjectableClassLoader;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.TypeName;
import gw.lang.reflect.java.asm.AsmClass;
import gw.lang.reflect.java.asm.AsmClassLoader;
import gw.lang.reflect.module.IClassPath;
import gw.lang.reflect.module.IModule;
import gw.util.concurrent.LockingLazyVar;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ClassCache {
    private final Map<String, Class> _classMap = new HashMap<String, Class>();
    private Set<CharSequence> _packages = new HashSet<CharSequence>();
    private IModule _module;
    private LockingLazyVar<ClassPath> _classPathCache;
    private LockingLazyVar<Set<String>> _allTypeNamesCache = new LockingLazyVar<Set<String>>(){

        protected Set<String> init() {
            HashSet<String> strings = new HashSet<String>();
            Set<String> filteredClassNames = ((ClassPath)ClassCache.this._classPathCache.get()).getFilteredClassNames();
            for (String className : filteredClassNames) {
                strings.add(className.replace('$', '.'));
            }
            return strings;
        }
    };
    private AsmClassLoader _asmClassLoader;
    private boolean ignoreTheCache;
    private static Method _getPackageMethod = null;

    public ClassCache(IModule module) {
        this._module = module;
        this.ignoreTheCache = ExecutionMode.isRuntime();
        this._classPathCache = new LockingLazyVar<ClassPath>(){

            protected ClassPath init() {
                return new ClassPath(ClassCache.this._module, ExecutionMode.isRuntime() ? IClassPath.ONLY_API_CLASSES : IClassPath.ALLOW_ALL_WITH_SUN_FILTER);
            }
        };
        this._asmClassLoader = new AsmClassLoader((Object)this._module);
    }

    private Class tryToLoadClass(CharSequence name) {
        if (this._packages.contains(name)) {
            return ClassNotFoundMarkerClass.class;
        }
        try {
            Class<?> cls;
            try {
                cls = this._module.getModuleClassLoader().loadClass(name.toString());
            }
            catch (ClassNotFoundException cnfe) {
                return ClassNotFoundMarkerClass.class;
            }
            if (cls == null) {
                return ClassNotFoundMarkerClass.class;
            }
            if (!cls.isArray() && !cls.isPrimitive()) {
                this.addFoundPackages(cls);
            }
            return cls;
        }
        catch (VerifyError e) {
            return VerifyError.class;
        }
    }

    private void addFoundPackages(Class<?> aClass) {
        String packageName = aClass.getName();
        if (packageName.contains(".")) {
            packageName = packageName.substring(0, packageName.lastIndexOf(46));
            int dotIndex = 0;
            while (dotIndex != -1) {
                int nextDot = packageName.indexOf(46, dotIndex);
                this._packages.add(packageName.subSequence(0, nextDot == -1 ? packageName.length() : nextDot));
                dotIndex = nextDot == -1 ? -1 : nextDot + 1;
            }
        }
    }

    public AsmClass loadAsmClass(String className) {
        int i;
        AsmClass primitiveClazz = AsmClass.findPrimitive((String)className);
        try {
            IModule jreModule = this._module.getExecutionEnvironment().getJreModule();
            if (jreModule == this._module && primitiveClazz != null) {
                return primitiveClazz;
            }
        }
        catch (Exception jreModule) {
            // empty catch block
        }
        if (((ClassPath)this._classPathCache.get()).isEmpty()) {
            return null;
        }
        StringBuilder s = new StringBuilder(className);
        do {
            IFile file;
            if ((this.ignoreTheCache || ((ClassPath)this._classPathCache.get()).contains(className)) && (file = ((ClassPath)this._classPathCache.get()).get(className)) != null) {
                try {
                    return this._asmClassLoader.findClass(className, file.openInputStream());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            i = s.lastIndexOf(".");
            if (i < 0) continue;
            if (this.isPackage(s, i)) {
                return null;
            }
            s.setCharAt(i, '$');
            className = s.toString();
        } while (i >= 0);
        return null;
    }

    public Class loadClass(String className) {
        int i;
        Class primitiveClazz = Primitives.get(className);
        if (this._module.getExecutionEnvironment().getJreModule() == this._module && primitiveClazz != null) {
            return primitiveClazz;
        }
        StringBuilder s = new StringBuilder(className);
        do {
            Class aClass;
            boolean isInClassPathCache = ((ClassPath)this._classPathCache.get()).contains(className);
            if ((this.ignoreTheCache || isInClassPathCache) && (aClass = this.loadClassImplImpl(className)) != null) {
                return aClass;
            }
            i = s.lastIndexOf(".");
            if (i < 0) continue;
            if (this.isPackage(s, i)) {
                return null;
            }
            s.setCharAt(i, '$');
            className = s.toString();
        } while (i >= 0);
        return null;
    }

    private boolean isPackage(StringBuilder s, int i) {
        try {
            String maybePackage = s.substring(0, i);
            if (this.getPackageMethod().invoke((Object)this._module.getModuleClassLoader(), maybePackage) != null) {
                return true;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    private Method getPackageMethod() {
        if (_getPackageMethod == null) {
            try {
                _getPackageMethod = ClassLoader.class.getDeclaredMethod("getPackage", String.class);
                _getPackageMethod.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
        return _getPackageMethod;
    }

    private Class loadClassImplImpl(String type) {
        Class clazz = this._classMap.get(type = ClassCache.normalizeArrayNotation(type));
        if (clazz == null) {
            TypeSystem.lock();
            try {
                clazz = this._classMap.get(type);
                if (clazz == null) {
                    clazz = this.tryToLoadClass(type);
                    this._classMap.put(type, clazz);
                }
            }
            finally {
                TypeSystem.unlock();
            }
        }
        if (clazz != ClassNotFoundMarkerClass.class) {
            return clazz;
        }
        return null;
    }

    private static String normalizeArrayNotation(String type) {
        int arrayDimensions = 0;
        while (type.endsWith("[]")) {
            type = type.substring(0, type.length() - 2);
            ++arrayDimensions;
        }
        if (arrayDimensions == 0) {
            return type;
        }
        String arraySignature = Primitives.getArraySignature(type);
        type = arraySignature != null ? arraySignature : "[L" + type + ";";
        for (int i = 1; i < arrayDimensions; ++i) {
            type = "[" + type;
        }
        return type;
    }

    public Set<String> getAllTypeNames() {
        return (Set)this._allTypeNamesCache.get();
    }

    public void clearClasspathInfo() {
        this._allTypeNamesCache.clear();
    }

    public void remove(String fullyQualifiedName) {
        TypeSystem.lock();
        try {
            this._classMap.remove(fullyQualifiedName);
        }
        finally {
            TypeSystem.unlock();
        }
    }

    public void dispose() {
        this._module.disposeLoader();
    }

    public void reassignClassLoader() {
        ClassLoader loader = this._module.getModuleClassLoader();
        if (loader.getParent() instanceof IInjectableClassLoader) {
            ((IInjectableClassLoader)loader.getParent()).dispose();
            this._module.disposeLoader();
        }
    }

    public boolean hasNamespace(String namespace) {
        return ((ClassPath)this._classPathCache.get()).hasNamespace(namespace);
    }

    public Set<TypeName> getTypeNames(String namespace) {
        return ((ClassPath)this._classPathCache.get()).getTypeNames(namespace);
    }

    private static final class ClassNotFoundMarkerClass {
        private ClassNotFoundMarkerClass() {
        }
    }
}

