/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.IGosuClassInternal;
import gw.lang.reflect.DefaultArrayType;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeLoader;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGosuArrayClass;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.util.Pair;
import gw.util.concurrent.LockingLazyVar;
import java.lang.reflect.Array;

public class GosuArrayClass
extends DefaultArrayType
implements IGosuArrayClass {
    private LockingLazyVar<IJavaClassInfo> _lazyConcreteClass;

    public GosuArrayClass(final IType componentType, ITypeLoader typeLoader) {
        super(componentType, null, typeLoader);
        this._lazyConcreteClass = new LockingLazyVar<IJavaClassInfo>(){

            protected IJavaClassInfo init() {
                Class<Object> componentClass = componentType instanceof IGosuClass ? ((IGosuClass)componentType).getBackingClass() : ((GosuArrayClass)componentType).getConcreteClass().getBackingClass();
                componentClass = Array.newInstance(componentClass, 0).getClass();
                return TypeSystem.getJavaClassInfo(componentClass);
            }
        };
    }

    protected IGosuArrayClass makeArrayType() {
        return (IGosuArrayClass)TypeSystem.getOrCreateTypeReference((IType)new GosuArrayClass((IType)TypeSystem.getOrCreateTypeReference((IType)this), this.getTypeLoader()));
    }

    public Object makeArrayInstance(int iLength) {
        Pair<Integer, Class> gosuClassDepthPair = this.getGosuClassDepthPair(this.getComponentType(), 2);
        Integer first = (Integer)gosuClassDepthPair.getFirst();
        return Array.newInstance((Class)gosuClassDepthPair.getSecond(), this.getDims(first, iLength));
    }

    private int[] getDims(Integer depth, int iLength) {
        int[] ints = new int[depth.intValue()];
        for (int i = 0; i < depth; ++i) {
            ints[i] = i == 0 ? iLength : 0;
        }
        return ints;
    }

    public Object getArrayComponent(Object array, int iIndex) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        return Array.get(array, iIndex);
    }

    public void setArrayComponent(Object array, int iIndex, Object value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Array.set(array, iIndex, value);
    }

    public int getArrayLength(Object array) throws IllegalArgumentException {
        return Array.getLength(array);
    }

    public boolean hasGosuClassAtRoot(IType component) {
        return this.getGosuClassDepthPair(component, 2) != null;
    }

    public IJavaClassInfo getConcreteClass() {
        return (IJavaClassInfo)this._lazyConcreteClass.get();
    }

    private Pair<Integer, Class> getGosuClassDepthPair(IType component, int depth) {
        if (component == null) {
            return null;
        }
        if (component instanceof IGosuClass) {
            return new Pair((Object)depth, (Object)((IGosuClassInternal)component).getBackingClass());
        }
        return this.getGosuClassDepthPair(component.getComponentType(), depth + 1);
    }
}

