/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.DefaultTypeLoader;
import gw.internal.gosu.parser.IJavaEnumTypeInternal;
import gw.internal.gosu.parser.JavaType;
import gw.lang.reflect.IEnumValue;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGosuObject;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaEnumType;
import gw.util.GosuObjectUtil;
import java.util.ArrayList;
import java.util.List;

public class JavaEnumType
extends JavaType
implements IJavaEnumTypeInternal,
IJavaEnumType {
    private List<IEnumValue> _enumVals;

    public JavaEnumType(Class cls, DefaultTypeLoader loader) {
        super(cls, loader);
    }

    public JavaEnumType(IJavaClassInfo cls, DefaultTypeLoader loader) {
        super(cls, loader);
    }

    @Override
    public IType getEnumType() {
        return TypeSystem.getOrCreateTypeReference((IType)this);
    }

    public List<String> getEnumConstants() {
        ArrayList<String> enumConstants = new ArrayList<String>();
        for (IEnumValue v : this.getEnumValues()) {
            enumConstants.add(v.getCode());
        }
        return enumConstants;
    }

    public List<IEnumValue> getEnumValues() {
        Object[] enumConstants;
        if (this._enumVals != null) {
            return this._enumVals;
        }
        ArrayList<IEnumValue> values = new ArrayList<IEnumValue>();
        for (Object enumConstant : enumConstants = this.getBackingClassInfo().getEnumConstants()) {
            if (enumConstant instanceof IEnumValue) {
                values.add((IEnumValue)enumConstant);
                continue;
            }
            if (!(enumConstant instanceof Enum)) continue;
            Enum e = (Enum)enumConstant;
            values.add(new EnumAdapter(e));
        }
        this._enumVals = values;
        return this._enumVals;
    }

    public IEnumValue getEnumValue(String strName) {
        for (IEnumValue val : this.getEnumValues()) {
            if (!GosuObjectUtil.equals((Object)val.getCode(), (Object)strName)) continue;
            return val;
        }
        return null;
    }

    private class EnumAdapter
    implements IEnumValue,
    IGosuObject {
        private Enum _enum;

        public EnumAdapter(Enum e) {
            this._enum = e;
        }

        public String getCode() {
            return this._enum.name();
        }

        public Object getValue() {
            return this._enum;
        }

        public int getOrdinal() {
            return this._enum.ordinal();
        }

        public String getDisplayName() {
            return this.getCode();
        }

        public IType getIntrinsicType() {
            return TypeSystem.getOrCreateTypeReference((IType)JavaEnumType.this);
        }
    }
}

