/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.AbstractDynamicSymbol;
import gw.internal.gosu.parser.DynamicFunctionSymbol;
import gw.internal.gosu.parser.IGosuAnnotation;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.Symbol;
import gw.lang.parser.IExpression;
import gw.lang.parser.IReducedSymbol;
import gw.lang.parser.IScriptPartId;
import gw.lang.parser.ISymbol;
import gw.lang.reflect.IType;
import gw.lang.reflect.Modifier;
import gw.lang.reflect.gs.IGenericTypeVariable;
import java.util.ArrayList;
import java.util.List;

public class ReducedSymbol
implements IReducedSymbol {
    private boolean _isStatic;
    private IType _type;
    private String _name;
    private String _displayName;
    protected String _fullDescription;
    private IScriptPartId _scriptPartId;
    private int _modifiers;
    private List<IGosuAnnotation> _annotations;
    private Class<?> _symClass;
    private IExpression _defValue;
    private boolean _bValueBoxed;
    private int _iIndex;

    ReducedSymbol(AbstractDynamicSymbol sym) {
        this._isStatic = sym.isStatic();
        this._name = sym.getName();
        this._displayName = sym.getDisplayName();
        this._type = sym.getType();
        this._scriptPartId = sym.getScriptPart();
        this._modifiers = sym.getModifierInfo().getModifiers();
        this._annotations = sym.getModifierInfo().getAnnotations();
        this._symClass = sym.getClass();
        this._bValueBoxed = sym.isValueBoxed();
        this._iIndex = sym.getIndex();
        if (sym instanceof DynamicFunctionSymbol) {
            this._defValue = ((DynamicFunctionSymbol)sym).getAnnotationDefault();
        }
    }

    public ReducedSymbol(ISymbol arg) {
        this._displayName = this._name = arg.getName();
        this._type = arg.getType();
        this._scriptPartId = arg.getScriptPart();
        this._defValue = arg.getDefaultValueExpression();
        this._modifiers = arg.getModifiers();
        this._annotations = arg.getAnnotations();
        this._symClass = arg.getClass();
        this._bValueBoxed = arg.isValueBoxed();
        this._iIndex = arg.getIndex();
    }

    public Class<?> getSymbolClass() {
        return this._symClass;
    }

    public boolean isValueBoxed() {
        return this._bValueBoxed;
    }

    public int getIndex() {
        return this._iIndex;
    }

    public IExpression getDefaultValueExpression() {
        return this._defValue;
    }

    public boolean isStatic() {
        return this._isStatic;
    }

    public int getModifiers() {
        return this._modifiers;
    }

    public List<IGosuAnnotation> getAnnotations() {
        return this._annotations;
    }

    public String getName() {
        return this._name;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public String getFullDescription() {
        return this._fullDescription;
    }

    public boolean isPrivate() {
        return Modifier.isPrivate((int)this.getModifiers());
    }

    public boolean isInternal() {
        return Modifier.isInternal((int)this.getModifiers());
    }

    public boolean isProtected() {
        return Modifier.isProtected((int)this.getModifiers());
    }

    public boolean isPublic() {
        return Modifier.isPublic((int)this.getModifiers()) || !this.isPrivate() && !this.isProtected() && !this.isInternal();
    }

    public boolean isAbstract() {
        return Modifier.isAbstract((int)this.getModifiers());
    }

    public boolean isFinal() {
        return Modifier.isFinal((int)this.getModifiers());
    }

    public IType getType() {
        return this._type;
    }

    void setType(IType type) {
        this._type = type;
    }

    public IScriptPartId getScriptPart() {
        return this._scriptPartId;
    }

    public IGosuClassInternal getGosuClass() {
        return this._scriptPartId != null ? (this._scriptPartId.getContainingType() instanceof IGosuClassInternal ? (IGosuClassInternal)this._scriptPartId.getContainingType() : (IGosuClassInternal)this._scriptPartId.getRuntimeType()) : null;
    }

    public boolean hasTypeVariables() {
        IGenericTypeVariable[] tvs = this.getType().getGenericTypeVariables();
        return tvs != null && tvs.length != 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReducedSymbol that = (ReducedSymbol)o;
        if (this._isStatic != that._isStatic) {
            return false;
        }
        if (this._modifiers != that._modifiers) {
            return false;
        }
        if (this._displayName != null ? !this._displayName.equals(that._displayName) : that._displayName != null) {
            return false;
        }
        if (this._fullDescription != null ? !this._fullDescription.equals(that._fullDescription) : that._fullDescription != null) {
            return false;
        }
        if (this._name != null ? !this._name.equals(that._name) : that._name != null) {
            return false;
        }
        if (this._scriptPartId != null ? !this._scriptPartId.equals(that._scriptPartId) : that._scriptPartId != null) {
            return false;
        }
        if (this._symClass != null ? !this._symClass.equals(that._symClass) : that._symClass != null) {
            return false;
        }
        return !(this._type != null ? !this._type.equals(that._type) : that._type != null);
    }

    public static List<ISymbol> makeArgs(List<IReducedSymbol> args) {
        ArrayList<ISymbol> newArgs = new ArrayList<ISymbol>(args.size());
        for (IReducedSymbol arg : args) {
            newArgs.add((ISymbol)new SyntheticSymbol(arg, arg.getName(), arg.getType(), null));
        }
        return newArgs;
    }

    public static class SyntheticSymbol
    extends Symbol {
        IReducedSymbol _reducedSym;

        public SyntheticSymbol(IReducedSymbol reducedSym, String name, IType type, IExpression defaultValue) {
            super(name, type, defaultValue);
            this._reducedSym = reducedSym;
        }

        public IReducedSymbol getReducedSymbol() {
            return this._reducedSym;
        }
    }
}

