/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.java.JavaTypes;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

public class RepeatableContainerAnnotationInfo
implements IAnnotationInfo {
    private IType _owner;
    private IAnnotationInfo[] _annotations;
    private IType _container;

    public RepeatableContainerAnnotationInfo(IAnnotationInfo[] annotations, IType container, IType owner) {
        this._annotations = annotations;
        this._container = container;
        this._owner = owner;
    }

    public String getName() {
        return this._container.getName();
    }

    public IType getOwnersType() {
        return this._owner;
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getDescription() {
        return this.getName();
    }

    public Annotation getInstance() {
        return this.makeAnnotationInfoProxy();
    }

    private Annotation makeAnnotationInfoProxy() {
        throw new IllegalStateException("Should not need to get runtime version of this annotation, use the IAnnotationInfo API.");
    }

    public Object getFieldValue(String fieldName) {
        boolean value = fieldName.equals("value");
        assert (value);
        try {
            return this._annotations;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public IType getType() {
        return this._container;
    }

    public String toString() {
        return this.getName();
    }

    public boolean retainInBytecode() {
        List annotations = this._container.getTypeInfo().getAnnotationsOfType((IType)JavaTypes.getJreType(Retention.class));
        if (annotations != null) {
            for (IAnnotationInfo annotationInfo : annotations) {
                String fieldValue = (String)annotationInfo.getFieldValue("value");
                if (fieldValue.equals(RetentionPolicy.SOURCE.name())) continue;
                return true;
            }
        }
        return false;
    }
}

