/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.config.CommonServices;
import gw.lang.parser.EvaluationException;
import gw.lang.reflect.BaseFeatureInfo;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IPresentationInfo;
import gw.lang.reflect.IPropertyAccessor;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.util.GosuExceptionUtil;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;

public class StaticPropertyInfo
extends BaseFeatureInfo
implements IPropertyInfo {
    private Method _getter;
    private Method _setter;
    private IType _propertyType;
    private String _strName;
    private String _deprecated;
    private IType _type;
    private IPropertyAccessor _accessor;

    StaticPropertyInfo(IFeatureInfo container, IType type, IType propertyType, String strName, String strGetter, String strSetter, String deprecated) throws NoSuchMethodException {
        super(container);
        this._type = type;
        this._propertyType = propertyType;
        this._strName = strName;
        this._deprecated = deprecated;
        this._accessor = new StaticAccessor(strGetter, strSetter);
    }

    public String getName() {
        return this._strName;
    }

    public IType getFeatureType() {
        return this._propertyType;
    }

    public List<IAnnotationInfo> getDeclaredAnnotations() {
        return Collections.emptyList();
    }

    public boolean isScriptable() {
        return true;
    }

    public boolean isStatic() {
        return true;
    }

    public boolean isReadable() {
        return true;
    }

    public boolean isWritable(IType whosAskin) {
        return this._setter != null;
    }

    public boolean isWritable() {
        return this.isWritable(null);
    }

    public boolean isDeprecated() {
        return this._deprecated != null;
    }

    public String getDeprecatedReason() {
        return this._deprecated;
    }

    public IPropertyAccessor getAccessor() {
        return this._accessor;
    }

    public IPresentationInfo getPresentationInfo() {
        return IPresentationInfo.Default.GET;
    }

    private class StaticAccessor
    implements IPropertyAccessor {
        private StaticAccessor(String strGetter, String strSetter) throws NoSuchMethodException {
            Class<?> intrinsicTypeClass = StaticPropertyInfo.this._type.getClass();
            StaticPropertyInfo.this._getter = intrinsicTypeClass.getMethod(strGetter, null);
            if (strSetter != null && strSetter.length() > 0) {
                StaticPropertyInfo.this._setter = intrinsicTypeClass.getMethod(strSetter, StaticPropertyInfo.this._getter.getReturnType());
            }
            if (StaticPropertyInfo.this._propertyType == null) {
                StaticPropertyInfo.this._propertyType = TypeSystem.get(StaticPropertyInfo.this._getter.getReturnType());
            }
        }

        public Object getValue(Object ctx) {
            try {
                return StaticPropertyInfo.this._getter.invoke((Object)StaticPropertyInfo.this._type, null);
            }
            catch (Exception e) {
                throw GosuExceptionUtil.forceThrow((Throwable)e);
            }
        }

        public void setValue(Object ctx, Object value) {
            if (!StaticPropertyInfo.this.isWritable(StaticPropertyInfo.this.getOwnersType())) {
                throw new EvaluationException("Property, " + StaticPropertyInfo.this.getName() + ", is not writable!");
            }
            try {
                value = CommonServices.getCoercionManager().convertValue(value, StaticPropertyInfo.this.getFeatureType());
                StaticPropertyInfo.this._setter.invoke((Object)StaticPropertyInfo.this._type, value);
            }
            catch (Exception e) {
                throw GosuExceptionUtil.forceThrow((Throwable)e);
            }
        }
    }
}

