/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.expressions;

import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.statements.ClassStatement;
import gw.lang.parser.statements.IClassDeclaration;
import gw.util.StringPool;

public class ClassDeclaration
extends Expression
implements IClassDeclaration {
    private final CharSequence _className;
    private IGosuClassInternal _gsClass;

    public ClassDeclaration(CharSequence className) {
        this._className = className instanceof String ? StringPool.get((String)((String)className)) : className;
    }

    public CharSequence getClassName() {
        return this._className;
    }

    public String getName() {
        return this.getClassName().toString();
    }

    @Override
    public Object evaluate() {
        return null;
    }

    @Override
    public String toString() {
        return this.getClassName().toString();
    }

    public int getNameOffset(String identifierName) {
        return this.getLocation().getOffset();
    }

    public void setNameOffset(int iOffset, String identifierName) {
        throw new UnsupportedOperationException();
    }

    public String[] getDeclarations() {
        IGosuClassInternal gsClass = this.getGSClass();
        return new String[]{gsClass.getRelativeName()};
    }

    public boolean declares(String identifierName) {
        IGosuClassInternal gsClass = this.getGSClass();
        return identifierName != null && (identifierName.equals(gsClass.getName()) || identifierName.equals(gsClass.getRelativeName()));
    }

    public IGosuClassInternal getGSClass() {
        if (this._gsClass == null) {
            if (!(this.getParent() instanceof ClassStatement)) {
                throw new RuntimeException("Class declaration's parent must be ClassStatement but was " + this.getParent());
            }
            this._gsClass = ((ClassStatement)this.getParent()).getGosuClass();
        }
        return this._gsClass;
    }
}

