/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.expressions;

import gw.config.CommonServices;
import gw.internal.gosu.parser.ParserBase;
import gw.internal.gosu.parser.expressions.BinaryExpression;
import gw.internal.gosu.parser.expressions.DimensionOperandResolver;
import gw.lang.parser.IGosuParser;
import gw.lang.parser.expressions.IConditionalExpression;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.java.JavaTypes;

public abstract class ConditionalExpression
extends BinaryExpression
implements IConditionalExpression {
    private IMethodInfo _override;

    public ConditionalExpression() {
        this.setType((IType)JavaTypes.pBOOLEAN());
    }

    public IMethodInfo getOverride() {
        return this._override;
    }

    public void setOverride(IMethodInfo overrideMi) {
        this._override = overrideMi;
    }

    @Override
    public boolean isCompileTimeConstant() {
        return this.getLHS().isCompileTimeConstant() && this.getRHS().isCompileTimeConstant();
    }

    public static int compareNumbers(Object lhsValue, Object rhsValue, IType lhsType, IType rhsType) {
        if (JavaTypes.COMPARABLE().isAssignableFrom(lhsType) && lhsType == rhsType) {
            return ((Comparable)lhsValue).compareTo(rhsValue);
        }
        lhsType = ParserBase.resolveType(lhsType, 62, rhsType);
        try {
            if (JavaTypes.IDIMENSION().isAssignableFrom(lhsType)) {
                DimensionOperandResolver customNumberResolver = DimensionOperandResolver.resolve(lhsType, lhsType, lhsValue, rhsType, rhsValue);
                lhsType = customNumberResolver.getRawNumberType();
                lhsValue = customNumberResolver.getLhsValue();
                rhsValue = customNumberResolver.getRhsValue();
            }
            if (lhsType == JavaTypes.BIG_DECIMAL()) {
                return CommonServices.getCoercionManager().makeBigDecimalFrom(lhsValue).compareTo(CommonServices.getCoercionManager().makeBigDecimalFrom(rhsValue));
            }
            if (lhsType == JavaTypes.BIG_INTEGER()) {
                return CommonServices.getCoercionManager().makeBigIntegerFrom(lhsValue).compareTo(CommonServices.getCoercionManager().makeBigIntegerFrom(rhsValue));
            }
            if (lhsType == JavaTypes.INTEGER() || lhsType == JavaTypes.pINT()) {
                return CommonServices.getCoercionManager().makeIntegerFrom(lhsValue).compareTo(CommonServices.getCoercionManager().makeIntegerFrom(rhsValue));
            }
            if (lhsType == JavaTypes.LONG() || lhsType == JavaTypes.pLONG()) {
                return CommonServices.getCoercionManager().makeLongFrom(lhsValue).compareTo(CommonServices.getCoercionManager().makeLongFrom(rhsValue));
            }
            if (lhsType == JavaTypes.DOUBLE() || lhsType == JavaTypes.pDOUBLE()) {
                return CommonServices.getCoercionManager().makeDoubleFrom(lhsValue).compareTo(CommonServices.getCoercionManager().makeDoubleFrom(rhsValue));
            }
            if (lhsType == JavaTypes.FLOAT() || lhsType == JavaTypes.pFLOAT()) {
                float f2;
                float f1 = CommonServices.getCoercionManager().makePrimitiveFloatFrom(lhsValue);
                return f1 > (f2 = CommonServices.getCoercionManager().makePrimitiveFloatFrom(rhsValue)) ? 1 : (f1 < f2 ? -1 : 0);
            }
            if (lhsType == JavaTypes.SHORT() || lhsType == JavaTypes.pSHORT()) {
                return CommonServices.getCoercionManager().makeIntegerFrom(lhsValue).compareTo(CommonServices.getCoercionManager().makeIntegerFrom(rhsValue));
            }
            if (lhsType == JavaTypes.BYTE() || lhsType == JavaTypes.pBYTE()) {
                return CommonServices.getCoercionManager().makeIntegerFrom(lhsValue).compareTo(CommonServices.getCoercionManager().makeIntegerFrom(rhsValue));
            }
        }
        catch (NumberFormatException nfe) {
            rhsValue = IGosuParser.ZERO;
        }
        return CommonServices.getCoercionManager().makeDoubleFrom(lhsValue).compareTo(CommonServices.getCoercionManager().makeDoubleFrom(rhsValue));
    }

    @Override
    public IType getType() {
        return JavaTypes.pBOOLEAN();
    }

    @Override
    protected IType getTypeImpl() {
        return JavaTypes.pBOOLEAN();
    }
}

