/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.expressions;

import gw.config.CommonServices;
import gw.internal.gosu.parser.BeanAccess;
import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.Statement;
import gw.lang.parser.EvaluationException;
import gw.lang.parser.exceptions.ParseException;
import gw.lang.parser.expressions.IInitializerAssignment;
import gw.lang.parser.statements.ITerminalStatement;
import gw.lang.reflect.IAttributedFeatureInfo;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.JavaTypes;
import gw.util.GosuExceptionUtil;
import java.util.Collection;
import java.util.Map;

public final class InitializerAssignment
extends Statement
implements IInitializerAssignment {
    private IType _ownerType;
    private String _propertyName;
    private Expression _rhs;
    private IPropertyInfo _pi;

    public InitializerAssignment(IType ownerType, String propertyName) {
        this._ownerType = ownerType;
        this._propertyName = propertyName;
    }

    public IType getOwnerType() {
        return this._ownerType;
    }

    public String getPropertyName() {
        return this._propertyName;
    }

    @Override
    public String toString() {
        return this._propertyName;
    }

    public Expression getRhs() {
        return this._rhs;
    }

    public void setRhs(Expression rhs) {
        this._rhs = rhs;
    }

    @Override
    protected ITerminalStatement getLeastSignificantTerminalStatement_internal(boolean[] bAbsolute) {
        bAbsolute[0] = false;
        return null;
    }

    @Override
    public Object execute() {
        return null;
    }

    public void execute(Object contextValue) {
        ITypeInfo typeInfo = this.getOwnerType().getTypeInfo();
        if (typeInfo == null) {
            throw new EvaluationException("No type info found for, " + this.getOwnerType().getName());
        }
        IPropertyInfo pi = this.getPropertyInfo();
        if (pi != null && !BeanAccess.isDescriptorHidden((IAttributedFeatureInfo)pi)) {
            if (!pi.isWritable()) {
                if (JavaTypes.COLLECTION().isAssignableFrom(pi.getFeatureType())) {
                    this.addAll(contextValue, pi);
                } else if (JavaTypes.MAP().isAssignableFrom(pi.getFeatureType())) {
                    this.putAll(contextValue, pi);
                }
            } else {
                Object value = this.getValue(pi);
                pi.getAccessor().setValue(contextValue, value);
            }
        } else {
            throw new EvaluationException("No writable property descriptor found for property, " + this.getPropertyName() + ", on class, " + TypeSystem.getUnqualifiedClassName((IType)this.getOwnerType()));
        }
    }

    public IPropertyInfo getPropertyInfo() {
        try {
            return this._pi != null ? this._pi : BeanAccess.getPropertyInfo(this.getOwnerType(), this.getPropertyName(), null, null, null);
        }
        catch (ParseException e) {
            return null;
        }
    }

    private void putAll(Object contextValue, IPropertyInfo pi) {
        Map value = (Map)this.getValue(pi);
        Map existingMap = (Map)pi.getAccessor().getValue(contextValue);
        if (existingMap == null) {
            throw new EvaluationException(this.getPropertyName() + ", on class, " + TypeSystem.getUnqualifiedClassName((IType)this.getOwnerType()) + "is not writable and does not have a current Map value to add values to.");
        }
        existingMap.putAll(value);
    }

    private void addAll(Object contextValue, IPropertyInfo pi) {
        Collection value = (Collection)this.getValue(pi);
        Collection existingCollection = null;
        if (pi.isReadable()) {
            existingCollection = (Collection)pi.getAccessor().getValue(contextValue);
        }
        if (existingCollection == null) {
            throw new EvaluationException(this.getPropertyName() + ", on class, " + TypeSystem.getUnqualifiedClassName((IType)this.getOwnerType()) + "is not writable and does not have a current Collection value to add values to.");
        }
        existingCollection.addAll(value);
    }

    private Object getValue(IPropertyInfo pi) {
        Object value;
        try {
            value = this._rhs.evaluate();
        }
        catch (Exception e) {
            throw GosuExceptionUtil.forceThrow((Throwable)e);
        }
        value = CommonServices.getCoercionManager().convertValue(value, pi.getFeatureType());
        return value;
    }

    public void setPropertyInfo(IPropertyInfo propertyInfo) {
        this._pi = propertyInfo;
    }
}

