/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.expressions;

import gw.internal.gosu.parser.Expression;
import gw.lang.parser.IExpression;
import gw.lang.parser.expressions.IMapInitializerExpression;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MapInitializerExpression
extends Expression
implements IMapInitializerExpression {
    private ArrayList<IExpression> _keys;
    private ArrayList<IExpression> _values;

    @Override
    public Object evaluate() {
        return null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this._keys != null) {
            for (int i = 0; i < this._keys.size(); ++i) {
                IExpression key = this._keys.get(i);
                sb.append(key.toString());
                sb.append("->");
                IExpression value = this._values.get(i);
                sb.append(value.toString());
                if (i >= this._keys.size() - 1) continue;
                sb.append(", ");
            }
        }
        sb.append("}");
        return sb.toString();
    }

    public void initialize(Object newObject) {
        if (this._keys != null) {
            Map map = (Map)newObject;
            for (int i = 0; i < this._keys.size(); ++i) {
                IExpression keyExpr = this._keys.get(i);
                Object key = keyExpr.evaluate();
                IExpression valueExpr = this._values.get(i);
                Object value = valueExpr.evaluate();
                map.put(key, value);
            }
        }
    }

    public void add(Expression key, Expression value) {
        if (this._keys == null) {
            this._keys = new ArrayList();
            this._values = new ArrayList();
        }
        this._keys.add(key);
        this._values.add(value);
    }

    public void addFirst(Expression key, Expression value) {
        if (this._keys == null) {
            this._keys = new ArrayList();
            this._values = new ArrayList();
        }
        this._keys.add(0, key);
        this._values.add(0, value);
    }

    public List<IExpression> getKeys() {
        return this._keys;
    }

    public List<IExpression> getValues() {
        return this._values;
    }
}

